import os, xbmc, xbmcaddon

#########################################################
### User Edit Variables #################################
#########################################################
ADDON_ID       = xbmcaddon.Addon().getAddonInfo('id')
ADDONTITLE     = 'DaHenchmen Wizard'
EXCLUDES       = [ADDON_ID, 'repository.dahenchmen']
# Text File with build info in it.
BUILDFILE      = 'http://dahenchmen.xyz/wizards/Henchmen/texts/autobuilds.txt'
# How often you would list it to check for build updates in days
# 0 being every startup of kodi
UPDATECHECK    = 0
# Text File with apk info in it.
APKFILE      = 'http://dahenchmen.xyz/wizards/Henchmen/texts/apk.txt'

# Dont need to edit just here for icons stored locally
HOME           = xbmc.translatePath('special://home/')
PLUGIN         = os.path.join(HOME,     'addons',    ADDON_ID)
ART            = os.path.join(PLUGIN,   'resources', 'art')

#########################################################
### THEMING MENU ITEMS ##################################
#########################################################
# If you want to use locally stored icons the place them in the Resources/Art/
# folder of the wizard then use os.path.join(ART, 'imagename.png')
# do not place quotes around os.path.join
# Example:  ICONMAINT     = os.path.join(ART, 'mainticon.png')
#           ICONSETTINGS  = 'http://aftermathwizard.net/repo/wizard/settings.png'
# Leave as http:// for default icon
ICONMAINT      = 'http://mikemyerz.com/01/wizards/MMyerz/images/maintenance.png'
ICONBUILDS     = 'http://mikemyerz.com/01/wizards/MMyerz/images/build.png'
ICONCONTACT    = 'http://mikemyerz.com/01/wizards/MMyerz/images/henchmen.png'
ICONSAVE       = 'http://mikemyerz.com/01/wizards/MMyerz/images/backup.png'
ICONTRAKT      = 'http://mikemyerz.com/01/wizards/MMyerz/images/backup.png'
ICONREAL       = 'http://mikemyerz.com/01/wizards/MMyerz/images/backup.png'
ICONLOGIN      = 'http://mikemyerz.com/01/wizards/MMyerz/images/settings.png'
ICONAPK        = 'http://mikemyerz.com/01/wizards/MMyerz/images/icon.png'
ICONSETTINGS   = 'http://mikemyerz.com/01/wizards/MMyerz/images/settings.png'
# Hide the ====== seperators 'Yes' or 'No'
HIDESPACERS    = 'No'

# You can edit these however you want, just make sure that you have a %s in each of the
# THEME's so it grabs the text from the menu item
COLOR1         = 'red'
COLOR2         = 'white'
# Primary menu items   / %s is the menu item and is required
THEME1         = '[COLOR '+COLOR1+'][DaHenchmen][/COLOR] [COLOR '+COLOR2+']%s[/COLOR]'
# Build Names          / %s is the menu item and is required
THEME2         = '[COLOR '+COLOR2+']%s[/COLOR]'
# Alternate items      / %s is the menu item and is required
THEME3         = '[COLOR '+COLOR1+']%s[/COLOR]'
# Current Build Header / %s is the menu item and is required
THEME4         = '[COLOR '+COLOR1+']Current Build:[/COLOR] [COLOR '+COLOR2+']%s[/COLOR]'
# Current Theme Header / %s is the menu item and is required
THEME5         = '[COLOR '+COLOR1+']Current Theme:[/COLOR] [COLOR '+COLOR2+']%s[/COLOR]'

# Message for Contact Page
# Enable 'Contact' menu item 'Yes' hide or 'No' dont hide
HIDECONTACT    = 'No'
# You can add \n to do line breaks
CONTACT        = 'Thank you for choosing DaHenchmen Buildz.\r\n\r\nContact Us:\r\n FORUM http://dahenchmen.info\r\n FACEBOOK https://www.facebook.com/groups/dahenchmen/\r\n DaHenchmen Official Twitter: @DaHenchmen\r\n MikeMyerz Twitter: @M1k3_My3rz\r\n Soulless Twitter: @SoullessBuilds\r\n Ruthless Twitter: @RB_DaHenchmen\r\n\r\nDonate to DaHenchmen:\r\n\r\nTo donate to DaHenchmen: Please specify in the notes who you are donating to, either  DaHenchmen, Mike Myerz, Soulless, or Ruthless\r\ndonate to Mike Myerz or DaHenchmen:https://www.paypal.me/MMyerz\r\ndonate Soulless or DaHenchmen: https://www.paypal.me/TheSoullessBuilds\r\ndonate Ruthless or DaHenchmen: paypal.me/RuthlessDahenchmen\r\n\r\n'
#########################################################

#########################################################
### AUTO UPDATE #########################################
########## FOR THOSE WITH NO REPO #######################
# Enable Auto Update 'Yes' or 'No'
AUTOUPDATE     = 'Yes'
# Url to wizard version
WIZARDFILE     = 'http://dahenchmen.xyz/wizards/Henchmen/texts/autobuilds.txt'
#########################################################

#########################################################
### AUTO INSTALL ########################################
########## REPO IF NOT INSTALLED ########################
# Enable Auto Install 'Yes' or 'No'
AUTOINSTALL    = 'Yes'
# Addon ID for the repository
REPOID         = 'repository.dahenchmen'
# Url to Addons.xml file in your repo folder(this is so we can get the latest version)
REPOADDONXML   = 'http://dahenchmen.xyz/Add-ons/addons.xml'
# Url to folder zip is located in
REPOZIPURL     = 'http://dahenchmen.xyz/repo/'
#########################################################

#########################################################
### NOTIFICATION WINDOW##################################
#########################################################
# Enable Notification screen Yes or No
ENABLE         = 'Yes'
# Url to notification file
NOTIFICATION   = 'http://dahenchmen.xyz/wizards/Henchmen/texts/notify.txt'
# Use either 'Text' or 'Image'
HEADERTYPE     = 'Image'
# Font size of header
FONTHEADER     = ''
HEADERMESSAGE  = ''
# url to image if using Image 424x180
HEADERIMAGE    = 'http://mikemyerz.com/01/wizards/MMyerz/images/header.png'
# Font for Notification Window
FONTSETTINGS   = 'Font12'
# Background for Notification Window
BACKGROUND     = 'http://mikemyerz.com/01/wizards/MMyerz/images/fanart0.jpg'
#########################################################