# -*- coding: utf-8 -*-
import requests
import json
import urllib
from xbmcswift2 import Plugin, xbmcplugin


plugin = Plugin()


@plugin.cached(TTL=60*24)
def get_json():
    req = requests.get('http://nirelbaz.com/kodi/data/playlists.json')
    return json.loads(req.text)


@plugin.route('/')
def index():
    """
    Shows channels list
    :return:
    """
    categories = []

    # Add native items
    for index, category in enumerate(get_json()):
        try:
            bg_image = urllib.quote(category['bgImage'], safe=':/?=')
        except:
            bg_image = plugin.addon.getAddonInfo('fanart')
            pass

        categories.append({
            'label': u'{0} - {1}'.format(category['title'].upper(), category['slogan']),
            'icon': bg_image,
            'thumbnail': bg_image,
            'path': plugin.url_for('show_playlists', index=index),
            'is_playable': False,
            'properties': {
                'Fanart_Image': bg_image,
                'Artist_Description': category['slogan']
            }
        })

    return plugin.finish(categories)


@plugin.route('/channels/<index>/playlists')
def show_playlists(index):
    """
    Shows playlists in a channel
    :param index: Channel index
    :return:
    """
    playlists = []

    for idx, playlist in enumerate(get_json()[int(index)]['playlists']):
        try:
            bg_image = urllib.quote(playlist['bgImage'], safe=':/?=')
        except:
            bg_image = plugin.addon.getAddonInfo('fanart')
            pass

        playlists.append({
            'label': u'{0} - {1}'.format(playlist['title'].upper(), playlist['slogan']),
            'icon': bg_image,
            'thumbnail': bg_image,
            'path': urllib.quote(playlist['songs'][0]['url'], safe=':/?='),
            'is_playable': True,
            'properties': {
                'poster': bg_image,
                'thumb': bg_image,
                'fanart': bg_image,
                'Fanart_Image': bg_image,
                'mimetype': 'audio/mpeg',

            },
            'info': {
                'Title': playlist['title'],
                'Artist': playlist['slogan'],
                'Artist_Description': playlist['slogan']
            }
        })
    return plugin.finish(playlists)


if __name__ == '__main__':
    plugin.run()
    xbmcplugin.setContent(plugin.handle, 'audio')
