/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.views;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xwt.ILoadingContext;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.ui.ExceptionHandle;
import org.eclipse.xwt.ui.XWTUIPlugin;
import org.eclipse.xwt.ui.views.IContentProvider;
import org.eclipse.xwt.ui.views.ProjectContentProvider;

public class XWTView
extends ViewPart {
    public static final String ID = "org.eclipse.xwt.ui.views.XWTView";
    protected Composite container;
    protected Map<String, Object> options = new HashMap<String, Object>();

    public XWTView() {
        this.options.put("XWT.DesignMode", Boolean.TRUE);
    }

    public void createPartControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(1808));
        this.container.setLayout((Layout)new GridLayout());
        this.container.setBackgroundMode(1);
    }

    public void setContent(String code, IFile file) {
        try {
            this.setContentWithException(code, file, new ProjectContentProvider(file));
        }
        catch (Exception e) {
            ExceptionHandle.handle(e, "Open view fails");
        }
    }

    public void setContentWithException(String code, IFile file, IContentProvider contentProvider) throws Exception {
        XWTUIPlugin.checkStartup();
        Control[] controlArray = this.container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        ILoadingContext loadingContext = contentProvider.getLoadingContext();
        if (loadingContext != null) {
            XWT.setLoadingContext((ILoadingContext)loadingContext);
        }
        this.options.put("XWT.Container", this.container);
        if (code != null) {
            XWT.loadWithOptions((InputStream)new ByteArrayInputStream(code.getBytes()), (URL)file.getLocation().toFile().toURL(), this.options);
        } else {
            XWT.loadWithOptions((URL)file.getLocation().toFile().toURL(), this.options);
        }
        this.container.layout(true, true);
    }

    public void setContentWithException(String code, IFile file) throws Exception {
        this.setContentWithException(code, file, new ProjectContentProvider(file));
    }

    public void setFocus() {
    }
}

