/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.utils;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.xwt.ui.utils.AbstractBuilder;

public class LibraryBuilder
extends AbstractBuilder {
    private String[] libraries;

    public LibraryBuilder(IProject project, String[] libraries) {
        super(project);
        this.libraries = libraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus build() {
        if (this.libraries == null || this.libraries.length == 0) {
            return Status.CANCEL_STATUS;
        }
        try {
            WorkspaceBundleModel bundleModel;
            this.refreshLocal();
            IBundlePluginModelBase model = (IBundlePluginModelBase)this.getModel();
            IPluginBase pluginBase = model.getPluginBase();
            WorkspaceBundleModel workspaceBundleModel = bundleModel = (WorkspaceBundleModel)model.getBundleModel();
            synchronized (workspaceBundleModel) {
                bundleModel.load();
                boolean isNonEdit = bundleModel.isEditable();
                if (!isNonEdit) {
                    bundleModel.setEditable(true);
                }
                String[] stringArray = this.libraries;
                int n = this.libraries.length;
                int n2 = 0;
                while (n2 < n) {
                    String libPath = stringArray[n2];
                    IPluginLibrary library = model.getPluginFactory().createLibrary();
                    library.setName(libPath.toString());
                    library.setExported(true);
                    pluginBase.add(library);
                    ++n2;
                }
                this.checkSourceRootEntry();
                this.updateBuildProperties(new String[this.libraries.length], this.libraries, false);
                this.updateJavaClasspathLibs(new String[this.libraries.length], this.libraries);
                bundleModel.save();
                if (!isNonEdit) {
                    bundleModel.setEditable(false);
                }
            }
            this.buildClean();
        }
        catch (CoreException e) {
            this.error(e.getMessage());
        }
        return Status.OK_STATUS;
    }

    private void checkSourceRootEntry() {
        IBundlePluginModelBase pluginModel = (IBundlePluginModelBase)this.getModel();
        IPluginLibrary[] libraries = pluginModel.getPluginBase().getLibraries();
        int i = 0;
        while (i < libraries.length) {
            if (libraries[i].getName().equals(".")) {
                return;
            }
            ++i;
        }
        IBuildModel model = pluginModel.getBuildModel();
        if (model == null) {
            return;
        }
        IBuildEntry[] entires = model.getBuild().getBuildEntries();
        int i2 = 0;
        while (i2 < entires.length) {
            if (entires[i2].getName().equals("source..")) {
                IPluginLibrary library = pluginModel.getPluginFactory().createLibrary();
                try {
                    library.setName(".");
                    pluginModel.getPluginBase().add(library);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++i2;
        }
    }

    private IBuildModel getBuildModel() {
        IBundlePluginModelBase pluginModel = (IBundlePluginModelBase)this.getModel();
        if (pluginModel != null) {
            return pluginModel.getBuildModel();
        }
        return null;
    }

    private void updateBuildProperties(String[] oldPaths, String[] newPaths, boolean modifySourceEntry) {
        IBuildModel bmodel = this.getBuildModel();
        if (bmodel == null) {
            return;
        }
        IBuild build = bmodel.getBuild();
        IBuildEntry entry = build.getEntry("bin.includes");
        if (entry == null) {
            entry = bmodel.getFactory().createEntry("bin.includes");
        }
        try {
            if (oldPaths[0] == null) {
                int i = 0;
                while (i < newPaths.length) {
                    if (newPaths[i] != null) {
                        entry.addToken(newPaths[i]);
                        if (modifySourceEntry) {
                            this.configureSourceBuildEntry(bmodel, null, newPaths[i]);
                        }
                    }
                    ++i;
                }
            } else if (newPaths[0] == null) {
                int i = 0;
                while (i < oldPaths.length) {
                    if (oldPaths[i] != null) {
                        entry.removeToken(oldPaths[i]);
                        if (modifySourceEntry) {
                            this.configureSourceBuildEntry(bmodel, oldPaths[i], null);
                        }
                    }
                    ++i;
                }
                if (entry.getTokens().length == 0) {
                    build.remove(entry);
                }
            } else {
                int i = 0;
                while (i < oldPaths.length) {
                    if (newPaths[i] != null && oldPaths[i] != null) {
                        entry.renameToken(oldPaths[i], newPaths[i]);
                        if (modifySourceEntry) {
                            this.configureSourceBuildEntry(bmodel, oldPaths[i], newPaths[i]);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void configureSourceBuildEntry(IBuildModel bmodel, String oldPath, String newPath) throws CoreException {
        IBuild build = bmodel.getBuild();
        IBuildEntry entry = build.getEntry("source." + (oldPath != null ? oldPath : newPath));
        try {
            if (newPath != null) {
                if (entry == null) {
                    IJavaProject jproject = JavaCore.create((IProject)this.project);
                    ArrayList<String> tokens = new ArrayList<String>();
                    IClasspathEntry[] entries = jproject.getRawClasspath();
                    int i = 0;
                    while (i < entries.length) {
                        if (entries[i].getEntryKind() == 3) {
                            tokens.add(entries[i].getPath().removeFirstSegments(1).addTrailingSeparator().toString());
                        }
                        ++i;
                    }
                    if (tokens.size() == 0) {
                        return;
                    }
                    entry = bmodel.getFactory().createEntry("source." + newPath);
                    i = 0;
                    while (i < tokens.size()) {
                        entry.addToken((String)tokens.get(i));
                        ++i;
                    }
                    build.add(entry);
                } else {
                    entry.setName("source." + newPath);
                }
            } else if (entry != null && newPath == null) {
                build.remove(entry);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void updateJavaClasspathLibs(String[] oldPaths, String[] newPaths) {
        IJavaProject jproject = JavaCore.create((IProject)this.project);
        try {
            IClasspathEntry[] entries = jproject.getRawClasspath();
            ArrayList<IClasspathEntry> toBeAdded = new ArrayList<IClasspathEntry>();
            int index = -1;
            int i = 0;
            while (i < entries.length) {
                block13: {
                    if (entries[i].getEntryKind() == 1) {
                        if (index == -1) {
                            index = i;
                        }
                        IPath path = entries[i].getPath().removeFirstSegments(1).removeTrailingSeparator();
                        int j = 0;
                        while (j < oldPaths.length) {
                            if (oldPaths[j] == null || !path.equals((Object)new Path(oldPaths[j]).removeTrailingSeparator())) {
                                ++j;
                                continue;
                            }
                            break block13;
                        }
                    } else if (entries[i].getEntryKind() == 5 && index == -1) {
                        index = i;
                    }
                    toBeAdded.add(entries[i]);
                }
                ++i;
            }
            if (index == -1) {
                index = entries.length;
            }
            i = 0;
            while (i < newPaths.length) {
                IClasspathEntry entry;
                if (newPaths[i] != null && !toBeAdded.contains(entry = JavaCore.newLibraryEntry((IPath)this.project.getFullPath().append(newPaths[i]), null, null, (boolean)true))) {
                    toBeAdded.add(index++, entry);
                }
                ++i;
            }
            if (toBeAdded.size() == entries.length) {
                return;
            }
            IClasspathEntry[] updated = toBeAdded.toArray(new IClasspathEntry[toBeAdded.size()]);
            jproject.setRawClasspath(updated, null);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus unbuild() {
        if (this.libraries == null || this.libraries.length == 0) {
            return this.warning("No library found.");
        }
        IPluginModelBase pluginModel = this.getModel();
        IBundlePluginModelBase model = (IBundlePluginModelBase)pluginModel;
        IPluginBase pluginBase = model.getPluginBase();
        IPluginLibrary[] exists = pluginBase.getLibraries();
        ArrayList<IPluginLibrary> libForRemove = new ArrayList<IPluginLibrary>();
        IPluginLibrary[] iPluginLibraryArray = exists;
        int n = exists.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary pluginLibrary = iPluginLibraryArray[n2];
            String[] stringArray = this.libraries;
            int n3 = this.libraries.length;
            int n4 = 0;
            while (n4 < n3) {
                String libName = stringArray[n4];
                if (pluginLibrary.getName().equals(libName)) {
                    libForRemove.add(pluginLibrary);
                }
                ++n4;
            }
            ++n2;
        }
        if (libForRemove.isEmpty()) {
            return this.warning("No library found.");
        }
        try {
            WorkspaceBundleModel bundleModel;
            this.refreshLocal();
            WorkspaceBundleModel workspaceBundleModel = bundleModel = (WorkspaceBundleModel)model.getBundleModel();
            synchronized (workspaceBundleModel) {
                bundleModel.load();
                boolean isNonEdit = bundleModel.isEditable();
                if (!isNonEdit) {
                    bundleModel.setEditable(true);
                }
                String[] remove = new String[libForRemove.size()];
                int i = 0;
                IBundle bundle = bundleModel.getBundle();
                for (IPluginLibrary pluginLibrary : libForRemove) {
                    pluginBase.remove(pluginLibrary);
                    String name = pluginLibrary.getName();
                    remove[i++] = name;
                }
                this.removeLibraries(bundle, remove);
                bundleModel.save();
                if (!isNonEdit) {
                    bundleModel.setEditable(false);
                }
                this.updateBuildProperties(remove, new String[remove.length], true);
                this.updateJavaClasspathLibs(remove, new String[remove.length]);
            }
            this.buildClean();
        }
        catch (CoreException e) {
            this.error(e.getMessage());
        }
        return Status.OK_STATUS;
    }

    private void removeLibraries(IBundle bundle, String[] remove) {
        String oldValue = bundle.getHeader("Bundle-ClassPath");
        if (oldValue == null || oldValue.equals("")) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(oldValue, ",");
        while (stk.hasMoreTokens()) {
            values.add(stk.nextToken().trim());
        }
        String[] stringArray = remove;
        int n = remove.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            values.remove(r);
            ++n2;
        }
        Object newValue = null;
        int i = 0;
        while (i < values.size()) {
            newValue = newValue == null ? (String)values.get(i) : (String)newValue + "," + (String)values.get(i);
            ++i;
        }
        bundle.setHeader("Bundle-ClassPath", newValue);
    }
}

