/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.actions;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.tools.ui.designer.core.editor.EditDomain;
import org.eclipse.xwt.tools.ui.designer.dialogs.TextValueDialog;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class ChangeTextAction
extends SelectionAction {
    public static final String ID = "org.eclipse.xwt.tools.ui.designer.editor.actions.ChageTextAction";

    public ChangeTextAction(IWorkbenchPart part) {
        super(part);
        this.setText("Change Text");
        this.setId(ID);
    }

    public void run() {
        EditPart editPart = (EditPart)this.getSelectedObjects().get(0);
        Object model = editPart.getModel();
        if (model instanceof XamlElement) {
            XamlElement element = (XamlElement)model;
            if (element == null) {
                return;
            }
            String name = element.getName();
            if (name == null || name.equals("")) {
                return;
            }
            String namespace = element.getNamespace();
            IMetaclass metaclass = XWT.getMetaclass((String)(Character.toUpperCase(name.charAt(0)) + name.substring(1)), (String)namespace);
            IProperty property = metaclass.findProperty("text");
            if (property == null) {
                return;
            }
            XamlAttribute attribute = element.getAttribute("text");
            boolean isNew = false;
            if (attribute == null) {
                attribute = XamlFactory.eINSTANCE.createAttribute("text", "http://www.eclipse.org/xwt/presentation");
                isNew = true;
            }
            String oldValue = attribute.getValue() != null ? attribute.getValue().toString() : null;
            TextValueDialog dialog = new TextValueDialog(new Shell(), oldValue);
            dialog.create();
            dialog.getShell().setText("Set New Text");
            dialog.setTitle("New Text");
            dialog.setMessage("Input a new text value.");
            if (dialog.open() == 0) {
                String newValue = dialog.getNewValue();
                Command cmd = this.createCommand((XamlElement)model, attribute, isNew, oldValue, newValue);
                EditDomain.getEditDomain((EditPart)editPart).getCommandStack().execute(cmd);
            }
        }
    }

    private Command createCommand(final XamlElement element, final XamlAttribute attribute, final boolean isNew, final String oldValue, final String newValue) {
        Command command = new Command(){

            public void execute() {
                attribute.setValue(newValue);
                if (isNew) {
                    element.getAttributes().add((Object)attribute);
                }
            }

            public void undo() {
                attribute.setValue(oldValue);
                if (isNew) {
                    element.getAttributes().add((Object)attribute);
                }
            }
        };
        command.setLabel("Set Text");
        return command;
    }

    protected boolean calculateEnabled() {
        List selectedObjects = this.getSelectedObjects();
        if (selectedObjects.size() != 1) {
            return false;
        }
        Object object = selectedObjects.get(0);
        if (!(object instanceof EditPart) || !(((EditPart)object).getModel() instanceof XamlElement)) {
            return false;
        }
        XamlElement element = (XamlElement)((EditPart)object).getModel();
        IMetaclass metaclass = XWTUtility.getMetaclass((XamlNode)element);
        return metaclass != null && metaclass.findProperty("text") != null;
    }
}

