/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.junit.jupiter.api.Assertions;

public final class RequestsLogger {
    private final List<String> m_events = new ArrayList<String>();

    public void clear() {
        this.m_events.clear();
    }

    public void assertEmpty() {
        Assertions.assertTrue((boolean)this.m_events.isEmpty());
    }

    public void assertEquals(RequestsLogger expectedLogger) {
        Assertions.assertEquals((Object)RequestsLogger.getString(expectedLogger), (Object)RequestsLogger.getString(this));
    }

    public void backAssertEquals(RequestsLogger actualLogger) {
        actualLogger.assertEquals(this);
    }

    private static String getString(RequestsLogger logger) {
        return StringUtils.join(logger.m_events.iterator(), (String)"\n");
    }

    public void log(EditPart source, String event) {
        this.m_events.add(String.valueOf(source) + " = " + event);
    }

    public void log(EditPart source, String event, Request request) {
        StringBuffer buffer = new StringBuffer();
        if (request instanceof SelectionRequest) {
            SelectionRequest selectionRequest = (SelectionRequest)request;
            buffer.append("SelectionRequest(type=");
            buffer.append(selectionRequest.getType());
            buffer.append(", location=");
            buffer.append(selectionRequest.getLocation());
            buffer.append(", stateMask=");
            buffer.append(selectionRequest.getModifiers());
            buffer.append(", button=");
            buffer.append(selectionRequest.getLastButtonPressed());
            buffer.append(")");
        } else {
            buffer.append("Request(type=");
            buffer.append(request.getType());
            buffer.append(")");
        }
        this.m_events.add(String.valueOf(source) + " = " + event + "[ " + String.valueOf(buffer) + " ]");
    }

    public void log(EditPart source, String[] events, Request request) {
        int i = 0;
        while (i < events.length) {
            this.log(source, events[i], request);
            ++i;
        }
    }
}

