/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import java.util.Locale;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.LocalePropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class LocalePropertyEditorTest
extends SwingModelTest {
    @Test
    public void test_setText() throws Exception {
        LocalePropertyEditorTest.setFileContentSrc("test/MyButton.java", this.getTestSource("import java.util.Locale;", "public class MyButton extends JButton {", "  public void setFoo(Locale locale) {", "  }", "}"));
        LocalePropertyEditorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("foo");
        LocalePropertyEditorTest.assertInstanceOf(LocalePropertyEditor.class, (Object)property.getEditor());
        LocalePropertyEditorTest.assertEquals(null, (Object)LocalePropertyEditorTest.getPropertyText(property));
        property.setValue((Object)Locale.GERMAN);
        this.assertEditor("import java.util.Locale;", "public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.setFoo(Locale.GERMAN);", "    add(button);", "  }", "}");
        LocalePropertyEditorTest.assertEquals((Object)Locale.GERMAN.getDisplayName(), (Object)LocalePropertyEditorTest.getPropertyText(property));
    }
}

