/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.burningwave.core.Closeable;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ByteCodeHunter;
import org.burningwave.core.classes.ClassFactoryImpl;
import org.burningwave.core.classes.ClassPathHelper;
import org.burningwave.core.classes.ClassPathHunter;
import org.burningwave.core.classes.Classes;
import org.burningwave.core.classes.JavaMemoryCompiler;
import org.burningwave.core.classes.LoadOrBuildAndDefineConfigAbst;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.classes.SearchConfig;
import org.burningwave.core.classes.UnitSourceGenerator;
import org.burningwave.core.concurrent.QueuedTaskExecutor;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.IterableObjectHelper;

public interface ClassFactory {
    public static ClassFactory create(ByteCodeHunter byteCodeHunter, Supplier<ClassPathHunter> classPathHunterSupplier, JavaMemoryCompiler javaMemoryCompiler, PathHelper pathHelper, ClassPathHelper classPathHelper, Object defaultClassLoaderSupplier, Map<?, ?> config) {
        return new ClassFactoryImpl(byteCodeHunter, classPathHunterSupplier, javaMemoryCompiler, pathHelper, classPathHelper, defaultClassLoaderSupplier, config);
    }

    public ClassRetriever loadOrBuildAndDefine(UnitSourceGenerator ... var1);

    public <L extends LoadOrBuildAndDefineConfigAbst<L>> ClassRetriever loadOrBuildAndDefine(L var1);

    public void closeClassRetrievers();

    public void reset(boolean var1);

    public static class ClassRetriever
    implements Closeable {
        ClassLoader classLoader;
        ClassFactory classFactory;
        Supplier<JavaMemoryCompiler.Compilation.Config> compilationConfigSupplier;
        JavaMemoryCompiler.Compilation.Config compilationConfig;
        AtomicReference<Map<String, ByteBuffer>> byteCodesWrapper;
        Collection<String> uSGClassNames;
        boolean compilationClassPathHasBeenAdded;
        boolean isItPossibleToAddClassPaths;
        Collection<String> classesSearchedInAdditionalClassRepositoriesForClassLoader;
        Collection<String> classesSearchedInCompilationDependenciesPaths;
        Collection<String> additionalClassRepositoriesForClassLoader;
        QueuedTaskExecutor.ProducerTask<JavaMemoryCompiler.Compilation.Result> compilationTask;
        boolean useOneShotJavaCompiler;
        ClassPathHelper classPathHelper;
        JavaMemoryCompiler compiler;

        ClassRetriever(ClassFactory classFactory, Function<ClassRetriever, ClassLoader> classLoaderSupplier, Supplier<JavaMemoryCompiler.Compilation.Config> compileConfigSupplier, boolean useOneShotJavaCompiler, Collection<String> additionalClassRepositoriesForClassLoader, Collection<String> uSGClassNames) {
            this.classLoader = classLoaderSupplier.apply(this);
            this.classFactory = classFactory;
            ((ClassFactoryImpl)this.classFactory).register(this);
            this.byteCodesWrapper = new AtomicReference();
            this.isItPossibleToAddClassPaths = StaticComponentContainer.ClassLoaders.isItPossibleToAddClassPaths(this.classLoader);
            this.classesSearchedInAdditionalClassRepositoriesForClassLoader = new HashSet<String>();
            this.classesSearchedInCompilationDependenciesPaths = new HashSet<String>();
            this.additionalClassRepositoriesForClassLoader = additionalClassRepositoriesForClassLoader;
            this.uSGClassNames = uSGClassNames;
            this.compilationConfigSupplier = compileConfigSupplier;
            this.useOneShotJavaCompiler = useOneShotJavaCompiler;
        }

        public Class<?> get(String className) {
            try {
                try {
                    try {
                        try {
                            return this.classLoader.loadClass(className);
                        }
                        catch (ClassNotFoundException | NoClassDefFoundError exc) {
                            try {
                                if (!this.isItPossibleToAddClassPaths || this.compilationClassPathHasBeenAdded || !this.getCompilationConfig().isStoringCompiledClassesEnabled()) {
                                    throw exc;
                                }
                                JavaMemoryCompiler.Compilation.Result compilationResult = this.getCompilationResult();
                                this.compilationClassPathHasBeenAdded = true;
                                StaticComponentContainer.ClassLoaders.addClassPath(this.classLoader, compilationResult.getClassPath().getAbsolutePath()::equals, compilationResult.getClassPath().getAbsolutePath());
                                return this.get(className);
                            }
                            catch (ClassNotFoundException | NoClassDefFoundError exc2) {
                                try {
                                    JavaMemoryCompiler.Compilation.Result compilationResult = this.getCompilationResult();
                                    HashMap<String, ByteBuffer> compiledClasses = new HashMap<String, ByteBuffer>(compilationResult.getCompiledFiles());
                                    if (compiledClasses.containsKey(className)) {
                                        return StaticComponentContainer.ClassLoaders.loadOrDefineByByteCode(className, compiledClasses, this.classLoader);
                                    }
                                    throw exc2;
                                }
                                catch (ClassNotFoundException | NoClassDefFoundError exc3) {
                                    if (!this.isItPossibleToAddClassPaths) {
                                        throw exc3;
                                    }
                                    Collection<String> notFoundClasses = StaticComponentContainer.Classes.retrieveNames(exc3);
                                    if (this.classesSearchedInAdditionalClassRepositoriesForClassLoader.containsAll(notFoundClasses)) {
                                        throw exc3;
                                    }
                                    HashSet<String> whereToFind = new HashSet<String>(this.additionalClassRepositoriesForClassLoader);
                                    String absolutePathOfCompiledFilesClassPath = this.getCompilationResult().getClassPath().getAbsolutePath();
                                    whereToFind.add(absolutePathOfCompiledFilesClassPath);
                                    this.classesSearchedInAdditionalClassRepositoriesForClassLoader.addAll(notFoundClasses);
                                    if (!this.classPathHelper.compute(ClassPathHelper.Compute.AndAddToClassLoaderConfig.create(this.classLoader, whereToFind, className).setClassesRequiredByTheClassToBeLoaded(notFoundClasses).refreshPaths(Arrays.asList(absolutePathOfCompiledFilesClassPath))).isEmpty()) {
                                        return this.get(className);
                                    }
                                    throw exc3;
                                }
                            }
                        }
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError exc) {
                        if (!this.isItPossibleToAddClassPaths) {
                            throw exc;
                        }
                        Collection<String> notFoundClasses = StaticComponentContainer.Classes.retrieveNames(exc);
                        if (this.classesSearchedInCompilationDependenciesPaths.containsAll(notFoundClasses)) {
                            throw exc;
                        }
                        JavaMemoryCompiler.Compilation.Result compilationResult = this.getCompilationResult();
                        HashSet<String> classPaths = new HashSet<String>(compilationResult.getDependencies());
                        HashSet<String> classPathsToBeRefreshed = new HashSet<String>();
                        if (this.getCompilationConfig().isStoringCompiledClassesEnabled()) {
                            String compilationResultAbsolutePath = compilationResult.getClassPath().getAbsolutePath();
                            classPaths.add(compilationResultAbsolutePath);
                            classPathsToBeRefreshed.add(compilationResultAbsolutePath);
                        }
                        this.classesSearchedInCompilationDependenciesPaths.addAll(notFoundClasses);
                        if (!this.classPathHelper.compute(ClassPathHelper.Compute.AndAddToClassLoaderConfig.create(this.classLoader, classPaths, className).setClassesRequiredByTheClassToBeLoaded(notFoundClasses).refreshPaths(classPathsToBeRefreshed)).isEmpty()) {
                            return this.get(className);
                        }
                        throw exc;
                    }
                }
                catch (ClassNotFoundException | NoClassDefFoundError | Classes.Loaders.UnsupportedException exc) {
                    return StaticComponentContainer.ClassLoaders.loadOrDefineByByteCode(className, this.loadBytecodesFromClassPaths(this.byteCodesWrapper, this.getCompilationResult().getCompiledFiles(), this.additionalClassRepositoriesForClassLoader).get(), this.classLoader);
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError exc) {
                return Executor.get(() -> StaticComponentContainer.ClassLoaders.loadOrDefineByByteCode(className, this.loadBytecodesFromClassPaths(this.byteCodesWrapper, this.getCompilationResult().getCompiledFiles(), this.additionalClassRepositoriesForClassLoader, this.getCompilationResult().getDependencies()).get(), this.classLoader));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private QueuedTaskExecutor.ProducerTask<JavaMemoryCompiler.Compilation.Result> getCompilationTask() {
            if (this.compilationTask == null) {
                Supplier<JavaMemoryCompiler.Compilation.Config> supplier = this.compilationConfigSupplier;
                synchronized (supplier) {
                    if (this.compilationTask == null) {
                        this.classPathHelper = !this.useOneShotJavaCompiler ? ((ClassFactoryImpl)this.classFactory).classPathHelper : ClassPathHelper.create(((ClassFactoryImpl)this.classFactory).getClassPathHunter(), ((ClassFactoryImpl)this.classFactory).config);
                        this.compiler = !this.useOneShotJavaCompiler ? ((ClassFactoryImpl)this.classFactory).javaMemoryCompiler : JavaMemoryCompiler.create(((ClassFactoryImpl)this.classFactory).pathHelper, this.classPathHelper, ((ClassFactoryImpl)this.classFactory).config);
                        this.compilationTask = this.compiler.compile(this.getCompilationConfig());
                    }
                }
            }
            return this.compilationTask;
        }

        private JavaMemoryCompiler.Compilation.Result getCompilationResult() {
            JavaMemoryCompiler.Compilation.Result compilationResult = this.getCompilationTask().join();
            if (this.getCompilationTask().getException() != null) {
                StaticComponentContainer.Driver.throwException(this.getCompilationTask().getException());
            }
            return compilationResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JavaMemoryCompiler.Compilation.Config getCompilationConfig() {
            if (this.compilationConfig == null) {
                Supplier<JavaMemoryCompiler.Compilation.Config> supplier = this.compilationConfigSupplier;
                synchronized (supplier) {
                    if (this.compilationConfig == null) {
                        this.compilationConfig = this.compilationConfigSupplier.get();
                    }
                }
            }
            return this.compilationConfig;
        }

        @SafeVarargs
        private final AtomicReference<Map<String, ByteBuffer>> loadBytecodesFromClassPaths(AtomicReference<Map<String, ByteBuffer>> retrievedBytecodes, Map<String, ByteBuffer> extraBytecode, Collection<String> ... classPaths) {
            if (retrievedBytecodes.get() == null) {
                try (ByteCodeHunter.SearchResult result = (ByteCodeHunter.SearchResult)((ClassFactoryImpl)this.classFactory).byteCodeHunter.findBy(SearchConfig.forPaths(classPaths).setFileFilter(FileSystemItem.Criteria.forClassTypeFiles(StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("class-factory.byte-code-hunter.search-config.check-file-option").on(((ClassFactoryImpl)this.classFactory).config)).withDefaultValues(Configuration.DEFAULT_VALUES)))).optimizePaths(true));){
                    HashMap extraClassPathsForClassLoaderByteCodes = new HashMap();
                    result.getItemsFoundFlatMap().values().forEach(javaClass -> extraClassPathsForClassLoaderByteCodes.put(javaClass.getName(), javaClass.getByteCode()));
                    retrievedBytecodes.set(extraClassPathsForClassLoaderByteCodes);
                }
                if (extraBytecode != null && extraBytecode != null) {
                    retrievedBytecodes.get().putAll(extraBytecode);
                }
            }
            return retrievedBytecodes;
        }

        public Collection<Class<?>> getAllCompiledClasses() {
            HashSet classes = new HashSet();
            for (String className : this.uSGClassNames) {
                classes.add(this.get(className));
            }
            return classes;
        }

        public Collection<Class<?>> get(String ... classesName) {
            HashSet classes = new HashSet();
            for (String className : classesName) {
                classes.add(this.get(className));
            }
            return classes;
        }

        @Override
        public void close() {
            this.closeResources(() -> this.classLoader == null, task -> {
                JavaMemoryCompiler.Compilation.Result compilationResult;
                if (this.classLoader instanceof MemoryClassLoader) {
                    ((MemoryClassLoader)this.classLoader).unregister(this, true);
                }
                if (this.compilationTask != null && ((QueuedTaskExecutor.ProducerTask)this.compilationTask.abortOrWaitForFinish()).isStarted() && (compilationResult = this.compilationTask.join()) != null) {
                    compilationResult.close();
                }
                this.compilationConfigSupplier = null;
                this.compilationConfig = null;
                this.compilationTask = null;
                if (this.useOneShotJavaCompiler) {
                    ((Closeable)((Object)this.compiler)).close();
                    ((Closeable)((Object)this.classPathHelper)).close();
                }
                this.compiler = null;
                this.classPathHelper = null;
                this.classLoader = null;
                if (this.byteCodesWrapper != null) {
                    if (this.byteCodesWrapper.get() != null) {
                        this.byteCodesWrapper.get().clear();
                    }
                    this.byteCodesWrapper.set(null);
                }
                this.byteCodesWrapper = null;
                this.classLoader = null;
                this.uSGClassNames.clear();
                this.uSGClassNames = null;
                this.classesSearchedInAdditionalClassRepositoriesForClassLoader.clear();
                this.classesSearchedInAdditionalClassRepositoriesForClassLoader = null;
                this.classesSearchedInCompilationDependenciesPaths.clear();
                this.classesSearchedInCompilationDependenciesPaths = null;
                this.additionalClassRepositoriesForClassLoader.clear();
                this.additionalClassRepositoriesForClassLoader = null;
                try {
                    ((ClassFactoryImpl)this.classFactory).unregister(this);
                }
                catch (NullPointerException exc) {
                    StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Exception while unregistering {}: classFactory is closed", this);
                }
                this.classFactory = null;
            });
        }
    }

    public static abstract class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
            defaultValues.put("class-factory.default-class-loader.supplier.imports", "${code-executor.common.imports}" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + "${" + "class-factory.default-class-loader" + "." + "supplier" + ".additional-imports}" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + PathScannerClassLoader.class.getName() + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator());
            defaultValues.put("class-factory.default-class-loader.supplier.name", ClassFactory.class.getPackage().getName() + ".DefaultClassLoaderRetrieverForClassFactory");
            defaultValues.put("class-factory.default-class-loader", componentSupplier -> componentSupplier.getPathScannerClassLoader());
            defaultValues.put(Key.CLASS_REPOSITORIES_FOR_DEFAULT_CLASS_LOADER, "${" + JavaMemoryCompiler.Configuration.Key.CLASS_PATHS + "}" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + "${" + JavaMemoryCompiler.Configuration.Key.CLASS_REPOSITORIES + "}" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + "${" + Key.ADDITIONAL_CLASS_REPOSITORIES_FOR_DEFAULT_CLASS_LOADER + "}");
            defaultValues.put("class-factory.byte-code-hunter.search-config.check-file-option", "${hunters.default-search-config.check-file-option}");
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static abstract class Key {
            public static final String DEFAULT_CLASS_LOADER = "class-factory.default-class-loader";
            public static final String CLASS_REPOSITORIES_FOR_DEFAULT_CLASS_LOADER = PathHelper.Configuration.Key.PATHS_PREFIX + "class-factory.default-class-loader.class-repositories";
            public static final String ADDITIONAL_CLASS_REPOSITORIES_FOR_DEFAULT_CLASS_LOADER = PathHelper.Configuration.Key.PATHS_PREFIX + "class-factory.default-class-loader." + "supplier" + ".additional-class-repositories";
            public static final String BYTE_CODE_HUNTER_SEARCH_CONFIG_CHECK_FILE_OPTIONS = "class-factory.byte-code-hunter.search-config.check-file-option";
        }
    }
}

