/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.UiContentProviderComposite;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableTitleAreaDialog;

public final class BindDialog
extends ResizableTitleAreaDialog
implements IPageListener {
    private final IDatabindingsProvider m_databindingsProvider;
    private final IBindingInfo m_binding;
    private final boolean m_canCreate;
    private final boolean m_autoFinish;
    private UiContentProviderComposite m_providerComposite;

    public BindDialog(Shell parentShell, AbstractUIPlugin plugin, IDatabindingsProvider databindingsProvider, IBindingInfo binding, boolean canCreate, boolean autoFinish) {
        super(parentShell, plugin);
        this.m_databindingsProvider = databindingsProvider;
        this.m_binding = binding;
        this.m_canCreate = canCreate;
        this.m_autoFinish = autoFinish;
    }

    protected Control createDialogArea(Composite parent) {
        final ScrolledComposite container = new ScrolledComposite((Composite)super.createDialogArea(parent), 2560);
        container.setExpandHorizontal(true);
        List providers = (List)ExecutionUtils.runObjectLog(() -> this.m_databindingsProvider.getContentProviders(this.m_binding, this), Collections.emptyList());
        this.m_providerComposite = new UiContentProviderComposite(this, providers, (Composite)container, 0);
        container.setContent((Control)this.m_providerComposite);
        container.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle bounds = container.getClientArea();
                Point size = BindDialog.this.m_providerComposite.computeSize(bounds.width, -1);
                BindDialog.this.m_providerComposite.setBounds(bounds.x, bounds.y, size.x, size.y);
            }
        });
        GridDataFactory.create((Control)container).fill().grab();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                BindDialog.this.m_providerComposite.performInitialize();
            }
        });
    }

    protected void configureShell(Shell newShell) {
        if (this.m_canCreate) {
            newShell.setText(Messages.BindDialog_titleCreate);
        } else {
            newShell.setText(Messages.BindDialog_titleEdit);
        }
        super.configureShell(newShell);
    }

    protected void okPressed() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                BindDialog.this.m_providerComposite.performFinish();
            }
        });
        super.okPressed();
    }

    public int open() {
        Shell shell;
        if (this.getShell() == null) {
            this.create();
        }
        this.constrainShellSize();
        if (this.m_autoFinish && this.getButton(0).getEnabled()) {
            this.okPressed();
        }
        if ((shell = this.getShell()) != null && !shell.isDisposed()) {
            shell.open();
            Display display = shell.getDisplay();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (!display.isDisposed()) {
                display.update();
            }
        }
        return this.getReturnCode();
    }

    @Override
    public void setPageComplete(boolean complete) {
        this.getButton(0).setEnabled(complete);
    }
}

