/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.icon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wb.core.model.IImageProcessor;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;

public final class ImageProcessorHelper {
    private static final String EXTENSION_POINT = "org.eclipse.wb.core.java.imageProcessor";
    private static final String NAME = "processor";

    private ImageProcessorHelper() {
    }

    private static List<IImageProcessor> getElements(Class<?> type) {
        Assert.isNotNull(type, (String)"Type must not be null.");
        ArrayList<IImageProcessor> elements = new ArrayList<IImageProcessor>();
        for (IConfigurationElement element : ExternalFactoriesHelper.getElements((String)EXTENSION_POINT, (String)NAME)) {
            String typeName = element.getAttribute("type");
            Assert.isNotNull(type, (String)"Type attribute not set.");
            if (!typeName.equals(type.getName())) continue;
            IImageProcessor imageSource = (IImageProcessor)ExternalFactoriesHelper.createExecutableExtension((IConfigurationElement)element, (String)"class");
            elements.add(imageSource);
        }
        return Collections.unmodifiableList(elements);
    }

    public static IImageProcessor process(Class<?> type, Predicate<IImageProcessor> predicate) {
        for (IImageProcessor element : ImageProcessorHelper.getElements(type)) {
            if (!predicate.test(element)) continue;
            return element;
        }
        return null;
    }
}

