/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.spring;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.spring.SpringAttachmentInfo;
import org.eclipse.wb.internal.swing.model.layout.spring.SpringLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.jupiter.api.Test;

public class SpringAttachmentTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getSpringSide() throws Exception {
        SpringAttachmentTest.assertSame((Object)"West", (Object)SpringAttachmentInfo.getSpringSide((int)1));
        SpringAttachmentTest.assertSame((Object)"East", (Object)SpringAttachmentInfo.getSpringSide((int)4));
        SpringAttachmentTest.assertSame((Object)"North", (Object)SpringAttachmentInfo.getSpringSide((int)8));
        SpringAttachmentTest.assertSame((Object)"South", (Object)SpringAttachmentInfo.getSpringSide((int)32));
        try {
            SpringAttachmentInfo.getSpringSide((int)-1);
            SpringAttachmentTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getSpringSideSource() throws Exception {
        SpringAttachmentTest.assertEquals((Object)"javax.swing.SpringLayout.WEST", (Object)SpringAttachmentInfo.getSpringSideSource((int)1));
        SpringAttachmentTest.assertEquals((Object)"javax.swing.SpringLayout.EAST", (Object)SpringAttachmentInfo.getSpringSideSource((int)4));
        SpringAttachmentTest.assertEquals((Object)"javax.swing.SpringLayout.NORTH", (Object)SpringAttachmentInfo.getSpringSideSource((int)8));
        SpringAttachmentTest.assertEquals((Object)"javax.swing.SpringLayout.SOUTH", (Object)SpringAttachmentInfo.getSpringSideSource((int)32));
        try {
            SpringAttachmentInfo.getSpringSideSource((int)-1);
            SpringAttachmentTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getFrameworkSide() throws Exception {
        SpringAttachmentTest.assertEquals((int)1, (int)SpringAttachmentInfo.getFrameworkSide((String)"West"));
        SpringAttachmentTest.assertEquals((int)8, (int)SpringAttachmentInfo.getFrameworkSide((String)"North"));
        SpringAttachmentTest.assertEquals((int)4, (int)SpringAttachmentInfo.getFrameworkSide((String)"East"));
        SpringAttachmentTest.assertEquals((int)32, (int)SpringAttachmentInfo.getFrameworkSide((String)"South"));
        try {
            SpringAttachmentInfo.getFrameworkSide((String)"no such side");
            SpringAttachmentTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getAttchment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertSame((Object)attachment, (Object)layout.getAttachmentLeft(button));
        SpringAttachmentTest.assertNotSame((Object)attachment, (Object)layout.getAttachmentRight(button));
        SpringAttachmentTest.assertNotSame((Object)attachment, (Object)layout.getAttachmentTop(button));
        SpringAttachmentTest.assertNotSame((Object)attachment, (Object)layout.getAttachmentBottom(button));
    }

    @Test
    public void test_getSide() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertEquals((int)1, (int)attachment.getSide());
        attachment = layout.getAttachmentTop(button);
        SpringAttachmentTest.assertEquals((int)8, (int)attachment.getSide());
        attachment = layout.getAttachmentRight(button);
        SpringAttachmentTest.assertEquals((int)4, (int)attachment.getSide());
        attachment = layout.getAttachmentBottom(button);
        SpringAttachmentTest.assertEquals((int)32, (int)attachment.getSide());
    }

    @Test
    public void test_isVirtual() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);\n\t\t\tlayout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Rectangle modelBounds = button.getModelBounds();
        SpringAttachmentTest.assertEquals((int)modelBounds.x, (int)5);
        SpringAttachmentTest.assertEquals((int)modelBounds.y, (int)10);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        attachment = layout.getAttachmentTop(button);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        attachment = layout.getAttachmentRight(button);
        SpringAttachmentTest.assertTrue((boolean)attachment.isVirtual());
        attachment = layout.getAttachmentBottom(button);
        SpringAttachmentTest.assertTrue((boolean)attachment.isVirtual());
    }

    @Test
    public void test_getAnchor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tprivate final JButton button_1 = new JButton();\n\tprivate final JButton button_2 = new JButton();\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tadd(button_1);\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button_1, 5, SpringLayout.WEST, this);\n\t\t\tlayout.putConstraint(SpringLayout.NORTH, button_1, 10, SpringLayout.NORTH, this);\n\t\t}\n\t\t{\n\t\t\tadd(button_2);\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button_2, 5, SpringLayout.EAST, button_1);\n\t\t\tlayout.putConstraint(SpringLayout.NORTH, button_2, 0, SpringLayout.NORTH, button_1);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        Rectangle bounds_1 = button_1.getModelBounds();
        Rectangle bounds_2 = button_2.getModelBounds();
        SpringAttachmentTest.assertEquals((int)bounds_1.x, (int)5);
        SpringAttachmentTest.assertEquals((int)bounds_1.y, (int)10);
        SpringAttachmentTest.assertEquals((int)bounds_2.x, (int)(bounds_1.right() + 5));
        SpringAttachmentTest.assertEquals((int)bounds_2.y, (int)bounds_1.y);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button_1);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)1, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)5, (int)attachment.getOffset());
        attachment = layout.getAttachmentTop(button_1);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)8, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)10, (int)attachment.getOffset());
        attachment = layout.getAttachmentLeft(button_2);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)button_1, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)4, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)5, (int)attachment.getOffset());
        attachment = layout.getAttachmentTop(button_2);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)button_1, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)8, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)0, (int)attachment.getOffset());
    }

    @Test
    public void test_getDistance() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);\n\t\t\tlayout.putConstraint(SpringLayout.SOUTH, button, -10, SpringLayout.SOUTH, this);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)1, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)5, (int)attachment.getOffset());
        attachment = layout.getAttachmentBottom(button);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)32, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)-10, (int)attachment.getOffset());
    }

    @Test
    public void test_write_existingAttachment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)1, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)5, (int)attachment.getOffset());
        attachment.setOffset(10);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button, 10, SpringLayout.WEST, this);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        attachment.setAnchorSide(4);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button, 10, SpringLayout.EAST, this);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_write_newAttachment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertTrue((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame(null, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)0, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)0, (int)attachment.getOffset());
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        SpringAttachmentTest.assertEquals((Object)"{new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/ /layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this)/}", (Object)button.toString());
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)1, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)5, (int)attachment.getOffset());
    }

    @Test
    public void test_write_newAttachment_lazy() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tprivate JButton m_button;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\tadd(getButton());\n\t}\n\tprivate JButton getButton() {\n\t\tif (m_button == null) {\n\t\t\tm_button = new JButton();\n\t\t}\n\t\treturn m_button;\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertTrue((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame(null, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)0, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)0, (int)attachment.getOffset());
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tprivate JButton m_button;\n\tprivate SpringLayout layout;\n\tpublic Test() {\n\t\tlayout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\tadd(getButton());\n\t}\n\tprivate JButton getButton() {\n\t\tif (m_button == null) {\n\t\t\tm_button = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, m_button, 5, SpringLayout.WEST, this);\n\t\t}\n\t\treturn m_button;\n\t}\n}");
        SpringAttachmentTest.assertEquals((Object)"{new: javax.swing.JButton} {lazy: m_button getButton()} {/new JButton()/ /m_button/ /add(getButton())/ /layout.putConstraint(SpringLayout.WEST, m_button, 5, SpringLayout.WEST, this)/}", (Object)button.toString());
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)1, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)5, (int)attachment.getOffset());
    }

    @Test
    public void test_write_newAttachment_sorted() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentTop(button);
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(8);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.NORTH, button, 5, SpringLayout.NORTH, this);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        attachment = layout.getAttachmentLeft(button);
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.NORTH, button, 5, SpringLayout.NORTH, this);\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        attachment = layout.getAttachmentBottom(button);
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(32);
        attachment.setOffset(-5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.NORTH, button, 5, SpringLayout.NORTH, this);\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);\n\t\t\tlayout.putConstraint(SpringLayout.SOUTH, button, -5, SpringLayout.SOUTH, this);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        attachment = layout.getAttachmentRight(button);
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(4);
        attachment.setOffset(-5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.NORTH, button, 5, SpringLayout.NORTH, this);\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);\n\t\t\tlayout.putConstraint(SpringLayout.SOUTH, button, -5, SpringLayout.SOUTH, this);\n\t\t\tlayout.putConstraint(SpringLayout.EAST, button, -5, SpringLayout.EAST, this);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_write_newAttachment_trailingSide() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentRight(button);
        SpringAttachmentTest.assertTrue((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame(null, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)0, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)0, (int)attachment.getOffset());
        attachment.setAnchorComponent((ComponentInfo)panel);
        attachment.setAnchorSide(4);
        attachment.setOffset(-5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.EAST, button, -5, SpringLayout.EAST, this);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        SpringAttachmentTest.assertEquals((int)4, (int)attachment.getAnchorSide());
        SpringAttachmentTest.assertEquals((int)-5, (int)attachment.getOffset());
    }

    @Test
    public void test_write_newAttachment_backReference() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton buttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonB);
        attachment.setAnchorComponent(buttonA);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, buttonB, 5, SpringLayout.WEST, buttonA);\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}");
        SpringAttachmentTest.assertEquals((Object)"{new: javax.swing.JButton} {field-unique: buttonA} {/new JButton()/ /add(buttonA)/ /layout.putConstraint(SpringLayout.WEST, buttonB, 5, SpringLayout.WEST, buttonA)/}", (Object)buttonA.toString());
        SpringAttachmentTest.assertEquals((Object)"{new: javax.swing.JButton} {local-unique: buttonB} {/new JButton()/ /add(buttonB)/ /layout.putConstraint(SpringLayout.WEST, buttonB, 5, SpringLayout.WEST, buttonA)/}", (Object)buttonB.toString());
    }

    @Test
    public void test_write_newAttachment_forwardReference() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton buttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonA);
        attachment.setAnchorComponent(buttonB);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, buttonA, 5, SpringLayout.WEST, buttonB);\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_write_updateAttachment_backReference() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton buttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, buttonB, 5, SpringLayout.WEST, this);\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonB);
        attachment.setAnchorComponent(buttonA);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, buttonB, 5, SpringLayout.WEST, buttonA);\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_write_updateAttachment_forwardReference() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton buttonA = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, buttonA, 5, SpringLayout.WEST, this);\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonA);
        attachment.setAnchorComponent(buttonB);
        attachment.setAnchorSide(1);
        attachment.setOffset(5);
        attachment.write();
        this.assertEditor("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, buttonA, 5, SpringLayout.WEST, buttonB);\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_delete() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);\n\t\t\tlayout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(button);
        SpringAttachmentTest.assertFalse((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame((Object)panel, (Object)attachment.getAnchorComponent());
        attachment.delete();
        SpringAttachmentTest.assertTrue((boolean)attachment.isVirtual());
        SpringAttachmentTest.assertSame(null, (Object)attachment.getAnchorComponent());
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t\tlayout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_adjustAfterComponentMove_source() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, buttonB, 0, SpringLayout.WEST, buttonA);\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringAttachmentTest.assertNoErrors((JavaInfo)panel);
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonB);
        panel.startEdit();
        JavaInfoUtils.move((JavaInfo)buttonB, null, (JavaInfo)panel, (JavaInfo)buttonA);
        this.assertEditor("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, buttonB, 0, SpringLayout.WEST, buttonA);\n\t\t\tadd(buttonB);\n\t\t}\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t}\n}");
        attachment.adjustAfterComponentMove();
        this.assertEditor("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tprivate JButton buttonB;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tbuttonB = new JButton();\n\t\t\tadd(buttonB);\n\t\t}\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, buttonB, 0, SpringLayout.WEST, buttonA);\n\t\t\tadd(buttonA);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_adjustAfterComponentMove_anchor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, buttonB, 0, SpringLayout.WEST, buttonA);\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringAttachmentTest.assertNoErrors((JavaInfo)panel);
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        panel.startEdit();
        JavaInfoUtils.move((JavaInfo)buttonA, null, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tadd(buttonB);\n\t\t}\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t\tlayout.putConstraint(SpringLayout.WEST, buttonB, 0, SpringLayout.WEST, buttonA);\n\t}\n}");
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonB);
        attachment.adjustAfterComponentMove();
        this.assertEditor("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tprivate JButton buttonB;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tbuttonB = new JButton();\n\t\t\tadd(buttonB);\n\t\t}\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, buttonB, 0, SpringLayout.WEST, buttonA);\n\t\t\tadd(buttonA);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_adjustAfterComponentMove_anchor2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button_1, 0, SpringLayout.WEST, buttonA);\n\t\t\tadd(button_1);\n\t\t}\n\t}\n}");
        panel.refresh();
        SpringAttachmentTest.assertNoErrors((JavaInfo)panel);
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        panel.startEdit();
        JavaInfoUtils.move((JavaInfo)buttonA, null, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tadd(button_1);\n\t\t}\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t}\n\t\tlayout.putConstraint(SpringLayout.WEST, button_1, 0, SpringLayout.WEST, buttonA);\n\t}\n}");
        SpringAttachmentInfo attachment = layout.getAttachmentLeft(buttonB);
        attachment.adjustAfterComponentMove();
        this.assertEditor("public class Test extends JPanel {\n\tprivate JButton buttonA;\n\tprivate JButton button;\n\tpublic Test() {\n\t\tSpringLayout layout = new SpringLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tbutton = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tbuttonA = new JButton();\n\t\t\tlayout.putConstraint(SpringLayout.WEST, button, 0, SpringLayout.WEST, buttonA);\n\t\t\tadd(buttonA);\n\t\t}\n\t}\n}");
    }
}

