/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.gef.graphical.GraphicalViewer;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.os.OSSupport;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GridBagLayoutGefTest
extends SwingGefTest {
    ContainerInfo mainPanel;
    ContainerInfo panel_1;
    ComponentInfo button;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        AbstractGridBagLayoutTest.configureForTest();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        AbstractGridBagLayoutTest.configureDefaults();
        super.tearDown();
    }

    @Test
    public void test_replaceWithOther_andPaintDuringThis() throws Exception {
        this.mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tgridBagLayout.columnWeights = new double[]{1.0};\n\t\tgridBagLayout.rowWeights = new double[]{1.0};\n\t\tsetLayout(gridBagLayout);\n\t\t{\n\t\t\tJButton button = new JButton(\"New JButton\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        this.button = (ComponentInfo)GridBagLayoutGefTest.getJavaInfoByName("button");
        this.canvas.select(this.button);
        GridBagLayoutGefTest.waitEventLoop(0);
        ExecutionUtils.runAsync((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ExecutionUtils.runLogUI((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        this.forcePaint(GridBagLayoutGefTest.this.m_headerHorizontal);
                        this.forcePaint(GridBagLayoutGefTest.this.m_headerVertical);
                    }

                    private void forcePaint(GraphicalViewer viewer) throws Exception {
                        FigureCanvas control = viewer.getControl();
                        Image image = OSSupport.get().makeShot((Control)control);
                        image.dispose();
                        control.getShell().setVisible(true);
                    }
                });
            }
        });
        LayoutInfo layout = (LayoutInfo)GridBagLayoutGefTest.createJavaInfo("java.awt.FlowLayout");
        this.mainPanel.setLayout(layout);
    }

    @Test
    public void test_JPopupMenu_select() throws Exception {
        this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"button\");\n\t\t\tadd(button, new GridBagConstraints());\n\t\t}\n\t\t{\n\t\t\tJPopupMenu popupMenu = new JPopupMenu();\n\t\t\taddPopup(this, popupMenu);\n\t\t}\n\t}\n\tprivate static void addPopup(Component component, JPopupMenu popup) {\n\t}\n}");
        ComponentInfo popup = (ComponentInfo)GridBagLayoutGefTest.getJavaInfoByName("popupMenu");
        this.canvas.select(popup);
    }

    @Test
    public void test_JPopupMenu_drop() throws Exception {
        this.mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t}\n\tprivate static void addPopup(Component component, JPopupMenu popup) {\n\t}\n}");
        ComponentInfo newPopup = (ComponentInfo)this.loadCreationTool("javax.swing.JPopupMenu");
        this.canvas.moveTo((Object)this.mainPanel, 100, 100);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(this.mainPanel));
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPopupMenu popupMenu = new JPopupMenu();\n\t\t\taddPopup(this, popupMenu);\n\t\t}\n\t\tsetLayout(new GridBagLayout());\n\t}\n\tprivate static void addPopup(Component component, JPopupMenu popup) {\n\t}\n}");
        this.canvas.assertPrimarySelected(newPopup);
    }

    @Test
    public void test_CREATE_inTree_empty() throws Exception {
        this.mainPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t}\n}");
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.tree.moveOn(this.mainPanel);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_DELETE_afterSelect() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(50, 50);\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tsetLayout(gridBagLayout);\n\n\t\tJPanel panel = new JPanel();\n\t\tGridBagConstraints gbc_panel = new GridBagConstraints();\n\t\tgbc_panel.ipady = 10;\n\t\tgbc_panel.ipadx = 10;\n\t\tgbc_panel.fill = GridBagConstraints.BOTH;\n\t\tgbc_panel.gridx = 0;\n\t\tgbc_panel.gridy = 0;\n\t\tadd(panel, gbc_panel);\n\t\tpanel.setLayout(null);\n\n\t\tJPanel panel_1 = new JPanel();\n\t\tGridBagConstraints gbc_panel_1 = new GridBagConstraints();\n\t\tgbc_panel_1.ipady = 10;\n\t\tgbc_panel_1.ipadx = 10;\n\t\tgbc_panel_1.fill = GridBagConstraints.BOTH;\n\t\tgbc_panel_1.gridx = 1;\n\t\tgbc_panel_1.gridy = 1;\n\t\tadd(panel_1, gbc_panel_1);\n\t\tpanel_1.setLayout(null);\n\t}\n}\n");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutGefTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagLayoutGefTest.assertEquals((int)2, (int)layout.getRows().size());
        this.canvas.select(panel.getChildrenComponents().get(1));
        ((ComponentInfo)panel.getChildrenComponents().get(1)).delete();
        GridBagLayoutGefTest.assertEquals((int)1, (int)layout.getColumns().size());
        GridBagLayoutGefTest.assertEquals((int)1, (int)layout.getRows().size());
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(50, 50);\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tsetLayout(gridBagLayout);\n\n\t\tJPanel panel = new JPanel();\n\t\tGridBagConstraints gbc_panel = new GridBagConstraints();\n\t\tgbc_panel.ipady = 10;\n\t\tgbc_panel.ipadx = 10;\n\t\tgbc_panel.fill = GridBagConstraints.BOTH;\n\t\tgbc_panel.gridx = 0;\n\t\tgbc_panel.gridy = 0;\n\t\tadd(panel, gbc_panel);\n\t\tpanel.setLayout(null);\n\t}\n}\n");
    }
}

