/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.GenericPropertyGetValue;
import org.eclipse.wb.core.model.broadcast.GenericPropertyGetValueEx;
import org.eclipse.wb.core.model.broadcast.GenericPropertySetValue;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyComposite;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.JavaProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ConstructorAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.SetterAccessor;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipTextProvider;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.tests.common.GenericPropertyNoValue;
import org.eclipse.wb.tests.designer.tests.common.PropertyNoValue;
import org.junit.jupiter.api.Test;

public class PropertyTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_unknown() throws Exception {
        PropertyTest.assertEquals((Object)"UNKNOWN_VALUE", (Object)Property.UNKNOWN_VALUE.toString());
    }

    @Test
    public void test_JavaProperty_getJavaInfo() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaProperty property = (JavaProperty)panel.getPropertyByTitle("enabled");
        PropertyTest.assertSame((Object)panel, (Object)property.getObjectInfo());
        PropertyTest.assertSame((Object)panel, (Object)property.getJavaInfo());
        PropertyTest.assertSame((Object)panel, (Object)property.getAdapter(ObjectInfo.class));
    }

    @Test
    public void test_JavaProperty_getTitle() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaProperty property = (JavaProperty)panel.getPropertyByTitle("enabled");
        PropertyTest.assertEquals((Object)"enabled", (Object)property.getTitle());
        property.setTitle("newTitle");
        PropertyTest.assertEquals((Object)"newTitle", (Object)property.getTitle());
    }

    @Test
    public void test_GenericPropertyComposite() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JButton button_1 = new JButton('111');", "    add(button_1);", "    //", "    JButton button_2 = new JButton('222');", "    add(button_2);", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        GenericProperty iconProperty_1 = (GenericProperty)button_1.getPropertyByTitle("icon");
        GenericProperty iconProperty_2 = (GenericProperty)button_2.getPropertyByTitle("icon");
        PropertyTest.assertFalse((boolean)iconProperty_1.isModified());
        PropertyTest.assertFalse((boolean)iconProperty_2.isModified());
        PropertyTest.assertSame(null, (Object)iconProperty_1.getValue());
        PropertyTest.assertSame(null, (Object)iconProperty_2.getValue());
        Property[] properties = new Property[]{iconProperty_1, iconProperty_2};
        GenericProperty compositeProperty = (GenericProperty)iconProperty_1.getComposite(properties);
        PropertyTest.assertEquals((Object)"icon", (Object)compositeProperty.getTitle());
        PropertyTest.assertFalse((boolean)compositeProperty.isModified());
        PropertyTest.assertSame(null, (Object)compositeProperty.getValue());
        PropertyTest.assertNull((Object)compositeProperty.getExpression());
        GenericProperty textProperty_1 = (GenericProperty)button_1.getPropertyByTitle("text");
        GenericProperty textProperty_2 = (GenericProperty)button_2.getPropertyByTitle("text");
        PropertyTest.assertTrue((boolean)textProperty_1.isModified());
        PropertyTest.assertTrue((boolean)textProperty_2.isModified());
        PropertyTest.assertEquals((Object)"111", (Object)textProperty_1.getValue());
        PropertyTest.assertEquals((Object)"222", (Object)textProperty_2.getValue());
        properties = new Property[]{textProperty_1, textProperty_2};
        compositeProperty = (GenericProperty)textProperty_1.getComposite(properties);
        PropertyTest.assertEquals((Object)"text", (Object)compositeProperty.getTitle());
        PropertyTest.assertTrue((boolean)compositeProperty.isModified());
        PropertyTest.assertEquals((Object)textProperty_1.getCategory(), (Object)compositeProperty.getCategory());
        PropertyTest.assertEquals((Object)textProperty_2.getCategory(), (Object)compositeProperty.getCategory());
        PropertyTest.assertTrue((boolean)compositeProperty.equals(compositeProperty));
        PropertyTest.assertFalse((boolean)compositeProperty.equals((Object)this));
        Property composite2 = textProperty_2.getComposite(properties);
        PropertyTest.assertTrue((boolean)compositeProperty.equals(composite2));
        PropertyTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)compositeProperty.getValue());
        PropertyTest.assertNull((Object)compositeProperty.getExpression());
        compositeProperty.setValue((Object)"333");
        PropertyTest.assertEquals((Object)"333", (Object)compositeProperty.getValue());
        PropertyTest.assertEquals((Object)"\"333\"", (Object)this.m_lastEditor.getSource((ASTNode)compositeProperty.getExpression()));
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JButton button_1 = new JButton('333');", "    add(button_1);", "    //", "    JButton button_2 = new JButton('333');", "    add(button_2);", "  }", "}");
        String value = "444";
        compositeProperty.setExpression(StringConverter.INSTANCE.toJavaSource((JavaInfo)panel, (Object)value), (Object)value);
        PropertyTest.assertEquals((Object)"444", (Object)compositeProperty.getValue());
        PropertyTest.assertEquals((Object)"\"444\"", (Object)this.m_lastEditor.getSource((ASTNode)compositeProperty.getExpression()));
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JButton button_1 = new JButton('444');", "    add(button_1);", "    //", "    JButton button_2 = new JButton('444');", "    add(button_2);", "  }", "}");
    }

    @Test
    public void test_GenericPropertyComposite_getDefaultValue_sameValue() throws Exception {
        GenericPropertyNoValue property_1 = PropertyTest.create_GenericProperty_defaultValue("A");
        GenericPropertyNoValue property_2 = PropertyTest.create_GenericProperty_defaultValue("A");
        GenericPropertyComposite composite = GenericPropertyComposite.create((Property[])new Property[]{property_1, property_2});
        PropertyTest.assertEquals((Object)"A", (Object)composite.getDefaultValue());
    }

    @Test
    public void test_GenericPropertyComposite_getDefaultValue_differentValues() throws Exception {
        GenericPropertyNoValue property_1 = PropertyTest.create_GenericProperty_defaultValue("A");
        GenericPropertyNoValue property_2 = PropertyTest.create_GenericProperty_defaultValue("B");
        GenericPropertyComposite composite = GenericPropertyComposite.create((Property[])new Property[]{property_1, property_2});
        PropertyTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)composite.getDefaultValue());
    }

    private static GenericPropertyNoValue create_GenericProperty_defaultValue(final String defaultValue) {
        return new GenericPropertyNoValue(null, "title", StringPropertyEditor.INSTANCE){

            @Override
            public Object getDefaultValue() {
                return defaultValue;
            }
        };
    }

    @Test
    public void test_GenericPropertyComposite_getType_sameTypes() throws Exception {
        GenericPropertyNoValue property_1 = PropertyTest.createGenericProperty_withType(String.class);
        GenericPropertyNoValue property_2 = PropertyTest.createGenericProperty_withType(String.class);
        GenericPropertyComposite composite = GenericPropertyComposite.create((Property[])new Property[]{property_1, property_2});
        PropertyTest.assertSame(String.class, (Object)composite.getType());
    }

    @Test
    public void test_GenericPropertyComposite_getType_differentTypes() throws Exception {
        GenericPropertyNoValue property_1 = PropertyTest.createGenericProperty_withType(String.class);
        GenericPropertyNoValue property_2 = PropertyTest.createGenericProperty_withType(Object.class);
        GenericPropertyComposite composite = GenericPropertyComposite.create((Property[])new Property[]{property_1, property_2});
        PropertyTest.assertSame(null, (Object)composite.getType());
    }

    @Test
    public void test_GenericPropertyComposite_getType_oneNull() throws Exception {
        GenericPropertyNoValue property_1 = PropertyTest.createGenericProperty_withType(null);
        GenericPropertyNoValue property_2 = PropertyTest.createGenericProperty_withType(String.class);
        GenericPropertyComposite composite = GenericPropertyComposite.create((Property[])new Property[]{property_1, property_2});
        PropertyTest.assertSame(null, (Object)composite.getType());
    }

    private static GenericPropertyNoValue createGenericProperty_withType(final Class<?> type) {
        return new GenericPropertyNoValue(null, "title", StringPropertyEditor.INSTANCE){

            @Override
            public Class<?> getType() {
                return type;
            }
        };
    }

    @Test
    public void test_GenericPropertyImpl_copyConstructor() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        GenericPropertyImpl enabledProperty = (GenericPropertyImpl)panel.getPropertyByTitle("enabled");
        PropertyTest.assertNotNull((Object)enabledProperty);
        PropertyTest.assertEquals((Object)"enabled", (Object)enabledProperty.getTitle());
        PropertyTest.assertEquals(Boolean.TYPE, (Object)enabledProperty.getType());
        GenericPropertyImpl enabledCopy = new GenericPropertyImpl(enabledProperty);
        PropertyTest.assertNotSame((Object)enabledProperty, (Object)enabledCopy);
        PropertyTest.assertEquals((Object)"enabled", (Object)enabledCopy.getTitle());
        PropertyTest.assertSame((Object)enabledProperty.getCategory(), (Object)enabledCopy.getCategory());
        PropertyTest.assertEquals(PropertyTest.getGenericPropertyAccessors((GenericProperty)enabledProperty), PropertyTest.getGenericPropertyAccessors((GenericProperty)enabledCopy));
        PropertyTest.assertSame((Object)enabledProperty.getEditor(), (Object)enabledCopy.getEditor());
        PropertyTest.assertSame((Object)enabledProperty.getDescription(), (Object)enabledCopy.getDescription());
        PropertyTest.assertEquals(Boolean.TYPE, (Object)enabledCopy.getType());
    }

    @Test
    public void test_GenericPropertyImpl_copyConstructor2() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        GenericPropertyImpl enabledProperty = (GenericPropertyImpl)panel.getPropertyByTitle("enabled");
        PropertyTest.assertNotNull((Object)enabledProperty);
        PropertyTest.assertEquals((Object)"enabled", (Object)enabledProperty.getTitle());
        GenericPropertyImpl enabledCopy = new GenericPropertyImpl(enabledProperty, "enabledCopy");
        PropertyTest.assertNotSame((Object)enabledProperty, (Object)enabledCopy);
        PropertyTest.assertEquals((Object)"enabledCopy", (Object)enabledCopy.getTitle());
        PropertyTest.assertSame((Object)enabledProperty.getCategory(), (Object)enabledCopy.getCategory());
        PropertyTest.assertEquals(PropertyTest.getGenericPropertyAccessors((GenericProperty)enabledProperty), PropertyTest.getGenericPropertyAccessors((GenericProperty)enabledCopy));
        PropertyTest.assertSame((Object)enabledProperty.getEditor(), (Object)enabledCopy.getEditor());
        PropertyTest.assertSame((Object)enabledProperty.getDescription(), (Object)enabledCopy.getDescription());
    }

    @Test
    public void test_GenericPropertyImpl_copyConstructor_copyType() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    add(new JButton('a'));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericPropertyImpl textProperty = (GenericPropertyImpl)PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/text");
        PropertyTest.assertNotNull((Object)textProperty);
        PropertyTest.assertSame(String.class, (Object)textProperty.getType());
        GenericPropertyImpl textCopy = new GenericPropertyImpl(textProperty, "Text");
        PropertyTest.assertSame(String.class, (Object)textCopy.getType());
    }

    @Test
    public void test_GenericPropertyImpl_setValue_getValue_withoutRefresh() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        panel.startEdit();
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("name");
        PropertyTest.assertSame(null, (Object)property.getValue());
        String value = "myName";
        property.setExpression(StringConverter.INSTANCE.toJavaSource(null, (Object)value), (Object)value);
        PropertyTest.assertSame((Object)value, (Object)property.getValue());
        value = "newName";
        property.setExpression(StringConverter.INSTANCE.toJavaSource(null, (Object)value), (Object)value);
        PropertyTest.assertSame((Object)value, (Object)property.getValue());
    }

    @Test
    public void test_GenericPropertyImpl_setValueUNKNOWN_getValue_withRefresh() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("name");
        PropertyTest.assertSame(null, (Object)property.getValue());
        String value = "myName";
        property.setExpression(StringConverter.INSTANCE.toJavaSource(null, (Object)value), Property.UNKNOWN_VALUE);
        PropertyTest.assertEquals((Object)value, (Object)property.getValue());
        property.setExpression("null", Property.UNKNOWN_VALUE);
        PropertyTest.assertEquals(null, (Object)property.getValue());
    }

    @Test
    public void test_GenericPropertyImpl_setExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("toolTipText");
        property.setExpression("\"name: \" + %this%.getName()", Property.UNKNOWN_VALUE);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setToolTipText('name: ' + getName());", "  }", "}");
    }

    @Test
    public void test_GenericProperty_valueValidation_1() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property enabledProperty = panel.getPropertyByTitle("enabled");
        panel.addBroadcastListener((Object)new GenericPropertySetValue(){

            public void invoke(GenericPropertyImpl property, Object[] value, boolean[] shouldSetValue) throws Exception {
                shouldSetValue[0] = shouldSetValue[0] & !"enabled".equals(property.getTitle());
            }
        });
        enabledProperty.setValue((Object)Boolean.FALSE);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_GenericProperty_valueValidation_2() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property enabledProperty = panel.getPropertyByTitle("enabled");
        panel.addBroadcastListener((Object)new GenericPropertySetValue(){

            public void invoke(GenericPropertyImpl property, Object[] value, boolean[] shouldSetValue) throws Exception {
                if ("enabled".equals(property.getTitle())) {
                    property.getJavaInfo().getPropertyByTitle("visible").setValue(value[0]);
                }
            }
        });
        enabledProperty.setValue((Object)Boolean.FALSE);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "    setVisible(false);", "  }", "}");
    }

    @Test
    public void test_GenericProperty_expressionValidation_1() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        final GenericProperty enabledProperty = (GenericProperty)panel.getPropertyByTitle("enabled");
        GenericProperty visibleProperty = (GenericProperty)panel.getPropertyByTitle("visible");
        panel.addBroadcastListener((Object)new JavaEventListener(){

            public void setPropertyExpression(GenericPropertyImpl property, String[] source, Object[] value, boolean[] shouldSet) throws Exception {
                shouldSet[0] = shouldSet[0] & property != enabledProperty;
            }
        });
        enabledProperty.setExpression("false", Property.UNKNOWN_VALUE);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        visibleProperty.setExpression("false", Property.UNKNOWN_VALUE);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setVisible(false);", "  }", "}");
    }

    @Test
    public void test_GenericProperty_propertyValueWasSet() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        final GenericProperty enabledProperty = (GenericProperty)panel.getPropertyByTitle("enabled");
        final AtomicBoolean wasFired = new AtomicBoolean();
        panel.addBroadcastListener((Object)new JavaEventListener(){

            public void propertyValueWasSet(GenericPropertyImpl property) throws Exception {
                if (property == enabledProperty) {
                    wasFired.set(true);
                }
            }
        });
        wasFired.set(false);
        enabledProperty.setValue((Object)false);
        PropertyTest.assertTrue((boolean)wasFired.get());
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        wasFired.set(false);
        enabledProperty.setValue((Object)true);
        PropertyTest.assertTrue((boolean)wasFired.get());
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        wasFired.set(false);
        enabledProperty.setExpression("false", Property.UNKNOWN_VALUE);
        PropertyTest.assertTrue((boolean)wasFired.get());
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_GenericProperty_getValue_expressionListener() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "  }", "}");
        panel.refresh();
        final GenericProperty enabledProperty = (GenericProperty)panel.getPropertyByTitle("enabled");
        PropertyTest.assertEquals((Object)Boolean.TRUE, (Object)enabledProperty.getValue());
        panel.addBroadcastListener((Object)new GenericPropertyGetValueEx(){

            public void invoke(GenericPropertyImpl property, Expression expression, Object[] value) throws Exception {
                if (property == enabledProperty) {
                    value[0] = "String, not boolean";
                }
            }
        });
        PropertyTest.assertEquals((Object)"String, not boolean", (Object)enabledProperty.getValue());
    }

    @Test
    public void test_GenericProperty_getValue_unconditionaListener_String() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "  }", "}");
        panel.refresh();
        final GenericProperty enabledProperty = (GenericProperty)panel.getPropertyByTitle("enabled");
        PropertyTest.assertEquals((Object)Boolean.TRUE, (Object)enabledProperty.getValue());
        panel.addBroadcastListener((Object)new GenericPropertyGetValue(){

            public void invoke(GenericPropertyImpl property, Object[] value) throws Exception {
                if (property == enabledProperty) {
                    PropertyTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)value[0]);
                    value[0] = "String, not boolean";
                }
            }
        });
        PropertyTest.assertEquals((Object)"String, not boolean", (Object)enabledProperty.getValue());
    }

    @Test
    public void test_GenericProperty_getValue_unconditionaListener_null() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "  }", "}");
        panel.refresh();
        final GenericProperty enabledProperty = (GenericProperty)panel.getPropertyByTitle("enabled");
        PropertyTest.assertEquals((Object)Boolean.TRUE, (Object)enabledProperty.getValue());
        panel.addBroadcastListener((Object)new GenericPropertyGetValue(){

            public void invoke(GenericPropertyImpl property, Object[] value) throws Exception {
                if (property == enabledProperty) {
                    PropertyTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)value[0]);
                    value[0] = null;
                }
            }
        });
        PropertyTest.assertEquals(null, (Object)enabledProperty.getValue());
    }

    @Test
    public void test_defaultPropertyValue_ignoreAccessor() throws Exception {
        PropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public int getFoo() {", "    return 5;", "  }", "  public void setFoo(int foo) {", "  }", "}"));
        PropertyTest.setFileContentSrc("test/MyPanel.wbp-component.xml", PropertyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setFoo(int)'>", "    <defaultValue value='2'/>", "  </property>", "</component>"));
        PropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("foo");
        PropertyTest.assertEquals((Object)2, (Object)property.getValue());
        property.setValue((Object)5);
        PropertyTest.assertEquals((Object)5, (Object)property.getValue());
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(5);", "  }", "}");
    }

    @Test
    public void test_defaultPropertyValue_noDefaultValue_forConstructor() throws Exception {
        PropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public int foo;", "  public MyPanel(int foo) {", "    this.foo = foo;", "  }", "}"));
        PropertyTest.setFileContentSrc("test/MyPanel.wbp-component.xml", PropertyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='int' property='foo'/>", "    </constructor>", "  </constructors>", "</component>"));
        PropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    super(2);", "  }", "}");
        Property property = panel.getPropertyByTitle("foo");
        PropertyTest.assertEquals((Object)2, (Object)property.getValue());
        String expectedSource = this.m_lastEditor.getSource();
        property.setValue((Object)2);
        PropertyTest.assertEquals((Object)2, (Object)property.getValue());
        PropertyTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_defaultPropertyValue_noDefaultValue() throws Exception {
        PropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setFoo(int foo) {", "  }", "}"));
        PropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        PropertyTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)panel.getPropertyByTitle("foo").getValue());
    }

    @Test
    public void test_GenericProperty_getType() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("enabled");
        PropertyTest.assertSame(Boolean.TYPE, (Object)property.getType());
    }

    @Test
    public void test_GenericProperty_getType_forConstructor_subProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    add(new JButton('a'));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/text");
        PropertyTest.assertNotNull((Object)property);
        PropertyTest.assertSame(String.class, (Object)property.getType());
    }

    @Test
    public void test_setterAccessor() throws Exception {
        JavaInfo panel = this.parseSource("test", "Test.java", PropertyTest.getSourceDQ("package test;", "import java.awt.*;", "import javax.swing.*;", "class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    panel.setEnabled(false);", "  }", "}"));
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("enabled");
        PropertyTest.assertNotNull((Object)property);
        PropertyTest.assertSame((Object)panel, (Object)property.getJavaInfo());
        PropertyTest.assertNotNull((Object)property.getAdapter(PropertyTooltipProvider.class));
        PropertyTest.assertNull((Object)property.getAdapter(Object.class));
        List<ExpressionAccessor> accessors = PropertyTest.getGenericPropertyAccessors(property);
        PropertyTest.assertEquals((int)1, (int)accessors.size());
        ExpressionAccessor accessor = accessors.get(0);
        PropertyTest.assertEquals((Object)Boolean.TRUE, (Object)accessor.getDefaultValue(panel));
        PropertyTest.assertNull((Object)accessor.getAdapter(Object.class));
        PropertyTooltipTextProvider tooltipProvider = (PropertyTooltipTextProvider)accessor.getAdapter(PropertyTooltipProvider.class);
        Method getText_method = PropertyTooltipTextProvider.class.getDeclaredMethod("getText", Property.class);
        getText_method.setAccessible(true);
        String text = (String)getText_method.invoke((Object)tooltipProvider, property);
        Assertions.assertThat((String)text).contains(new CharSequence[]{"this component"});
        PropertyTest.assertRelatedNodes(panel, new String[]{"new JPanel()", "panel.setEnabled(false)"});
        panel.startEdit();
        property.setExpression("true", Property.UNKNOWN_VALUE);
        PropertyTest.check_setterAccessor_true(panel, (Property)property);
        property.setExpression("false", Property.UNKNOWN_VALUE);
        PropertyTest.check_setterAccessor_false(panel, (Property)property);
        property.setExpression("true", (Object)Boolean.TRUE);
        PropertyTest.check_setterAccessor_empty(panel, (Property)property);
        PropertyTest.assertEquals((Object)Boolean.TRUE, (Object)property.getValue());
        property.setExpression("true", (Object)Boolean.TRUE);
        PropertyTest.check_setterAccessor_empty(panel, (Property)property);
        property.setExpression("false", (Object)Boolean.FALSE);
        PropertyTest.check_setterAccessor_false(panel, (Property)property);
        property.setExpression("true", (Object)Boolean.TRUE);
        PropertyTest.check_setterAccessor_empty(panel, (Property)property);
        property.setValue((Object)Boolean.FALSE);
        PropertyTest.check_setterAccessor_false(panel, (Property)property);
        property.setValue((Object)Boolean.TRUE);
        PropertyTest.check_setterAccessor_empty(panel, (Property)property);
        property.setValue((Object)Boolean.FALSE);
        PropertyTest.check_setterAccessor_false(panel, (Property)property);
        property.setValue(Property.UNKNOWN_VALUE);
        PropertyTest.check_setterAccessor_empty(panel, (Property)property);
    }

    private static void check_setterAccessor_false(JavaInfo panel, Property property) throws Exception {
        PropertyTest.check_setterAccessor(panel, "panel.setEnabled(false);", new String[]{"new JPanel()", "panel.setEnabled(false)"}, property, true);
    }

    private static void check_setterAccessor_true(JavaInfo panel, Property property) throws Exception {
        PropertyTest.check_setterAccessor(panel, "panel.setEnabled(true);", new String[]{"new JPanel()", "panel.setEnabled(true)"}, property, true);
    }

    private static void check_setterAccessor_empty(JavaInfo panel, Property property) throws Exception {
        PropertyTest.check_setterAccessor(panel, null, new String[]{"new JPanel()"}, property, false);
    }

    private static void check_setterAccessor(JavaInfo panel, String setSource, String[] relatedNodes, Property property, boolean modified) throws Exception {
        String[] stringArray;
        AstEditor editor = panel.getEditor();
        PropertyTest.assertAST(editor);
        if (setSource != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "    " + setSource;
        } else {
            stringArray = null;
        }
        String[] innerLines = stringArray;
        String expectedSource = PropertyTest.getSource3(new String[]{"package test;", "import java.awt.*;", "import javax.swing.*;", "class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();"}, innerLines, new String[]{"  }", "}"});
        PropertyTest.assertEquals((Object)expectedSource, (Object)editor.getSource());
        PropertyTest.assertRelatedNodes(panel, relatedNodes);
        PropertyTest.assertEquals((Object)modified, (Object)property.isModified());
    }

    @Test
    public void test_constructorAccessor_1() throws Exception {
        JavaInfo button = this.parseSource("test", "Test.java", PropertyTest.getSourceDQ("package test;", "import java.awt.*;", "import javax.swing.*;", "class Test {", "  public static void main(String args[]) {", "    JButton button = new JButton();", "    button.setText('abc');", "  }", "}"));
        GenericProperty property = (GenericProperty)button.getPropertyByTitle("text");
        PropertyTest.assertNotNull((Object)property);
        PropertyTest.assertRelatedNodes(button, new String[]{"new JButton()", "button.setText(\"abc\")"});
        PropertyTest.assertEquals((Object)"abc", (Object)property.getValue());
        List<ExpressionAccessor> accessors = PropertyTest.getGenericPropertyAccessors(property);
        PropertyTest.assertEquals((int)1, (int)accessors.size());
        PropertyTest.assertInstanceOf(SetterAccessor.class, (Object)accessors.get(0));
        PropertyTest.assertEquals((Object)"", (Object)accessors.get(0).getDefaultValue(button));
        button.startEdit();
        property.setValue((Object)"12345");
        PropertyTest.check_constructorAccessor(button, new String[]{"    JButton button = new JButton();", "    button.setText(\"12345\");"}, new String[]{"new JButton()", "button.setText(\"12345\")"});
        property.setValue(Property.UNKNOWN_VALUE);
        PropertyTest.check_constructorAccessor(button, new String[]{"    JButton button = new JButton();"}, new String[]{"new JButton()"});
        property.setValue((Object)"12345");
        PropertyTest.check_constructorAccessor(button, new String[]{"    JButton button = new JButton();", "    button.setText(\"12345\");"}, new String[]{"new JButton()", "button.setText(\"12345\")"});
    }

    @Test
    public void test_constructorAccessor_2() throws Exception {
        JavaInfo button = this.parseSource("test", "Test.java", PropertyTest.getSourceDQ("package test;", "import java.awt.*;", "import javax.swing.*;", "class Test {", "  public static void main(String args[]) {", "    JButton button = new JButton('abc');", "  }", "}"));
        GenericProperty property = (GenericProperty)button.getPropertyByTitle("text");
        PropertyTest.assertNotNull((Object)property);
        List<ExpressionAccessor> accessors = PropertyTest.getGenericPropertyAccessors(property);
        PropertyTest.assertEquals((int)2, (int)accessors.size());
        PropertyTest.assertInstanceOf(SetterAccessor.class, (Object)accessors.get(0));
        PropertyTest.assertInstanceOf(ConstructorAccessor.class, (Object)accessors.get(1));
        PropertyTest.assertEquals((Object)"abc", (Object)accessors.get(0).getDefaultValue(button));
        PropertyTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)accessors.get(1).getDefaultValue(button));
        PropertyTest.assertRelatedNodes(button, new String[]{"new JButton(\"abc\")"});
        PropertyTest.assertEquals((Object)"abc", (Object)property.getValue());
        button.startEdit();
        property.setValue((Object)"12345");
        PropertyTest.check_constructorAccessor(button, new String[]{"    JButton button = new JButton(\"12345\");"}, new String[]{"new JButton(\"12345\")"});
        property.setValue((Object)"ABC");
        property.setValue(Property.UNKNOWN_VALUE);
        PropertyTest.check_constructorAccessor(button, new String[]{"    JButton button = new JButton((String) null);"}, new String[]{"new JButton((String) null)"});
    }

    private static void check_constructorAccessor(JavaInfo button, String[] lines, String[] relatedNodes) throws Exception {
        String[] lines_prefix = new String[]{"package test;", "import java.awt.*;", "import javax.swing.*;", "class Test {", "  public static void main(String args[]) {"};
        String[] lines_suffix = new String[]{"  }", "}"};
        AstEditor editor = button.getEditor();
        PropertyTest.assertAST(editor);
        PropertyTest.assertEquals((Object)PropertyTest.getSource3(lines_prefix, lines, lines_suffix), (Object)editor.getSource());
        PropertyTest.assertRelatedNodes(button, relatedNodes);
    }

    @Test
    public void test_StandardBeanPropertiesRule_twoSettersWithSameName() throws Exception {
        PropertyTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public void setFoo(String text) {", "  }", "  public void setFoo(String[] text) {", "  }", "}"));
        PropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        PropertyTest.assertNotNull((Object)button.getPropertyByTitle("foo(java.lang.String)"));
        PropertyTest.assertNotNull((Object)button.getPropertyByTitle("foo(java.lang.String[])"));
    }

    @Test
    public void test_arbitraryValuesMap() throws Exception {
        PropertyNoValue property = new PropertyNoValue(StringPropertyEditor.INSTANCE);
        String key = "myKey";
        PropertyTest.assertNull((Object)property.getArbitraryValue(key));
        property.putArbitraryValue(key, (Object)this);
        PropertyTest.assertSame((Object)((Object)this), (Object)property.getArbitraryValue(key));
        property.removeArbitraryValue(key);
        PropertyTest.assertNull((Object)property.getArbitraryValue(key));
    }
}

