/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.osgi.framework.Bundle;

public class TestProject {
    private static final Logger LOGGER = Logger.getLogger("TestProject");
    private final IProject m_project;
    private final IJavaProject m_javaProject;
    private static long m_totalWaitForAutoBuild;

    public TestProject() throws CoreException {
        this("TestProject");
    }

    public TestProject(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.m_project = root.getProject(projectName);
        if (this.m_project.exists()) {
            this.m_project.delete(true, true, null);
        }
        this.m_project.create(null);
        this.m_project.open(null);
        this.m_javaProject = JavaCore.create((IProject)this.m_project);
        IFolder binFolder = this.createBinFolder();
        this.setJavaNature();
        this.m_javaProject.setRawClasspath(new IClasspathEntry[0], null);
        this.addSystemLibraries();
        this.createOutputFolder(binFolder);
        this.createSourceFolder();
    }

    public TestProject(IProject project) {
        this.m_project = project;
        this.m_javaProject = JavaCore.create((IProject)this.m_project);
    }

    private IPackageFragmentRoot createSourceFolder() throws CoreException {
        IFolder srcFolder = this.m_project.getFolder("src");
        if (!srcFolder.exists()) {
            srcFolder.create(true, true, null);
        }
        IPackageFragmentRoot root = this.m_javaProject.getPackageFragmentRoot((IResource)srcFolder);
        IClasspathEntry[] oldEntries = this.m_javaProject.getRawClasspath();
        IClasspathEntry newEntry = JavaCore.newSourceEntry((IPath)root.getPath());
        IClasspathEntry[] iClasspathEntryArray = oldEntries;
        int n = oldEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry oldEntry = iClasspathEntryArray[n2];
            if (Objects.equals(oldEntry.getPath(), newEntry.getPath())) {
                return root;
            }
            ++n2;
        }
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)root.getPath());
        this.m_javaProject.setRawClasspath(newEntries, null);
        return root;
    }

    private IFolder createBinFolder() throws CoreException {
        IFolder binFolder = this.m_project.getFolder("bin");
        if (!binFolder.exists()) {
            binFolder.create(true, true, null);
        }
        return binFolder;
    }

    private void setJavaNature() throws CoreException {
        IProjectDescription description = this.m_project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        this.m_project.setDescription(description, null);
    }

    private void createOutputFolder(IFolder binFolder) throws JavaModelException {
        IPath outputLocation = binFolder.getFullPath();
        this.m_javaProject.setOutputLocation(outputLocation, null);
    }

    private void addSystemLibraries() throws JavaModelException {
        this.addClassPathEntry(JavaRuntime.getDefaultJREContainerEntry());
    }

    public void addExternalJar(File jar) throws JavaModelException {
        String location = jar.getAbsolutePath();
        this.addExternalJar(location);
    }

    public void addExternalJar(String location) throws JavaModelException {
        this.addClassPathEntry(JavaCore.newLibraryEntry((IPath)new Path(location), null, null));
    }

    public void addExternalJars(String folderLocation) throws JavaModelException {
        File folder = new File(folderLocation);
        Assert.isTrue((boolean)folder.exists(), (String)("Does not exist: " + folderLocation));
        Assert.isTrue((boolean)folder.isDirectory(), (String)("Is not directory: " + folderLocation));
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String absolutePath = file.getAbsolutePath();
            if (absolutePath.endsWith(".jar")) {
                this.addExternalJar(absolutePath);
            }
            ++n2;
        }
    }

    public void addPlugin(String pluginId) throws CoreException {
        ArrayList entries = new ArrayList();
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(pluginId);
        ClasspathUtilCore.addLibraries((IPluginModelBase)model, entries);
        for (IClasspathEntry entry : entries) {
            this.addClassPathEntry(entry);
        }
    }

    public void addBundleJars(String bundleId) throws Exception {
        this.addBundleJars(bundleId, "/");
    }

    public void addBundleJars(String bundleId, String path) throws Exception {
        Bundle bundle = Platform.getBundle((String)bundleId);
        Enumeration entries = bundle.findEntries(path, "*.jar", false);
        while (entries.hasMoreElements()) {
            URL jarURL = (URL)entries.nextElement();
            String jarPath = FileLocator.toFileURL((URL)jarURL).getPath();
            this.addExternalJar(jarPath);
        }
    }

    public void addSourceFolder(String pathLocation) throws JavaModelException {
        Path path = new Path(pathLocation);
        IClasspathEntry entry = JavaCore.newSourceEntry((IPath)path);
        this.addClassPathEntry(entry);
    }

    public void removeSourceFolder(String pathLocation) throws JavaModelException {
        Object[] oldEntries = this.m_javaProject.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            IClasspathEntry entry = oldEntries[i];
            if (entry.getPath().toPortableString().equals(pathLocation)) {
                IClasspathEntry[] newEntries = (IClasspathEntry[])ArrayUtils.remove((Object[])oldEntries, (int)i);
                this.m_javaProject.setRawClasspath(newEntries, null);
            }
            ++i;
        }
    }

    public void addRequiredProject(TestProject requiredProject) throws CoreException {
        this.addRequiredProject(requiredProject.getProject());
    }

    public void addRequiredProject(IProject requiredProject) throws CoreException {
        IClasspathEntry projectEntry = JavaCore.newProjectEntry((IPath)requiredProject.getFullPath());
        this.addClassPathEntry(projectEntry);
    }

    private void addClassPathEntry(IClasspathEntry newEntry) throws JavaModelException {
        IClasspathEntry[] oldEntries = this.m_javaProject.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            IClasspathEntry entry = oldEntries[i];
            if (entry.getPath().equals((Object)newEntry.getPath())) {
                return;
            }
            ++i;
        }
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = newEntry;
        this.m_javaProject.setRawClasspath(newEntries, null);
    }

    public IProject getProject() {
        return this.m_project;
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public void dispose() throws CoreException {
        this.clearReadOnlyFlag();
        this.m_project.delete(true, true, null);
        try {
            Class<?> readerClass = this.getClass().getClassLoader().loadClass("org.eclipse.core.internal.resources.ProjectDescriptionReader");
            ReflectionUtils.setField(readerClass, (String)"singletonParser", null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public IPackageFragmentRoot getSourceFolder() throws CoreException {
        IPackageFragmentRoot[] packageRoots;
        IPackageFragmentRoot[] iPackageFragmentRootArray = packageRoots = this.m_javaProject.getPackageFragmentRoots();
        int n = packageRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot packageRoot = iPackageFragmentRootArray[n2];
            if (packageRoot.getKind() == 1) {
                return packageRoot;
            }
            ++n2;
        }
        LOGGER.warning("Can not find source folder, new one is created instead...");
        return this.createSourceFolder();
    }

    public IPackageFragment getPackage(String name) throws CoreException {
        IPackageFragmentRoot sourceFolder = this.getSourceFolder();
        IPackageFragment packageFragment = sourceFolder.getPackageFragment(name);
        if (packageFragment == null || !packageFragment.exists()) {
            packageFragment = sourceFolder.createPackageFragment(name, true, null);
        }
        return packageFragment;
    }

    public ICompilationUnit createUnit(IPackageFragment pack, String cuName, String source) throws JavaModelException {
        return pack.createCompilationUnit(cuName, source, true, null);
    }

    public IFile createFile(IPackageFragment pack, String fileName, String contents) throws Exception {
        IFolder folder = (IFolder)pack.getUnderlyingResource();
        IFile file = folder.getFile(fileName);
        file.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, null);
        return file;
    }

    public ICompilationUnit getCompilationUnit(String typeName) throws JavaModelException {
        return this.getJavaProject().findType(typeName).getCompilationUnit();
    }

    public static void waitForAutoBuild() {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                IJobManager jobManager = Job.getJobManager();
                jobManager.wakeUp(ResourcesPlugin.FAMILY_AUTO_BUILD);
                jobManager.wakeUp(ResourcesPlugin.FAMILY_AUTO_BUILD);
                jobManager.wakeUp(ResourcesPlugin.FAMILY_AUTO_BUILD);
                jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new MyNullProgressMonitor());
            }
            catch (Throwable jobManager) {
                continue;
            }
            break;
        }
        long delta = System.currentTimeMillis() - start;
        m_totalWaitForAutoBuild += delta;
    }

    private void clearReadOnlyFlag() throws CoreException {
        if (this.m_project.isOpen()) {
            this.m_project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IFile file;
                    ResourceAttributes resourceAttributes;
                    if (resource instanceof IFile && (resourceAttributes = (file = (IFile)resource).getResourceAttributes()) != null) {
                        resourceAttributes.setReadOnly(false);
                        file.setResourceAttributes(resourceAttributes);
                    }
                    return true;
                }
            });
        }
    }

    private static final class MyNullProgressMonitor
    implements IProgressMonitor {
        private MyNullProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }
    }
}

