/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.lang.reflect.Field;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.DragPermissionRequest;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.tools.SelectionTool;
import org.eclipse.wb.tests.gef.RequestTestCase;
import org.eclipse.wb.tests.gef.RequestTestCaseEditPart;
import org.eclipse.wb.tests.gef.RequestsLogger;
import org.junit.Before;
import org.junit.Test;

public class SelectionToolTest
extends RequestTestCase {
    private SelectionTool m_tool;
    private SelectionRequest m_request;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_tool = new SelectionTool();
        this.m_domain.setActiveTool((Tool)this.m_tool);
        this.m_request = new SelectionRequest();
        this.m_request.setType((Object)"selection");
    }

    @Test
    public void test_Move() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = SelectionToolTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "ParentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart1 = SelectionToolTest.addEditPart((EditPart)editPart, "ChildEditPart1", actualLogger, 50, 50, 70, 50);
        RequestTestCaseEditPart childEditPart2 = SelectionToolTest.addEditPart((EditPart)editPart, "ChildEditPart2", actualLogger, 250, 25, 100, 155);
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_sender.moveTo(10, 10);
        actualLogger.assertEmpty();
        this.m_sender.moveTo(60, 60);
        this.m_request.setLocation(new Point(60, 60));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "showTargetFeedback", "showTargetFeedback"}, (Request)this.m_request);
        SelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.moveTo(70, 70);
        this.m_request.setLocation(new Point(70, 70));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "showTargetFeedback"}, (Request)this.m_request);
        SelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.moveTo(120, 120);
        this.m_request.setLocation(new Point(120, 120));
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "getTargetEditPart", (Request)this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "eraseTargetFeedback", (Request)this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, new String[]{"showTargetFeedback", "showTargetFeedback"}, (Request)this.m_request);
        SelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.moveTo(320, 90);
        this.m_request.setLocation(new Point(320, 90));
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "getTargetEditPart", (Request)this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "eraseTargetFeedback", (Request)this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, new String[]{"showTargetFeedback", "showTargetFeedback"}, (Request)this.m_request);
        SelectionToolTest.assertLoggers(expectedLogger, actualLogger);
    }

    @Test
    public void test_DragTracker() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = SelectionToolTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "ParentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart = SelectionToolTest.addEditPart((EditPart)editPart, "ChildEditPart", actualLogger, 50, 50, 70, 50);
        RequestsLogger expectedLogger = new RequestsLogger();
        SelectionToolTest.assertNull((Object)SelectionToolTest.getDragTracker(this.m_tool));
        org.eclipse.wb.gef.core.tools.Tool tracker = null;
        this.m_sender.startDrag(135, 125, 1);
        tracker = SelectionToolTest.getDragTracker(this.m_tool);
        SelectionToolTest.assertNotNull((Object)tracker);
        SelectionToolTest.assertTrue((boolean)tracker.isActive());
        this.m_request.setLocation(new Point(135, 125));
        this.m_request.setLastButtonPressed(1);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart, new String[]{"getTargetEditPart", "showTargetFeedback"}, (Request)this.m_request);
        SelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.dragTo(150, 150);
        SelectionToolTest.assertSame((Object)tracker, (Object)SelectionToolTest.getDragTracker(this.m_tool));
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart, "performRequest", (Request)new DragPermissionRequest());
        request.setLocation(new Point(150, 150));
        request.setMoveDelta(new Point(15, 25));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart"}, (Request)request);
        request.setType((Object)"move");
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "showTargetFeedback", (Request)request);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart", "showTargetFeedback", "getCommand"}, (Request)request);
        SelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.endDrag();
        SelectionToolTest.assertNull((Object)SelectionToolTest.getDragTracker(this.m_tool));
        SelectionToolTest.assertFalse((boolean)tracker.isActive());
        request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart);
        request.setLocation(new Point(150, 150));
        request.setMoveDelta(new Point(15, 25));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "eraseTargetFeedback", (Request)request);
        this.m_request.setLastButtonPressed(0);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "getTargetEditPart", (Request)this.m_request);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart, "eraseTargetFeedback", (Request)this.m_request);
        this.m_request.setLocation(new Point(150, 150));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "showTargetFeedback", (Request)this.m_request);
        SelectionToolTest.assertLoggers(expectedLogger, actualLogger);
    }

    @Test
    public void test_DragTracker_MoveHandle() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = SelectionToolTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "ParentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart = SelectionToolTest.addEditPart((EditPart)editPart, "ChildEditPart", actualLogger, 50, 50, 70, 50);
        MoveHandle handle = new MoveHandle((GraphicalEditPart)childEditPart);
        this.m_viewer.getLayer("Handle Layer").add((IFigure)handle);
        RequestsLogger expectedLogger = new RequestsLogger();
        SelectionToolTest.assertNull((Object)SelectionToolTest.getDragTracker(this.m_tool));
        this.m_sender.startDrag(100, 100, 1);
        org.eclipse.wb.gef.core.tools.Tool tracker = SelectionToolTest.getDragTracker(this.m_tool);
        SelectionToolTest.assertNotNull((Object)tracker);
        SelectionToolTest.assertTrue((boolean)tracker.isActive());
        SelectionToolTest.assertSame((Object)handle.getDragTrackerTool(), (Object)tracker);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(150, 150);
        SelectionToolTest.assertSame((Object)handle.getDragTrackerTool(), (Object)SelectionToolTest.getDragTracker(this.m_tool));
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart, "performRequest", (Request)new DragPermissionRequest());
        request.setLocation(new Point(150, 150));
        request.setMoveDelta(new Point(50, 50));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart"}, (Request)request);
        request.setType((Object)"move");
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "showTargetFeedback", (Request)request);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart", "showTargetFeedback", "getCommand"}, (Request)request);
        SelectionToolTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.endDrag();
        SelectionToolTest.assertNull((Object)SelectionToolTest.getDragTracker(this.m_tool));
        SelectionToolTest.assertFalse((boolean)handle.getDragTrackerTool().isActive());
        request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart);
        request.setLocation(new Point(150, 150));
        request.setMoveDelta(new Point(50, 50));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "eraseTargetFeedback", (Request)request);
        this.m_request.setLastButtonPressed(0);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "getTargetEditPart", (Request)this.m_request);
        this.m_request.setLocation(new Point(150, 150));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "showTargetFeedback", (Request)this.m_request);
        SelectionToolTest.assertLoggers(expectedLogger, actualLogger);
    }

    private static final org.eclipse.wb.gef.core.tools.Tool getDragTracker(SelectionTool tool) throws Exception {
        Field field = SelectionTool.class.getDeclaredField("m_dragTracker");
        field.setAccessible(true);
        return (org.eclipse.wb.gef.core.tools.Tool)field.get(tool);
    }
}

