/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.EmptyAssociation;
import org.eclipse.wb.core.model.association.InvocationSecondaryAssociation;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.Activator;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.ColumnInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagConstraintsInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.RowInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.VirtualConstraintsCreationSupport;
import org.eclipse.wb.internal.swing.model.layout.gbl.VirtualConstraintsVariableSupport;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.Ignore;
import org.junit.Test;

public class GridBagConstraintsTest
extends AbstractGridBagLayoutTest {
    private static final AlignmentTestData[] m_alignmentTestArray = new AlignmentTestData[]{new AlignmentTestData(0, 10, ColumnInfo.Alignment.CENTER, RowInfo.Alignment.CENTER), new AlignmentTestData(2, 10, ColumnInfo.Alignment.FILL, RowInfo.Alignment.CENTER), new AlignmentTestData(1, 10, ColumnInfo.Alignment.FILL, RowInfo.Alignment.FILL), new AlignmentTestData(0, 512, ColumnInfo.Alignment.LEFT, RowInfo.Alignment.BASELINE), new AlignmentTestData(0, 1536, ColumnInfo.Alignment.RIGHT, RowInfo.Alignment.BASELINE_ABOVE), new AlignmentTestData(2, 2304, ColumnInfo.Alignment.FILL, RowInfo.Alignment.BASELINE_BELOW)};

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_notGridBagLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagConstraintsTest.assertNoErrors((JavaInfo)panel);
        GridBagConstraintsTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button, gbc)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button, gbc)/}", "    {new: java.awt.GridBagConstraints} {local-unique: gbc} {/new GridBagConstraints()/ /add(button, gbc)/}");
    }

    @Test
    public void test_access() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        GridBagConstraintsTest.assertSame(layout.getColumns().get(0), (Object)constraints.getColumn());
        GridBagConstraintsTest.assertSame(layout.getRows().get(0), (Object)constraints.getRow());
    }

    @Test
    public void test_properties() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton('button');", "      add(button, new GridBagConstraints(99, 0, 1, 1, 0.0, 0.0,", "          GridBagConstraints.CENTER, GridBagConstraints.BOTH,", "          new Insets(0, 0, 5, 5), 0, 0));", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        GridBagConstraintsTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)constraints.getCreationSupport());
        GridBagConstraintsTest.assertInstanceOf(EmptyVariableSupport.class, (Object)constraints.getVariableSupport());
        GridBagConstraintsTest.assertVisible((ObjectInfo)constraints, false);
        ComplexProperty constraintsProperty = (ComplexProperty)button.getPropertyByTitle("Constraints");
        GridBagConstraintsTest.assertNotNull((Object)constraintsProperty);
        GridBagConstraintsTest.assertTrue((boolean)constraintsProperty.isModified());
        Property property = this.getConstraintsProperty(button, "gridx");
        GridBagConstraintsTest.assertEquals((Object)99, (Object)property.getValue());
        GridBagConstraintsTest.assertEquals((long)99L, (long)constraints.getX());
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"GridBagConstraints(99, ", (String)"GridBagConstraints(1, ");
        property.setValue((Object)1);
        GridBagConstraintsTest.assertEditor(expectedSource, this.m_lastEditor);
        GridBagConstraintsTest.assertEquals((long)1L, (long)constraints.getX());
    }

    @Test
    public void test_locationRelative_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_1 = new JButton('button 1');", "      add(button_1, new GridBagConstraints());", "    }", "    {", "      JButton button_2 = new JButton('button 1');", "      add(button_2, new GridBagConstraints());", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button_1);
        GridBagConstraintsTest.assertEquals((long)0L, (long)constraints.getX());
        GridBagConstraintsTest.assertEquals((long)0L, (long)constraints.getY());
        GridBagConstraintsTest.assertEquals((long)1L, (long)constraints.getWidth());
        GridBagConstraintsTest.assertEquals((long)1L, (long)constraints.getHeight());
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button_2);
        GridBagConstraintsTest.assertEquals((long)1L, (long)constraints.getX());
        GridBagConstraintsTest.assertEquals((long)0L, (long)constraints.getY());
        GridBagConstraintsTest.assertEquals((long)1L, (long)constraints.getWidth());
        GridBagConstraintsTest.assertEquals((long)1L, (long)constraints.getHeight());
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagConstraintsTest.assertEquals((long)2L, (long)gridInfo.getColumnCount());
        GridBagConstraintsTest.assertEquals((long)1L, (long)gridInfo.getRowCount());
        GridBagConstraintsTest.assertEquals((long)2L, (long)layout.getColumns().size());
        GridBagConstraintsTest.assertEquals((long)1L, (long)layout.getRows().size());
    }

    @Test
    public void test_locationRelative_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_1 = new JButton('button 1');", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton('button 2');", "      add(button_2);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button_1);
        GridBagConstraintsTest.assertEquals((long)0L, (long)constraints.getX());
        GridBagConstraintsTest.assertEquals((long)0L, (long)constraints.getY());
        GridBagConstraintsTest.assertEquals((long)1L, (long)constraints.getWidth());
        GridBagConstraintsTest.assertEquals((long)1L, (long)constraints.getHeight());
        constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button_2);
        GridBagConstraintsTest.assertEquals((long)1L, (long)constraints.getX());
        GridBagConstraintsTest.assertEquals((long)0L, (long)constraints.getY());
        GridBagConstraintsTest.assertEquals((long)1L, (long)constraints.getWidth());
        GridBagConstraintsTest.assertEquals((long)1L, (long)constraints.getHeight());
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagConstraintsTest.assertEquals((long)2L, (long)gridInfo.getColumnCount());
        GridBagConstraintsTest.assertEquals((long)1L, (long)gridInfo.getRowCount());
        GridBagConstraintsTest.assertEquals((long)2L, (long)layout.getColumns().size());
        GridBagConstraintsTest.assertEquals((long)1L, (long)layout.getRows().size());
        GridBagConstraintsTest.assertEquals((long)button_1.getComponent().getX(), (long)gridInfo.getColumnIntervals()[0].begin());
        GridBagConstraintsTest.assertEquals((long)button_2.getComponent().getX(), (long)gridInfo.getColumnIntervals()[1].begin());
        GridBagConstraintsTest.assertEquals((long)button_2.getComponent().getY(), (long)gridInfo.getRowIntervals()[0].begin());
        GridBagConstraintsTest.assertEquals((long)button_1.getComponent().getWidth(), (long)gridInfo.getColumnIntervals()[0].length());
        GridBagConstraintsTest.assertEquals((long)button_2.getComponent().getWidth(), (long)gridInfo.getColumnIntervals()[1].length());
        GridBagConstraintsTest.assertEquals((long)button_1.getComponent().getHeight(), (long)gridInfo.getRowIntervals()[0].length());
        GridBagConstraintsTest.assertEquals((long)button_2.getComponent().getHeight(), (long)gridInfo.getRowIntervals()[0].length());
    }

    @Test
    public void test_virtualShort() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton('button');", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        String initialSource = this.m_lastEditor.getSource();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        GridBagConstraintsTest.assertEditor(initialSource, this.m_lastEditor);
        CreationSupport creation = constraints.getCreationSupport();
        GridBagConstraintsTest.assertInstanceOf(VirtualConstraintsCreationSupport.class, (Object)creation);
        GridBagConstraintsTest.assertFalse((boolean)creation.isJavaInfo(null));
        GridBagConstraintsTest.assertNull((Object)creation.getNode());
        GridBagConstraintsTest.assertEquals((Object)"virtual-GBL-constraints", (Object)creation.toString());
        VariableSupport variable = constraints.getVariableSupport();
        GridBagConstraintsTest.assertInstanceOf(VirtualConstraintsVariableSupport.class, (Object)variable);
        GridBagConstraintsTest.assertEquals((Object)"(virtual GBL constraints)", (Object)variable.getTitle());
        GridBagConstraintsTest.assertEquals((Object)"virtual-GBL-constraints", (Object)variable.toString());
        try {
            variable.getStatementTarget();
            GridBagConstraintsTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        GridBagConstraintsTest.assertInstanceOf(EmptyAssociation.class, (Object)constraints.getAssociation());
        GridBagConstraintsTest.assertTrue((boolean)constraints.canDelete());
        constraints.delete();
        GridBagConstraintsInfo newConstraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        GridBagConstraintsTest.assertNotSame((Object)constraints, (Object)newConstraints);
        constraints = newConstraints;
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", false);
        Property property = this.getConstraintsProperty(button, "gridx");
        property.setValue((Object)1);
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton('button');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      add(button, gbc);", "    }", "  }", "}");
        CreationSupport creationSupport = constraints.getCreationSupport();
        GridBagConstraintsTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)creationSupport);
        VariableSupport variableSupport = constraints.getVariableSupport();
        GridBagConstraintsTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)variableSupport);
        GridBagConstraintsTest.assertEquals((Object)"gbc", (Object)variableSupport.getName());
        Association association = constraints.getAssociation();
        GridBagConstraintsTest.assertInstanceOf(InvocationSecondaryAssociation.class, (Object)association);
        GridBagConstraintsTest.assertEquals((Object)"add(button, gbc)", (Object)association.getSource());
        GridBagConstraintsTest.assertEquals((Object)"{new: java.awt.GridBagConstraints} {local-unique: gbc} {/new GridBagConstraints()/ /add(button, gbc)/ /gbc.gridx = 1/}", (Object)constraints.toString());
    }

    @Test
    public void test_virtualLong() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton('button');", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", true);
        Property property = this.getConstraintsProperty(button, "gridx");
        property.setValue((Object)1);
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton(\"button\");", "      add(button, new GridBagConstraints(1, GridBagConstraints.RELATIVE, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));", "    }", "  }", "}");
    }

    @Test
    public void test_moreThanOneConstraints() throws Exception {
        try {
            this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      add(button, new GridBagConstraints());", "      add(button, new GridBagConstraints());", "    }", "  }", "}");
        }
        catch (Throwable e) {
            DesignerException de = DesignerExceptionUtils.getDesignerException((Throwable)e);
            GridBagConstraintsTest.assertEquals((long)1001L, (long)de.getCode());
        }
    }

    @Test
    public void test_accessMaterialize() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", false);
        constraints.setX(1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_accessMaterialize_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", false);
        constraints.materializeLocation();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_setX() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      add(button, c);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        constraints.setX(1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      c.gridx = 1;", "      add(button, c);", "    }", "  }", "}");
    }

    @Test
    public void test_setProperty_gridx() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    GridBagLayout gridBagLayout = new GridBagLayout();", "    gridBagLayout.columnWidths = new int[]{100, 200};", "    gridBagLayout.rowHeights = new int[]{50, 75};", "    setLayout(gridBagLayout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      add(button, c);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.getConstraintsProperty(button, "gridx").setValue((Object)1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    GridBagLayout gridBagLayout = new GridBagLayout();", "    gridBagLayout.columnWidths = new int[]{100, 200};", "    gridBagLayout.rowHeights = new int[]{50, 75};", "    setLayout(gridBagLayout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      c.gridx = 1;", "      add(button, c);", "    }", "  }", "}");
        this.getConstraintsProperty(button, "gridx").setValue((Object)100);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    GridBagLayout gridBagLayout = new GridBagLayout();", "    gridBagLayout.columnWidths = new int[]{100, 200};", "    gridBagLayout.rowHeights = new int[]{50, 75};", "    setLayout(gridBagLayout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      c.gridx = 1;", "      add(button, c);", "    }", "  }", "}");
        this.getConstraintsProperty(button, "gridx").setValue((Object)2);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    GridBagLayout gridBagLayout = new GridBagLayout();", "    gridBagLayout.columnWidths = new int[]{100, 200, 0};", "    gridBagLayout.rowHeights = new int[]{50, 75};", "    setLayout(gridBagLayout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      c.gridx = 2;", "      add(button, c);", "    }", "  }", "}");
    }

    @Test
    public void test_setY() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      add(button, c);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        constraints.setY(1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      c.gridy = 1;", "      add(button, c);", "    }", "  }", "}");
    }

    @Test
    public void test_setProperty_gridy() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    GridBagLayout gridBagLayout = new GridBagLayout();", "    gridBagLayout.columnWidths = new int[]{100, 200};", "    gridBagLayout.rowHeights = new int[]{50, 75};", "    setLayout(gridBagLayout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      add(button, c);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.getConstraintsProperty(button, "gridy").setValue((Object)1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    GridBagLayout gridBagLayout = new GridBagLayout();", "    gridBagLayout.columnWidths = new int[]{100, 200};", "    gridBagLayout.rowHeights = new int[]{50, 75};", "    setLayout(gridBagLayout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      c.gridy = 1;", "      add(button, c);", "    }", "  }", "}");
        this.getConstraintsProperty(button, "gridy").setValue((Object)3);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    GridBagLayout gridBagLayout = new GridBagLayout();", "    gridBagLayout.columnWidths = new int[]{100, 200};", "    gridBagLayout.rowHeights = new int[]{50, 75, 0, 0};", "    setLayout(gridBagLayout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      c.gridy = 3;", "      add(button, c);", "    }", "  }", "}");
    }

    @Test
    public void test_accessLocation_width() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      add(button, c);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        constraints.setWidth(2);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      c.gridwidth = 2;", "      add(button, c);", "    }", "  }", "}");
    }

    @Test
    public void test_accessLocation_height() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      add(button, c);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        constraints.setHeight(2);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      c.gridheight = 2;", "      add(button, c);", "    }", "  }", "}");
    }

    @Test
    public void test_accessOther_insets() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      add(button, c);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        GridBagConstraintsTest.assertEquals((long)0L, (long)constraints.getInsets("right"));
        constraints.setInsets("right", 5);
        GridBagConstraintsTest.assertEquals((long)5L, (long)constraints.getInsets("right"));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints c = new GridBagConstraints();", "      c.insets = new Insets(0, 0, 0, 5);", "      add(button, c);", "    }", "  }", "}");
    }

    @Test
    public void test_alignments() throws Exception {
        AlignmentTestData[] alignmentTestDataArray = m_alignmentTestArray;
        int n = m_alignmentTestArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlignmentTestData testData = alignmentTestDataArray[n2];
            GridBagConstraintsTest.assertSame((Object)testData.m_horizontalAlignment, (Object)ReflectionUtils.invokeMethod2(GridBagConstraintsInfo.class, (String)"getHorizontalAlignment", Integer.TYPE, Integer.TYPE, (Object)testData.fill, (Object)testData.anchor));
            GridBagConstraintsTest.assertSame((Object)testData.m_verticalAlignment, (Object)ReflectionUtils.invokeMethod2(GridBagConstraintsInfo.class, (String)"getVerticalAlignment", Integer.TYPE, Integer.TYPE, (Object)testData.fill, (Object)testData.anchor));
            ++n2;
        }
    }

    @Test
    public void test_alignments_unknownHorizontal() throws Exception {
        try {
            ReflectionUtils.invokeMethod2(GridBagConstraintsInfo.class, (String)"getHorizontalAlignment", Integer.TYPE, Integer.TYPE, (Object)-1, (Object)-1);
            GridBagConstraintsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_alignments_unknownVertical() throws Exception {
        try {
            ReflectionUtils.invokeMethod2(GridBagConstraintsInfo.class, (String)"getVerticalAlignment", Integer.TYPE, Integer.TYPE, (Object)-1, (Object)-1);
            GridBagConstraintsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getAlignment_bySource() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.anchor = GridBagConstraints.SOUTHWEST;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo component = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)component);
        GridBagConstraintsTest.assertSame((Object)ColumnInfo.Alignment.LEFT, (Object)constraints.getHorizontalAlignment());
        GridBagConstraintsTest.assertSame((Object)RowInfo.Alignment.BOTTOM, (Object)constraints.getVerticalAlignment());
    }

    @Test
    public void test_setAlignment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        this.check_setAlignment(panel, ColumnInfo.Alignment.LEFT, null, null, "WEST");
        this.check_setAlignment(panel, ColumnInfo.Alignment.RIGHT, null, null, "EAST");
        this.check_setAlignment(panel, ColumnInfo.Alignment.FILL, null, "HORIZONTAL", null);
        this.check_setAlignment(panel, ColumnInfo.Alignment.CENTER, RowInfo.Alignment.CENTER, null, null);
        this.check_setAlignment(panel, null, RowInfo.Alignment.FILL, "VERTICAL", null);
        this.check_setAlignment(panel, null, RowInfo.Alignment.BOTTOM, null, "SOUTH");
        this.check_setAlignment(panel, ColumnInfo.Alignment.RIGHT, RowInfo.Alignment.TOP, null, "NORTHEAST");
        this.check_setAlignment(panel, ColumnInfo.Alignment.CENTER, RowInfo.Alignment.BOTTOM, null, "SOUTH");
        this.check_setAlignment(panel, ColumnInfo.Alignment.FILL, RowInfo.Alignment.FILL, "BOTH", null);
    }

    private void check_setAlignment(ContainerInfo panel, ColumnInfo.Alignment hAlignment, RowInfo.Alignment vAlignment, String expectedFillSource, String expectedAnchorSource) throws Exception {
        ComponentInfo component = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)component);
        if (hAlignment == null) {
            ColumnInfo.Alignment old_hAlignment = constraints.getHorizontalAlignment();
            constraints.setVerticalAlignment(vAlignment);
            GridBagConstraintsTest.assertSame((Object)vAlignment, (Object)constraints.getVerticalAlignment());
            GridBagConstraintsTest.assertSame((Object)old_hAlignment, (Object)constraints.getHorizontalAlignment());
        } else if (vAlignment == null) {
            RowInfo.Alignment old_vAlignment = constraints.getVerticalAlignment();
            constraints.setHorizontalAlignment(hAlignment);
            GridBagConstraintsTest.assertSame((Object)hAlignment, (Object)constraints.getHorizontalAlignment());
            GridBagConstraintsTest.assertSame((Object)old_vAlignment, (Object)constraints.getVerticalAlignment());
        } else {
            constraints.setAlignment(hAlignment, vAlignment);
            GridBagConstraintsTest.assertSame((Object)hAlignment, (Object)constraints.getHorizontalAlignment());
            GridBagConstraintsTest.assertSame((Object)vAlignment, (Object)constraints.getVerticalAlignment());
        }
        GenericPropertyImpl property = (GenericPropertyImpl)constraints.getPropertyByTitle("fill");
        Expression expression = property.getExpression();
        if (expectedFillSource == null) {
            GridBagConstraintsTest.assertNull((Object)expression);
        } else {
            GridBagConstraintsTest.assertEquals((Object)("GridBagConstraints." + expectedFillSource), (Object)this.m_lastEditor.getSource((ASTNode)expression));
        }
        property = (GenericPropertyImpl)constraints.getPropertyByTitle("anchor");
        expression = property.getExpression();
        if (expectedAnchorSource == null) {
            GridBagConstraintsTest.assertNull((Object)expression);
        } else {
            GridBagConstraintsTest.assertEquals((Object)("GridBagConstraints." + expectedAnchorSource), (Object)this.m_lastEditor.getSource((ASTNode)expression));
        }
    }

    @Test
    public void test_contextMenu_horizontalLeft() throws Exception {
        this.check_contextMenu_alignmentHorizontal("&Left", ColumnInfo.Alignment.LEFT, "WEST", "NONE");
    }

    @Test
    public void test_contextMenu_horizontalCenter() throws Exception {
        this.check_contextMenu_alignmentHorizontal("&Center", ColumnInfo.Alignment.CENTER, "CENTER", "NONE");
    }

    @Test
    public void test_contextMenu_horizontalRight() throws Exception {
        this.check_contextMenu_alignmentHorizontal("&Right", ColumnInfo.Alignment.RIGHT, "EAST", "NONE");
    }

    @Test
    public void test_contextMenu_horizontalFill() throws Exception {
        this.check_contextMenu_alignmentHorizontal("&Fill", ColumnInfo.Alignment.FILL, "CENTER", "HORIZONTAL");
    }

    @Test
    public void test_contextMenu_verticalTop() throws Exception {
        this.check_contextMenu_alignmentVertical("&Top", RowInfo.Alignment.TOP, "NORTH", "NONE");
    }

    @Test
    public void test_contextMenu_verticalCenter() throws Exception {
        this.check_contextMenu_alignmentVertical("&Center", RowInfo.Alignment.CENTER, "CENTER", "NONE");
    }

    @Test
    public void test_contextMenu_verticalBottom() throws Exception {
        this.check_contextMenu_alignmentVertical("&Bottom", RowInfo.Alignment.BOTTOM, "SOUTH", "NONE");
    }

    @Test
    public void test_contextMenu_verticalFill() throws Exception {
        this.check_contextMenu_alignmentVertical("&Fill", RowInfo.Alignment.FILL, "CENTER", "VERTICAL");
    }

    @Ignore
    @Test
    public void test_contextMenu_verticalBaseline() throws Exception {
        this.check_contextMenu_alignmentVertical("Baseline", RowInfo.Alignment.BASELINE, "BASELINE", "NONE");
    }

    @Ignore
    @Test
    public void test_contextMenu_verticalBaselineAbove() throws Exception {
        this.check_contextMenu_alignmentVertical("Above baseline", RowInfo.Alignment.BASELINE_ABOVE, "ABOVE_BASELINE", "NONE");
    }

    @Ignore
    @Test
    public void test_contextMenu_verticalBaselineBelow() throws Exception {
        this.check_contextMenu_alignmentVertical("Below baseline", RowInfo.Alignment.BASELINE_BELOW, "BELOW_BASELINE", "NONE");
    }

    private void check_contextMenu_alignmentHorizontal(String actionText, ColumnInfo.Alignment expectedHorizontalAlignment, String expectedAnchorSource, String expectedFillSource) throws Exception {
        this.check_contextMenu_alignment("Horizontal alignment", actionText, expectedHorizontalAlignment, RowInfo.Alignment.CENTER, expectedAnchorSource, expectedFillSource);
    }

    private void check_contextMenu_alignmentVertical(String actionText, RowInfo.Alignment expectedVerticalAlignment, String expectedAnchorSource, String expectedFillSource) throws Exception {
        this.check_contextMenu_alignment("Vertical alignment", actionText, ColumnInfo.Alignment.CENTER, expectedVerticalAlignment, expectedAnchorSource, expectedFillSource);
    }

    private void check_contextMenu_alignment(String managerText, String actionText, ColumnInfo.Alignment expectedHorizontalAlignment, RowInfo.Alignment expectedVerticalAlignment, String expectedAnchorSource, String expectedFillSource) throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.anchor = GridBagConstraints.CENTER;", "      gbc.fill = GridBagConstraints.NONE;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo constraints = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        GridBagConstraintsTest.assertSame((Object)ColumnInfo.Alignment.CENTER, (Object)constraints.getHorizontalAlignment());
        GridBagConstraintsTest.assertSame((Object)RowInfo.Alignment.CENTER, (Object)constraints.getVerticalAlignment());
        MenuManager contextMenu = GridBagConstraintsTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(button), (ObjectInfo)button, (IMenuManager)contextMenu);
        IMenuManager alignmentManager = GridBagConstraintsTest.findChildMenuManager((IContributionManager)contextMenu, managerText);
        GridBagConstraintsTest.assertNotNull((Object)alignmentManager);
        IAction alignmentAction = GridBagConstraintsTest.findChildAction((IContributionManager)alignmentManager, actionText);
        alignmentAction.setChecked(true);
        alignmentAction.run();
        GridBagConstraintsTest.assertSame((Object)expectedHorizontalAlignment, (Object)constraints.getHorizontalAlignment());
        GridBagConstraintsTest.assertSame((Object)expectedVerticalAlignment, (Object)constraints.getVerticalAlignment());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.anchor = GridBagConstraints." + expectedAnchorSource + ";", "      gbc.fill = GridBagConstraints." + expectedFillSource + ";", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_contextMenu_grow() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsTest.assertFalse((boolean)((ColumnInfo)layout.getColumns().get(0)).hasWeight());
        MenuManager contextMenu = GridBagConstraintsTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(button), (ObjectInfo)button, (IMenuManager)contextMenu);
        IMenuManager alignmentManager = GridBagConstraintsTest.findChildMenuManager((IContributionManager)contextMenu, "Horizontal alignment");
        GridBagConstraintsTest.assertNotNull((Object)alignmentManager);
        IAction growAction = GridBagConstraintsTest.findChildAction((IContributionManager)alignmentManager, "Grow");
        growAction.setChecked(true);
        growAction.run();
        GridBagConstraintsTest.assertTrue((boolean)((ColumnInfo)layout.getColumns().get(0)).hasWeight());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {1.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
    }

    private void check_nameTemplate(String template, String ... lines) throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton('button');", "      add(button, new GridBagConstraints());", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)GridBagConstraintsTest.getJavaInfoByName("button");
        Activator.getDefault().getPreferenceStore().setValue("templateConstraintsName", template);
        GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button).getPropertyByTitle("fill").setValue((Object)2);
        this.assertEditor(lines);
    }

    @Test
    public void test_nameTemplate_useDefaultName() throws Exception {
        this.check_nameTemplate("${defaultName}", "class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton('button');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.fill = GridBagConstraints.HORIZONTAL;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_nameTemplate_alternativeTemplate_1() throws Exception {
        this.check_nameTemplate("${constraintsAcronym}${componentName-cap}", "class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton('button');", "      GridBagConstraints gbcButton = new GridBagConstraints();", "      gbcButton.fill = GridBagConstraints.HORIZONTAL;", "      add(button, gbcButton);", "    }", "  }", "}");
    }

    @Test
    public void test_nameTemplate_alternativeTemplate_2() throws Exception {
        this.check_nameTemplate("${componentName}${constraintsClassName}", "class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton('button');", "      GridBagConstraints buttonGridBagConstraints = new GridBagConstraints();", "      buttonGridBagConstraints.fill = GridBagConstraints.HORIZONTAL;", "      add(button, buttonGridBagConstraints);", "    }", "  }", "}");
    }

    private Property getConstraintsProperty(ComponentInfo component, String title) throws Exception {
        ComplexProperty constraintsProperty = (ComplexProperty)component.getPropertyByTitle("Constraints");
        Property[] properties = constraintsProperty.getProperties();
        return GridBagConstraintsTest.getPropertyByTitle(properties, title);
    }

    private static final class AlignmentTestData {
        int fill;
        int anchor;
        ColumnInfo.Alignment m_horizontalAlignment;
        RowInfo.Alignment m_verticalAlignment;

        public AlignmentTestData(int fill, int anchor, ColumnInfo.Alignment horizontalAlignment, RowInfo.Alignment verticalAlignment) {
            this.anchor = anchor;
            this.fill = fill;
            this.m_horizontalAlignment = horizontalAlignment;
            this.m_verticalAlignment = verticalAlignment;
        }
    }
}

