/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout;

import org.eclipse.jface.action.IAction;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Ignore;
import org.junit.Test;

public class AbsoluteLayoutGefTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Ignore
    @Test
    public void test_canvas_CREATE() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t}\n}");
        this.loadCreationBox();
        this.canvas.sideMode().create(100, 50);
        this.canvas.target(panel).in(30, 40).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tBox box = new Box();\n\t\t\tbox.setBounds(30, 40, 100, 50);\n\t\t\tadd(box);\n\t\t}\n\t}\n}");
    }

    @Ignore
    @Test
    public void test_canvas_PASTE() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tBox boxA = new Box();\n\t\t\tboxA.setBounds(10, 20, 100, 50);\n\t\t\tadd(boxA);\n\t\t}\n\t}\n}");
        ComponentInfo boxA = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.select(boxA);
        IAction copyAction = this.getCopyAction();
        AbsoluteLayoutGefTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        AbsoluteLayoutGefTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        this.canvas.sideMode().create(100, 50);
        this.canvas.target(panel).inX(50).inY(100).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tBox boxA = new Box();\n\t\t\tboxA.setBounds(10, 20, 100, 50);\n\t\t\tadd(boxA);\n\t\t}\n\t\t{\n\t\t\tBox box = new Box();\n\t\t\tbox.setBounds(50, 100, 100, 50);\n\t\t\tadd(box);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_canvas_MOVE() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tBox box = new Box();\n\t\t\tbox.setBounds(30, 40, 100, 50);\n\t\t\tadd(box);\n\t\t}\n\t}\n}");
        ComponentInfo box = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.sideMode().beginMove(box);
        this.canvas.target(panel).inX(50).inY(80).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tBox box = new Box();\n\t\t\tbox.setBounds(50, 80, 100, 50);\n\t\t\tadd(box);\n\t\t}\n\t}\n}");
    }

    @Ignore
    @Test
    public void test_canvas_ADD() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tinner.setLayout(null);\n\t\t\tadd(inner);\n\t\t\tinner.setBounds(20, 100, 200, 150);\n\t\t\t{\n\t\t\t\tBox box = new Box();\n\t\t\t\tbox.setBounds(10, 20, 100, 50);\n\t\t\t\tinner.add(box);\n\t\t\t}\n\t\t}\n\t}\n}");
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo box = (ComponentInfo)inner.getChildrenComponents().get(0);
        this.canvas.sideMode().beginMove(box);
        this.canvas.target(panel).in(50, 25).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tinner.setLayout(null);\n\t\t\tadd(inner);\n\t\t\tinner.setBounds(20, 100, 200, 150);\n\t\t}\n\t\t{\n\t\t\tBox box = new Box();\n\t\t\tbox.setBounds(50, 25, 100, 50);\n\t\t\tadd(box);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_tree_CREATE() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t}\n}");
        ComponentInfo newBox = this.loadCreationBox();
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tBox box = new Box();\n\t\t\tbox.setBounds(0, 0, 100, 50);\n\t\t\tadd(box);\n\t\t}\n\t}\n}");
        this.tree.assertPrimarySelected(newBox);
    }

    @Ignore
    @Test
    public void test_tree_PASTE() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tBox boxA = new Box();\n\t\t\tboxA.setBounds(10, 20, 100, 50);\n\t\t\tadd(boxA);\n\t\t}\n\t}\n}");
        ComponentInfo boxA = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.select(boxA);
        IAction copyAction = this.getCopyAction();
        AbsoluteLayoutGefTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        AbsoluteLayoutGefTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tBox boxA = new Box();\n\t\t\tboxA.setBounds(10, 20, 100, 50);\n\t\t\tadd(boxA);\n\t\t}\n\t\t{\n\t\t\tBox box = new Box();\n\t\t\tbox.setBounds(0, 0, 100, 50);\n\t\t\tadd(box);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_tree_MOVE() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tBox boxA = new Box();\n\t\t\tboxA.setBounds(10, 20, 100, 50);\n\t\t\tadd(boxA);\n\t\t}\n\t\t{\n\t\t\tBox boxB = new Box();\n\t\t\tboxB.setBounds(20, 100, 100, 50);\n\t\t\tadd(boxB);\n\t\t}\n\t}\n}");
        ComponentInfo boxA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo boxB = (ComponentInfo)panel.getChildrenComponents().get(1);
        this.tree.startDrag(boxB);
        this.tree.dragBefore(boxA);
        this.tree.assertFeedback_before(boxA);
        this.tree.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tBox boxB = new Box();\n\t\t\tboxB.setBounds(20, 100, 100, 50);\n\t\t\tadd(boxB);\n\t\t}\n\t\t{\n\t\t\tBox boxA = new Box();\n\t\t\tboxA.setBounds(10, 20, 100, 50);\n\t\t\tadd(boxA);\n\t\t}\n\t}\n}");
        this.tree.assertPrimarySelected(boxB);
    }

    @Test
    public void test_tree_ADD() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tinner.setLayout(null);\n\t\t\tadd(inner);\n\t\t\tinner.setBounds(20, 100, 200, 150);\n\t\t\t{\n\t\t\t\tBox box = new Box();\n\t\t\t\tbox.setBounds(10, 20, 100, 50);\n\t\t\t\tinner.add(box);\n\t\t\t}\n\t\t}\n\t}\n}");
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo box = (ComponentInfo)inner.getChildrenComponents().get(0);
        this.tree.startDrag(box);
        this.tree.dragOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tinner.setLayout(null);\n\t\t\tadd(inner);\n\t\t\tinner.setBounds(20, 100, 200, 150);\n\t\t}\n\t\t{\n\t\t\tBox box = new Box();\n\t\t\tbox.setBounds(0, 0, 100, 50);\n\t\t\tadd(box);\n\t\t}\n\t}\n}");
    }
}

