/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.ams;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Ignore;
import org.junit.Test;

public class PropertyTweaksTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Ignore
    @Test
    public void test_Groups_fromBundle() throws Exception {
        this.prepareParse_MyButton();
        PropertyTweaksTest.assertEquals((long)2L, (long)this.m_propertyTable.forTests_getPropertiesCount());
        Property propertyAMS = this.m_propertyTable.forTests_getProperty(0);
        PropertyTweaksTest.assertEquals((Object)"AMS", (Object)propertyAMS.getTitle());
        Property[] subProperties = PropertyTweaksTest.getSubProperties(propertyAMS);
        PropertyTweaksTest.assertNotNull((Object)PropertyUtils.getByTitle((Property[])subProperties, (String)"buttonColor"));
        Property propertyOther = this.m_propertyTable.forTests_getProperty(1);
        PropertyTweaksTest.assertEquals((Object)"Other", (Object)propertyOther.getTitle());
        subProperties = PropertyTweaksTest.getSubProperties(propertyOther);
        PropertyTweaksTest.assertNotNull((Object)PropertyUtils.getByTitle((Property[])subProperties, (String)"text"));
    }

    @DisposeProjectAfter
    @Ignore
    @Test
    public void test_Groups_fromJar() throws Exception {
        String jarPath = TestUtils.createTemporaryJar("wbp-meta/AMS.property-tweaks.xml", PropertyTweaksTest.getSource("<groups>", "  <group name='ALL'>", "    <other-properties/>", "  </group>", "</groups>"));
        ProjectUtils.addExternalJar((IJavaProject)m_javaProject, (String)jarPath, null);
        this.prepareParse_MyButton();
        PropertyTweaksTest.assertEquals((long)1L, (long)this.m_propertyTable.forTests_getPropertiesCount());
        Property propertyALL = this.m_propertyTable.forTests_getProperty(0);
        PropertyTweaksTest.assertEquals((Object)"ALL", (Object)propertyALL.getTitle());
        Property[] subProperties = PropertyTweaksTest.getSubProperties(propertyALL);
        PropertyTweaksTest.assertNotNull((Object)PropertyUtils.getByTitle((Property[])subProperties, (String)"buttonColor"));
    }

    @Ignore
    @Test
    public void test_categories() throws Exception {
        this.prepareParse_MyButton();
        this.m_propertyTable.forTests_expand(1);
        PropertyTweaksTest.assertFalse((boolean)this.hasPropertyWithTitle("Variable"));
        this.m_propertyTable.setShowAdvancedProperties(true);
        PropertyTweaksTest.assertTrue((boolean)this.hasPropertyWithTitle("Variable"));
    }

    private boolean hasPropertyWithTitle(String title) {
        int count = this.m_propertyTable.forTests_getPropertiesCount();
        int i = 0;
        while (i < count) {
            Property property = this.m_propertyTable.forTests_getProperty(i);
            if (property.getTitle().equals(title)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ComponentInfo prepareParse_MyButton() throws Exception {
        this.prepare_MyButton();
        ComponentInfo button = this.parse_MyButton();
        this.canvas.select(button);
        return button;
    }

    private void prepare_MyButton() throws Exception {
        PropertyTweaksTest.setFileContentSrc("ams/zpointcs/MyButton.java", PropertyTweaksTest.getSource("package ams.zpointcs;", "import java.awt.*;", "import javax.swing.*;", "public class MyButton extends JButton {", "  public void setButtonColor(Color color) {", "  }", "}"));
        PropertyTweaksTest.waitForAutoBuild();
    }

    private ComponentInfo parse_MyButton() throws Exception {
        ContainerInfo panel = this.openContainer("import ams.zpointcs.MyButton;\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tadd(button);\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        return button;
    }
}

