/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.model.widgets.AbstractTabItemInfo;
import org.eclipse.wb.internal.rcp.model.widgets.TabFolderInfo;
import org.eclipse.wb.internal.rcp.model.widgets.TabItemInfo;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class TabFolderTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_unselectedTab_setRedraw() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item_1 = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button_1 = new Button(tabFolder, SWT.NONE);", "        item_1.setControl(button_1);", "      }", "    }", "    {", "      TabItem item_2 = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button_2 = new Button(tabFolder, SWT.NONE);", "        item_2.setControl(button_2);", "      }", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item_2 = (TabItemInfo)tabFolder.getItems2().get(1);
        ControlInfo button_2 = item_2.getControl();
        TabFolderTest.assertNotSame((Object)item_2, (Object)tabFolder.getSelectedItem());
        TabFolderTest.assertTrue((boolean)button_2.getBounds().isEmpty());
        TabFolderTest.assertEquals((long)0L, (long)ReflectionUtils.getFieldInt((Object)button_2.getObject(), (String)"drawCount"));
    }

    @Test
    public void test_getSelectedItem_0() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabFolderTest.assertNull((Object)tabFolder.getSelectedItem());
        Assertions.assertThat((List)tabFolder.getPresentation().getChildrenTree()).isEmpty();
        Assertions.assertThat((List)tabFolder.getPresentation().getChildrenGraphical()).isEmpty();
    }

    @Test
    public void test_getSelectedItem_1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    TabItem item_1 = new TabItem(tabFolder, SWT.NONE);", "    TabItem item_2 = new TabItem(tabFolder, SWT.NONE);", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item_1 = (TabItemInfo)tabFolder.getItems2().get(0);
        TabItemInfo item_2 = (TabItemInfo)tabFolder.getItems2().get(1);
        TabFolderTest.assertSame((Object)item_1, (Object)tabFolder.getSelectedItem());
        item_2.doSelect();
        TabFolderTest.assertSame((Object)item_2, (Object)tabFolder.getSelectedItem());
        Assertions.assertThat((Object[])tabFolder.getWidget().getSelection()).containsOnly(new Object[]{item_2.getObject()});
        List children = tabFolder.getPresentation().getChildrenTree();
        Assertions.assertThat((List)children).containsExactly((Object[])new ObjectInfo[]{item_1, item_2});
        children = tabFolder.getPresentation().getChildrenGraphical();
        Assertions.assertThat((List)children).containsExactly((Object[])new ObjectInfo[]{item_1, item_2});
    }

    @Test
    public void test_doSelect() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    TabItem item_1 = new TabItem(tabFolder, SWT.NONE);", "    TabItem item_2 = new TabItem(tabFolder, SWT.NONE);", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item_1 = (TabItemInfo)tabFolder.getItems2().get(0);
        TabItemInfo item_2 = (TabItemInfo)tabFolder.getItems2().get(1);
        TabFolderTest.assertSame((Object)item_1, (Object)tabFolder.getSelectedItem());
        final AtomicInteger refreshCount = new AtomicInteger();
        shell.addBroadcastListener((Object)new ObjectEventListener(){

            public void refreshed() throws Exception {
                refreshCount.incrementAndGet();
            }
        });
        item_2.doSelect();
        TabFolderTest.assertSame((Object)item_2, (Object)tabFolder.getSelectedItem());
        TabFolderTest.assertEquals((long)1L, (long)refreshCount.get());
        item_2.doSelect();
        TabFolderTest.assertEquals((long)1L, (long)refreshCount.get());
    }

    @Test
    public void test_selecting() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item_1 = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button_1 = new Button(tabFolder, SWT.NONE);", "        item_1.setControl(button_1);", "      }", "    }", "    {", "      TabItem item_2 = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button_2 = new Button(tabFolder, SWT.NONE);", "        item_2.setControl(button_2);", "      }", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item_1 = (TabItemInfo)tabFolder.getItems2().get(0);
        TabItemInfo item_2 = (TabItemInfo)tabFolder.getItems2().get(1);
        ControlInfo button_1 = item_1.getControl();
        ControlInfo button_2 = item_2.getControl();
        ControlInfo button_3 = (ControlInfo)shell.getChildrenControls().get(1);
        boolean[] refresh = new boolean[1];
        shell.getBroadcastObject().selecting((ObjectInfo)button_3, refresh);
        TabFolderTest.assertFalse((boolean)refresh[0]);
        refresh = new boolean[1];
        shell.getBroadcastObject().selecting((ObjectInfo)button_2, refresh);
        TabFolderTest.assertTrue((boolean)refresh[0]);
        TabFolderTest.assertSame((Object)tabFolder.getSelectedItem(), (Object)item_2);
        refresh = new boolean[1];
        shell.getBroadcastObject().selecting((ObjectInfo)button_2, refresh);
        TabFolderTest.assertFalse((boolean)refresh[0]);
        TabFolderTest.assertSame((Object)tabFolder.getSelectedItem(), (Object)item_2);
        refresh = new boolean[1];
        shell.getBroadcastObject().selecting((ObjectInfo)button_1, refresh);
        TabFolderTest.assertTrue((boolean)refresh[0]);
        TabFolderTest.assertSame((Object)tabFolder.getSelectedItem(), (Object)item_1);
    }

    @Test
    public void test_deleteSelectedTabItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    TabItem item_1 = new TabItem(tabFolder, SWT.NONE);", "    TabItem item_2 = new TabItem(tabFolder, SWT.NONE);", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item_1 = (TabItemInfo)tabFolder.getItems2().get(0);
        TabItemInfo item_2 = (TabItemInfo)tabFolder.getItems2().get(1);
        item_2.doSelect();
        TabFolderTest.assertEquals((Object)tabFolder.getSelectedItem(), (Object)item_2);
        item_2.delete();
        TabFolderTest.assertEquals((Object)tabFolder.getSelectedItem(), (Object)item_1);
    }

    @Test
    public void test_presentation_getChildren() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item_1 = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button_1 = new Button(tabFolder, SWT.NONE);", "        item_1.setControl(button_1);", "      }", "    }", "    {", "      TabItem item_2 = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button_2 = new Button(tabFolder, SWT.NONE);", "        item_2.setControl(button_2);", "      }", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item_1 = (TabItemInfo)tabFolder.getItems2().get(0);
        TabItemInfo item_2 = (TabItemInfo)tabFolder.getItems2().get(1);
        ControlInfo button_1 = item_1.getControl();
        ControlInfo button_2 = item_2.getControl();
        TabFolderTest.assertSame((Object)item_1, (Object)tabFolder.getSelectedItem());
        List childrenGraphical = tabFolder.getPresentation().getChildrenGraphical();
        Assertions.assertThat((List)childrenGraphical).containsOnly((Object[])new ObjectInfo[]{item_1, item_2, button_1});
        item_2.doSelect();
        TabFolderTest.assertSame((Object)item_2, (Object)tabFolder.getSelectedItem());
        Assertions.assertThat((Object[])tabFolder.getWidget().getSelection()).containsOnly(new Object[]{item_2.getObject()});
        childrenGraphical = tabFolder.getPresentation().getChildrenGraphical();
        Assertions.assertThat((List)childrenGraphical).containsOnly((Object[])new ObjectInfo[]{item_1, item_2, button_2});
    }

    @Test
    public void test_parseItems() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 350);", "    setLayout(new FillLayout());", "    {", "      TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem item = new TabItem(tabFolder, SWT.NONE);", "        item.setText('000');", "      }", "      {", "        TabItem item = new TabItem(tabFolder, SWT.NONE);", "        item.setText('111');", "      }", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        List items = tabFolder.getItems2();
        TabFolderTest.assertEquals((long)2L, (long)items.size());
        TabItemInfo item_0 = (TabItemInfo)items.get(0);
        TabItemInfo item_1 = (TabItemInfo)items.get(1);
        TabFolderTest.assertEquals((Object)"000", (Object)item_0.getWidget().getText());
        TabFolderTest.assertEquals((Object)"111", (Object)item_1.getWidget().getText());
        Rectangle modelBounds_0 = item_0.getModelBounds();
        Assertions.assertThat((int)modelBounds_0.width).isGreaterThan(20);
        Assertions.assertThat((int)modelBounds_0.height).isGreaterThan(17);
        Rectangle modelBounds_1 = item_1.getModelBounds();
        Assertions.assertThat((int)modelBounds_1.width).isGreaterThan(20);
        Assertions.assertThat((int)modelBounds_1.height).isGreaterThan(17);
        TabFolderTest.assertNull((Object)item_0.getControl());
        Assertions.assertThat((List)item_0.getPresentation().getChildrenTree()).isEmpty();
    }

    @Test
    public void test_setControl_get() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(500, 350);", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item = (TabItemInfo)tabFolder.getItems2().get(0);
        ControlInfo button = (ControlInfo)tabFolder.getChildrenControls().get(0);
        TabFolderTest.assertSame((Object)button, (Object)item.getControl());
        Assertions.assertThat((int)button.getBounds().width).isGreaterThan(400);
        Assertions.assertThat((int)button.getBounds().height).isGreaterThan(250);
        Assertions.assertThat((List)item.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{button});
        Assertions.assertThat((List)tabFolder.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{item});
    }

    @Test
    public void test_CREATE_control_onItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item = new TabItem(tabFolder, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item = (TabItemInfo)tabFolder.getItems2().get(0);
        TabFolderTest.assertNull((Object)item.getControl());
        ControlInfo button = BTestUtils.createButton();
        item.command_CREATE(button);
        TabFolderTest.assertSame((Object)button, (Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_control_onFolder() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)TabFolderTest.getJavaInfoByName("tabFolder");
        ControlInfo button = BTestUtils.createButton();
        tabFolder.command_CREATE(button, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem tabItem = new TabItem(tabFolder, SWT.NONE);", "      tabItem.setText('New Item');", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        tabItem.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_control_onItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item = new TabItem(tabFolder, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item = (TabItemInfo)tabFolder.getItems2().get(0);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        TabFolderTest.assertNull((Object)item.getControl());
        item.command_ADD(button);
        TabFolderTest.assertSame((Object)button, (Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_control_onFolder() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)TabFolderTest.getJavaInfoByName("tabFolder");
        ControlInfo button = (ControlInfo)TabFolderTest.getJavaInfoByName("button");
        tabFolder.command_MOVE(button, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem tabItem = new TabItem(tabFolder, SWT.NONE);", "      tabItem.setText('New Item');", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        tabItem.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_control_toOtherItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item_1 = new TabItem(tabFolder, SWT.NONE);", "    }", "    {", "      TabItem item_2 = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item_2.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item_1 = (TabItemInfo)tabFolder.getItems2().get(0);
        TabItemInfo item_2 = (TabItemInfo)tabFolder.getItems2().get(1);
        ControlInfo button = item_2.getControl();
        TabFolderTest.assertEquals((long)(tabFolder.getChildrenJava().indexOf(item_2) + 1), (long)tabFolder.getChildrenJava().indexOf(button));
        item_1.command_ADD(button);
        TabFolderTest.assertNull((Object)item_2.getControl());
        TabFolderTest.assertSame((Object)button, (Object)item_1.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item_1 = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item_1.setControl(button);", "      }", "    }", "    {", "      TabItem item_2 = new TabItem(tabFolder, SWT.NONE);", "    }", "  }", "}");
        TabFolderTest.assertEquals((long)(tabFolder.getChildrenJava().indexOf(item_1) + 1), (long)tabFolder.getChildrenJava().indexOf(button));
    }

    @Test
    public void test_setControl_DELETE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item = (TabItemInfo)tabFolder.getItems2().get(0);
        item.delete();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_setControl_moveOut() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item = (TabItemInfo)tabFolder.getItems2().get(0);
        ControlInfo button = item.getControl();
        fillLayout.command_MOVE(button, null);
        TabFolderTest.assertNull((Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item = new TabItem(tabFolder, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_item() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo TabItem2 = (TabItemInfo)TabFolderTest.createJavaInfo("org.eclipse.swt.widgets.TabItem");
        tabFolder.command_CREATE((AbstractTabItemInfo)TabItem2, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem tabItem = new TabItem(tabFolder, SWT.NONE);", "        tabItem.setText('New Item');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_item_empty() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem item = new TabItem(tabFolder, SWT.NONE);", "        item.setText('000');", "      }", "      {", "        TabItem item = new TabItem(tabFolder, SWT.NONE);", "        item.setText('111');", "      }", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        List items = tabFolder.getItems2();
        tabFolder.command_MOVE((AbstractTabItemInfo)items.get(1), (AbstractTabItemInfo)items.get(0));
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem item = new TabItem(tabFolder, SWT.NONE);", "        item.setText('111');", "      }", "      {", "        TabItem item = new TabItem(tabFolder, SWT.NONE);", "        item.setText('000');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_item_withControl() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item_1 = new TabItem(tabFolder, SWT.NONE);", "    }", "    {", "      TabItem item_2 = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item_2.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        TabFolderInfo tabFolder = (TabFolderInfo)shell.getChildrenControls().get(0);
        TabItemInfo item_1 = (TabItemInfo)tabFolder.getItems2().get(0);
        TabItemInfo item_2 = (TabItemInfo)tabFolder.getItems2().get(1);
        ControlInfo button = item_2.getControl();
        TabFolderTest.assertEquals((long)(tabFolder.getChildrenJava().indexOf(item_2) + 1), (long)tabFolder.getChildrenJava().indexOf(button));
        tabFolder.command_MOVE((AbstractTabItemInfo)item_2, (AbstractTabItemInfo)item_1);
        TabFolderTest.assertSame((Object)button, (Object)item_2.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "    {", "      TabItem item_2 = new TabItem(tabFolder, SWT.NONE);", "      {", "        Button button = new Button(tabFolder, SWT.NONE);", "        item_2.setControl(button);", "      }", "    }", "    {", "      TabItem item_1 = new TabItem(tabFolder, SWT.NONE);", "    }", "  }", "}");
        TabFolderTest.assertEquals((long)(tabFolder.getChildrenJava().indexOf(item_2) + 1), (long)tabFolder.getChildrenJava().indexOf(button));
    }
}

