/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.xml;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.internal.core.utils.xml.parser.QAttribute;
import org.eclipse.wb.internal.core.utils.xml.parser.QException;
import org.eclipse.wb.internal.core.utils.xml.parser.QHandler;
import org.eclipse.wb.internal.core.utils.xml.parser.QHandlerAdapter;
import org.eclipse.wb.internal.core.utils.xml.parser.QParser;
import org.eclipse.wb.tests.designer.core.AbstractJavaProjectTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class QParserTest
extends AbstractJavaProjectTest {
    private QHandlerAdapter handler;
    private final StringBuilder events = new StringBuilder();

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            QParserTest.do_projectCreate();
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.handler = null;
        super.tearDown();
    }

    private void parse(String ... lines) throws Exception {
        String source = QParserTest.getSourceDQ(lines);
        this.parseSource(source);
    }

    private void parseSource(String source) throws Exception {
        if (this.handler == null) {
            this.rememberEventsDuringParsing();
        }
        StringReader reader = new StringReader(source);
        QParser.parse((Reader)reader, (QHandler)this.handler);
    }

    private void rememberEventsDuringParsing() {
        this.events.append("----------------------- filler -----------------------\n");
        this.handler = new QHandlerAdapter(){
            private int m_level;

            public void startDocument() throws Exception {
                this.addLine("startDocument");
                ++this.m_level;
            }

            public void endDocument() throws Exception {
                --this.m_level;
                this.addLine("endDocument");
            }

            public void startElement(int offset, int length, String tag, Map<String, String> attributes, List<QAttribute> attrList, boolean closed) throws Exception {
                this.addLine("<" + tag + " offset:" + offset + " length:" + length + (closed ? " closed" : ""));
                ++this.m_level;
                for (QAttribute attribute : attrList) {
                    this.addLine("A " + attribute.getName() + " |" + attribute.getValue() + "| nameOffset:" + attribute.getNameOffset() + " nameLength:" + attribute.getNameLength() + " valueOffset:" + attribute.getValueOffset() + " valueLength:" + attribute.getValueLength());
                }
            }

            public void endElement(int offset, int endOffset, String tag) throws Exception {
                --this.m_level;
                this.addLine(MessageFormat.format(">{0} offset:{1} endOffset:{2}", tag, offset, endOffset));
            }

            public void text(String text, boolean isCDATA) throws Exception {
                this.addLine("T " + isCDATA + " " + text);
            }

            private void addLine(String line) {
                QParserTest.this.events.append(StringUtils.repeat((String)"\t", (int)this.m_level));
                QParserTest.this.events.append(line);
                QParserTest.this.events.append("\n");
            }
        };
    }

    private void assertParseEvents(String ... lines) {
        QParserTest.assertEquals((Object)QParserTest.getSource(lines), (Object)this.events.toString());
    }

    @Test
    public void test_badEmpty() throws Exception {
        try {
            this.parseSource("");
        }
        catch (QException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"missing end tag"});
        }
    }

    @Test
    public void test_badEmpty_line1() throws Exception {
        try {
            this.parseSource("");
        }
        catch (QException e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"line 1"})).contains(new CharSequence[]{"column 0"});
        }
    }

    @Test
    public void test_badEmpty_line2_slashN() throws Exception {
        try {
            this.parseSource("\n");
        }
        catch (QException e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"line 2"})).contains(new CharSequence[]{"column 0"});
        }
    }

    @Test
    public void test_badEmpty_line2_slashR() throws Exception {
        try {
            this.parseSource("\r");
        }
        catch (QException e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"line 2"})).contains(new CharSequence[]{"column 0"});
        }
    }

    @Test
    public void test_badEmpty_line2_slashR_slashN() throws Exception {
        try {
            this.parseSource("\r\n");
        }
        catch (QException e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"line 2"})).contains(new CharSequence[]{"column 0"});
        }
    }

    @Test
    public void test_badEmpty_line3_slashR_space_slashN() throws Exception {
        try {
            this.parseSource("\r \n");
        }
        catch (QException e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"line 3"})).contains(new CharSequence[]{"column 0"});
        }
    }

    @Test
    public void test_badEmpty_line1_column3() throws Exception {
        try {
            this.parseSource("123");
        }
        catch (QException e) {
            ((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"line 1"})).contains(new CharSequence[]{"column 3"});
        }
    }

    @Test
    public void test_bad_noCloseAngleBrace_afterSlash() throws Exception {
        try {
            this.parseSource("<root/foo");
        }
        catch (QException e) {
            QParserTest.assertEquals((Object)e.getMessage(), (Object)"Expected > for tag: <root/> near line 1, column 7");
        }
    }

    @Test
    public void test_withComment() throws Exception {
        this.parseSource("<root><!-- abc --></root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "  >root offset:18 endOffset:25", "endDocument");
    }

    @Test
    public void test_withXMLVersion() throws Exception {
        String prefix = "<?xml version='1.0' encoding='UTF-8'?>";
        int prefixLength = prefix.length() + "\n".length();
        this.parseSource(QParserTest.getSourceDQ(prefix, "<root/>"));
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:" + (0 + prefixLength) + " length:-1 closed", "  >root offset:-1 endOffset:" + (7 + prefixLength), "endDocument");
    }

    @Test
    public void test_withDocType() throws Exception {
        String prefix = "<!DOCTYPE strict>";
        int prefixLength = prefix.length() + "\n".length();
        this.parse(prefix, "<root/>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:" + (0 + prefixLength) + " length:-1 closed", "  >root offset:-1 endOffset:" + (7 + prefixLength), "endDocument");
    }

    @Test
    public void test_rootElement_closed() throws Exception {
        this.parseSource("<root/>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:-1 closed", "  >root offset:-1 endOffset:7", "endDocument");
    }

    @Test
    public void test_rootElement_ignoreAllAfterCloseRoot() throws Exception {
        this.parseSource("<root></root>ignored");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "  >root offset:6 endOffset:13", "endDocument");
    }

    @Test
    public void test_rootElement_open() throws Exception {
        this.parseSource("<root></root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "  >root offset:6 endOffset:13", "endDocument");
    }

    @Test
    public void test_withSubTag() throws Exception {
        this.parseSource("<root><inner/></root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "    <inner offset:6 length:-1 closed", "    >inner offset:-1 endOffset:14", "  >root offset:14 endOffset:21", "endDocument");
    }

    @Test
    public void test_useAdapter() throws Exception {
        this.handler = new QHandlerAdapter(){};
        this.parseSource("<root>txt</root>");
    }

    @Test
    public void test_attribute() throws Exception {
        this.parseSource("<root foo='baar'/>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:-1 closed", "    A foo |baar| nameOffset:6 nameLength:3 valueOffset:11 valueLength:4", "  >root offset:-1 endOffset:18", "endDocument");
    }

    @Test
    public void test_attribute_inOpen() throws Exception {
        this.parseSource("<root foo='baar'></root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:17", "    A foo |baar| nameOffset:6 nameLength:3 valueOffset:11 valueLength:4", "  >root offset:17 endOffset:24", "endDocument");
    }

    @Test
    public void test_attribute_whitespaceBeforeEquals() throws Exception {
        this.parseSource("<root foo ='baar'/>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:-1 closed", "    A foo |baar| nameOffset:6 nameLength:3 valueOffset:12 valueLength:4", "  >root offset:-1 endOffset:19", "endDocument");
    }

    @Test
    public void test_attribute_whitespaceBeforeEquals2() throws Exception {
        this.parseSource("<root foo  ='baar'/>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:-1 closed", "    A foo |baar| nameOffset:6 nameLength:3 valueOffset:13 valueLength:4", "  >root offset:-1 endOffset:20", "endDocument");
    }

    @Test
    public void test_attribute_whitespaceAfterEquals() throws Exception {
        this.parseSource("<root foo= 'baar'/>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:-1 closed", "    A foo |baar| nameOffset:6 nameLength:3 valueOffset:12 valueLength:4", "  >root offset:-1 endOffset:19", "endDocument");
    }

    @Test
    public void test_attribute_invalidBeforeEquals() throws Exception {
        try {
            this.parseSource("<root foo invalid=/>");
        }
        catch (QException e) {
            QParserTest.assertEquals((Object)e.getMessage(), (Object)"Error in attribute processing near line 1, column 11");
        }
    }

    @Test
    public void test_attribute_invalidAfterEquals() throws Exception {
        try {
            this.parseSource("<root foo=invalid/>");
        }
        catch (QException e) {
            QParserTest.assertEquals((Object)e.getMessage(), (Object)"Error in attribute processing near line 1, column 11");
        }
    }

    @Test
    public void test_attribute_normalizeWhitespaces() throws Exception {
        this.parseSource("<root foo='a\n\r\t b'/>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:-1 closed", "    A foo |a    b| nameOffset:6 nameLength:3 valueOffset:11 valueLength:6", "  >root offset:-1 endOffset:20", "endDocument");
    }

    @Test
    public void test_attribute_entity() throws Exception {
        this.parseSource("<root foo='&#65;&#66;'/>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:-1 closed", "    A foo |AB| nameOffset:6 nameLength:3 valueOffset:11 valueLength:10", "  >root offset:-1 endOffset:24", "endDocument");
    }

    @Test
    public void test_text_simple() throws Exception {
        this.parseSource("<root>abc</root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "    T false abc", "  >root offset:9 endOffset:16", "endDocument");
    }

    @Test
    public void test_text_CDATA() throws Exception {
        this.parseSource("<root><![CDATA[abc]]></root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "    T true abc", "  >root offset:21 endOffset:28", "endDocument");
    }

    @Test
    public void test_text_slashR_slashN() throws Exception {
        this.parseSource("<root>\r\n123\r\n</root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "    T false \r\n123\r\n", "  >root offset:13 endOffset:20", "endDocument");
    }

    @Test
    public void test_textSpecial_lt() throws Exception {
        this.parseSource("<root>&lt;</root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "    T false <", "  >root offset:10 endOffset:17", "endDocument");
    }

    @Test
    public void test_textSpecial_gt() throws Exception {
        this.parseSource("<root>&gt;</root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "    T false >", "  >root offset:10 endOffset:17", "endDocument");
    }

    @Test
    public void test_textSpecial_amp() throws Exception {
        this.parseSource("<root>&amp;</root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "    T false &", "  >root offset:11 endOffset:18", "endDocument");
    }

    @Test
    public void test_textSpecial_quot() throws Exception {
        this.parseSource("<root>&quot;</root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "    T false \"", "  >root offset:12 endOffset:19", "endDocument");
    }

    @Test
    public void test_textSpecial_apos() throws Exception {
        this.parseSource("<root>&apos;</root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "    T false '", "  >root offset:12 endOffset:19", "endDocument");
    }

    @Test
    public void test_textSpecial_hexNumber() throws Exception {
        this.parseSource("<root>&#x41;</root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "    T false A", "  >root offset:12 endOffset:19", "endDocument");
    }

    @Test
    public void test_textSpecial_decNumber() throws Exception {
        this.parseSource("<root>&#65;</root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "    T false A", "  >root offset:11 endOffset:18", "endDocument");
    }

    @Test
    public void test_textSpecial_unknownEntity() throws Exception {
        this.parseSource("<root>&unknown;</root>");
        this.assertParseEvents("----------------------- filler -----------------------", "startDocument", "  <root offset:0 length:6", "    T false &unknown;", "  >root offset:15 endOffset:22", "endDocument");
    }
}

