/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.editor.palette.model.entry.ToolEntryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.tools.SelectionTool;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.tests.designer.core.palette.AbstractPaletteTest;
import org.eclipse.wb.tests.gef.EmptyEditPartViewer;
import org.junit.Test;

public class ToolEntryInfoTest
extends AbstractPaletteTest {
    @Test
    public void test_activateNoTool() throws Exception {
        JavaInfo panel = this.parseEmptyPanel();
        EmptyEditPartViewer editPartViewer = new EmptyEditPartViewer();
        ToolEntryInfo toolEntry = new ToolEntryInfo(){

            public ImageDescriptor getIcon() {
                return null;
            }

            public Tool createTool() throws Exception {
                return null;
            }
        };
        ToolEntryInfoTest.assertTrue((boolean)toolEntry.initialize((IEditPartViewer)editPartViewer, panel));
        ToolEntryInfoTest.assertFalse((boolean)toolEntry.activate(false));
    }

    @Test
    public void test_activateTool() throws Exception {
        JavaInfo panel = this.parseEmptyPanel();
        EmptyEditPartViewer editPartViewer = new EmptyEditPartViewer();
        ToolEntryInfo toolEntry = new ToolEntryInfo(){

            public ImageDescriptor getIcon() {
                return null;
            }

            public Tool createTool() throws Exception {
                return new SelectionTool();
            }
        };
        ToolEntryInfoTest.assertTrue((boolean)toolEntry.initialize((IEditPartViewer)editPartViewer, panel));
        ToolEntryInfoTest.assertTrue((boolean)toolEntry.activate(false));
    }

    @Test
    public void test_activateException() throws Exception {
        JavaInfo panel = this.parseEmptyPanel();
        EmptyEditPartViewer editPartViewer = new EmptyEditPartViewer();
        ToolEntryInfo toolEntry = new ToolEntryInfo(){

            public ImageDescriptor getIcon() {
                return null;
            }

            public Tool createTool() throws Exception {
                throw new Exception();
            }
        };
        ToolEntryInfoTest.assertTrue((boolean)toolEntry.initialize((IEditPartViewer)editPartViewer, panel));
        try {
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)false);
            ToolEntryInfoTest.assertFalse((boolean)toolEntry.activate(false));
        }
        finally {
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
        }
    }
}

