/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescriptionJava;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.model.variable.description.FieldUniqueVariableDescription;
import org.eclipse.wb.internal.core.model.variable.description.LocalUniqueVariableDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.junit.Test;

public class NamesManagerTest
extends AbstractVariableTest {
    private static final ToolkitDescriptionJava TOOLKIT = ToolkitProvider.DESCRIPTION;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getDefaultVariableName() throws Exception {
        NamesManagerTest.assertEquals((Object)"button", (Object)NamesManagerTest.invoke_getDefaultName("a.b.Button"));
        NamesManagerTest.assertEquals((Object)"button", (Object)NamesManagerTest.invoke_getDefaultName("a.b.JButton"));
        NamesManagerTest.assertEquals((Object)"bUtton_", (Object)NamesManagerTest.invoke_getDefaultName("a.b.bUtton"));
        NamesManagerTest.assertEquals((Object)"button", (Object)NamesManagerTest.invoke_getDefaultName("a.b.BUTTON"));
    }

    private static String invoke_getDefaultName(String qualifiedClassName) throws Exception {
        return (String)ReflectionUtils.invokeMethod2(NamesManager.class, (String)"getDefaultName", String.class, (Object)qualifiedClassName);
    }

    @Test
    public void test_getDefaultAcronym() throws Exception {
        NamesManagerTest.assertEquals((Object)"btn", (Object)NamesManagerTest.invoke_getDefaultAcronym("org.eclipse.swt.widgets.Button"));
        NamesManagerTest.assertEquals((Object)"btn", (Object)NamesManagerTest.invoke_getDefaultAcronym("javax.swing.JButton"));
        NamesManagerTest.assertEquals((Object)"stldtxt", (Object)NamesManagerTest.invoke_getDefaultAcronym("org.eclipse.swt.custom.StyledText"));
        NamesManagerTest.assertEquals((Object)"IAo", (Object)NamesManagerTest.invoke_getDefaultAcronym("com.mycompany.IAo"));
    }

    private static String invoke_getDefaultAcronym(String qualifiedClassName) throws Exception {
        return (String)ReflectionUtils.invokeMethod2(NamesManager.class, (String)"getDefaultAcronym", String.class, (Object)qualifiedClassName);
    }

    @Test
    public void test_getNameAcronym_default() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        NamesManagerTest.assertEquals((Object)"panel", (Object)NamesManager.getName((JavaInfo)panel));
        NamesManagerTest.assertEquals((Object)"pnl", (Object)NamesManager.getAcronym((JavaInfo)panel));
    }

    @Test
    public void test_getNameAcronym_explicit() throws Exception {
        NamesManagerTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyPanel extends JPanel {", "}"));
        NamesManagerTest.setFileContent("wbp-meta/test/MyPanel.wbp-component.xml", NamesManagerTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='variable.name'>pName</parameter>", "    <parameter name='variable.acronym'>pAcr</parameter>", "  </parameters>", "</component>"));
        NamesManagerTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        NamesManagerTest.assertEquals((Object)"pName", (Object)NamesManager.getName((JavaInfo)panel));
        NamesManagerTest.assertEquals((Object)"pAcr", (Object)NamesManager.getAcronym((JavaInfo)panel));
    }

    @Test
    public void test_getNameAcronym_resetExplicit() throws Exception {
        NamesManagerTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyPanel extends JPanel {", "}"));
        NamesManagerTest.setFileContent("wbp-meta/test/MyPanel.wbp-component.xml", NamesManagerTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='variable.name'>pName</parameter>", "    <parameter name='variable.acronym'>pAcr</parameter>", "  </parameters>", "</component>"));
        NamesManagerTest.setFileContentSrc("test/MyPanel2.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyPanel2 extends MyPanel {", "}"));
        NamesManagerTest.setFileContent("wbp-meta/test/MyPanel2.wbp-component.xml", NamesManagerTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='variable.name'></parameter>", "    <parameter name='variable.acronym'></parameter>", "  </parameters>", "</component>"));
        NamesManagerTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel2 {", "  public Test() {", "  }", "}");
        NamesManagerTest.assertEquals((Object)"myPanel2", (Object)NamesManager.getName((JavaInfo)panel));
        NamesManagerTest.assertEquals((Object)"mpnl2", (Object)NamesManager.getAcronym((JavaInfo)panel));
    }

    @Test
    public void test_getNameDescriptions_setNameDescriptions() throws Exception {
        List descriptions = new ArrayList<NamesManager.ComponentNameDescription>();
        descriptions.add(new NamesManager.ComponentNameDescription("javax.swing.JButton", "button", "btn"));
        descriptions.add(new NamesManager.ComponentNameDescription("javax.swing.JComboBox", "combo", "cmb"));
        NamesManager.setNameDescriptions((ToolkitDescription)TOOLKIT, descriptions);
        descriptions = NamesManager.getNameDescriptions((ToolkitDescription)TOOLKIT, (boolean)false);
        NamesManagerTest.assertEquals((long)2L, (long)descriptions.size());
        NamesManager.ComponentNameDescription description = (NamesManager.ComponentNameDescription)descriptions.get(0);
        NamesManagerTest.assertEquals((Object)"javax.swing.JButton", (Object)description.getClassName());
        NamesManagerTest.assertEquals((Object)"button", (Object)description.getName());
        NamesManagerTest.assertEquals((Object)"btn", (Object)description.getAcronym());
        description.setName("buttn");
        NamesManagerTest.assertEquals((Object)"buttn", (Object)description.getName());
        description.setAcronym("bt");
        NamesManagerTest.assertEquals((Object)"bt", (Object)description.getAcronym());
        description.setAsField(true);
        NamesManagerTest.assertTrue((boolean)description.isAsField());
        description = (NamesManager.ComponentNameDescription)descriptions.get(1);
        NamesManagerTest.assertEquals((Object)"javax.swing.JComboBox", (Object)description.getClassName());
        NamesManagerTest.assertEquals((Object)"combo", (Object)description.getName());
        NamesManagerTest.assertEquals((Object)"cmb", (Object)description.getAcronym());
    }

    @Test
    public void test_getNameDescription() throws Exception {
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "}", "}");
        ArrayList<NamesManager.ComponentNameDescription> descriptions = new ArrayList<NamesManager.ComponentNameDescription>();
        descriptions.add(new NamesManager.ComponentNameDescription("javax.swing.JButton", "b_name", "b_acronym"));
        NamesManager.setNameDescriptions((ToolkitDescription)TOOLKIT, descriptions);
        JavaInfo button = JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)new ConstructorCreationSupport());
        NamesManager.ComponentNameDescription nameDescription = NamesManagerTest.invoke_getNameDescription(button.getDescription());
        NamesManagerTest.assertEquals((Object)"javax.swing.JButton", (Object)nameDescription.getClassName());
        NamesManagerTest.assertEquals((Object)"b_name", (Object)nameDescription.getName());
        NamesManagerTest.assertEquals((Object)"b_acronym", (Object)nameDescription.getAcronym());
        NamesManagerTest.assertEquals((Object)"b_name", (Object)NamesManager.getName((JavaInfo)button));
        NamesManagerTest.assertEquals((Object)"b_acronym", (Object)NamesManager.getAcronym((JavaInfo)button));
        JavaInfo textField = JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JTextField.class, (CreationSupport)new ConstructorCreationSupport());
        NamesManagerTest.assertNull((Object)NamesManagerTest.invoke_getNameDescription(textField.getDescription()));
    }

    @Test
    public void test_getNameDescription_innerClass() throws Exception {
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "}", "}");
        class MyPanel {
            MyPanel() {
            }
        }
        JavaInfo button = JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, MyPanel.class, (CreationSupport)new ConstructorCreationSupport());
        NamesManagerTest.assertEquals((Object)"myPanel", (Object)NamesManager.getName((JavaInfo)button));
        NamesManagerTest.assertEquals((Object)"mpnl", (Object)NamesManager.getAcronym((JavaInfo)button));
    }

    @Test
    public void test_getNameDescription_nullClass() throws Exception {
        ComponentDescription description = new ComponentDescription(null);
        NamesManager.ComponentNameDescription nameDescription = NamesManagerTest.invoke_getNameDescription(description);
        NamesManagerTest.assertNull((Object)nameDescription);
    }

    @Test
    public void test_VariableSupportDescription_from_ComponentNameDescription() throws Exception {
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "}", "}");
        ArrayList<NamesManager.ComponentNameDescription> descriptions = new ArrayList<NamesManager.ComponentNameDescription>();
        descriptions.add(new NamesManager.ComponentNameDescription("javax.swing.JTextField", "textField", "txt", true));
        NamesManager.setNameDescriptions((ToolkitDescription)TOOLKIT, descriptions);
        JavaInfo component = JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("javax.swing.JTextField"), (CreationSupport)new ConstructorCreationSupport());
        NamesManagerTest.assertSame((Object)FieldUniqueVariableDescription.INSTANCE, (Object)TOOLKIT.getGenerationSettings().getVariable(component));
        component = JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("javax.swing.JButton"), (CreationSupport)new ConstructorCreationSupport());
        NamesManagerTest.assertSame((Object)LocalUniqueVariableDescription.INSTANCE, (Object)TOOLKIT.getGenerationSettings().getVariable(component));
    }

    private static NamesManager.ComponentNameDescription invoke_getNameDescription(ComponentDescription componentDescription) throws Exception {
        return (NamesManager.ComponentNameDescription)ReflectionUtils.invokeMethod2(NamesManager.class, (String)"getNameDescription", ComponentDescription.class, (Object)componentDescription);
    }

    @Test
    public void test_ComponentNameDescription_empty() throws Exception {
        IPreferenceStore preferences = TOOLKIT.getPreferences();
        preferences.setValue("typeSpecificVariable.store", "");
        NamesManagerTest.assertEquals((long)0L, (long)NamesManager.getNameDescriptions((ToolkitDescription)TOOLKIT, (boolean)false).size());
    }

    @Test
    public void test_ComponentNameDescription_default() throws Exception {
        IPreferenceStore preferences = TOOLKIT.getPreferences();
        preferences.setDefault("typeSpecificVariable.store", "");
        NamesManagerTest.assertEquals((long)0L, (long)NamesManager.getNameDescriptions((ToolkitDescription)TOOLKIT, (boolean)true).size());
    }

    @Test
    public void test_getDefaultNameDescription() throws Exception {
        NamesManager.ComponentNameDescription description = NamesManager.getDefaultNameDescription((String)"javax.swing.JButton");
        NamesManagerTest.assertEquals((Object)"javax.swing.JButton", (Object)description.getClassName());
        NamesManagerTest.assertEquals((Object)"button", (Object)description.getName());
        NamesManagerTest.assertEquals((Object)"btn", (Object)description.getAcronym());
    }

    @Test
    public void test_validate() throws Exception {
        NamesManagerTest.assertNull((Object)NamesManager.validate((String)"${text}"));
        NamesManagerTest.assertNull((Object)NamesManager.validate((String)"${default_name}"));
        NamesManagerTest.assertNull((Object)NamesManager.validate((String)"${class_name}"));
        NamesManagerTest.assertNull((Object)NamesManager.validate((String)"${class_acronym}"));
        NamesManagerTest.assertNotNull((Object)NamesManager.validate((String)"${noSuchVariable}"));
    }
}

