/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.accessor;

import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.accessor.InvocationChildAssociationAccessor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Before;
import org.junit.Test;

public class InvocationChildAssociationAccessorTest
extends SwingModelTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject != null) {
            InvocationChildAssociationAccessorTest.setFileContentSrc("test/MyContainer.java", this.getTestSource("public class MyContainer extends JPanel {", "  public void addChild(String text, Component component) {", "    add(component);", "  }", "}"));
            InvocationChildAssociationAccessorTest.setFileContentSrc("test/MyContainer.wbp-component.xml", InvocationChildAssociationAccessorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addChild'>", "      <parameter type='java.lang.String'/>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "</component>"));
            InvocationChildAssociationAccessorTest.waitForAutoBuild();
        }
    }

    @Test
    public void test_0() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyContainer {", "  public Test() {", "    addChild('text', new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        InvocationChildAssociationAccessor accessor = new InvocationChildAssociationAccessor(0, "\"\"");
        InvocationChildAssociationAccessorTest.assertEquals((Object)"text", (Object)((StringLiteral)accessor.getExpression((JavaInfo)button)).getLiteralValue());
    }

    @Test
    public void test_setExpression_newValue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyContainer {", "  public Test() {", "    addChild('text', new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        InvocationChildAssociationAccessor accessor = new InvocationChildAssociationAccessor(0, "\"\"");
        InvocationChildAssociationAccessorTest.assertTrue((boolean)accessor.setExpression((JavaInfo)button, "\"new text\""));
        this.assertEditor("public class Test extends MyContainer {", "  public Test() {", "    addChild('new text', new JButton());", "  }", "}");
    }

    @Test
    public void test_setExpression_nullValue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyContainer {", "  public Test() {", "    addChild('text', new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        InvocationChildAssociationAccessor accessor = new InvocationChildAssociationAccessor(0, "\"\"");
        InvocationChildAssociationAccessorTest.assertTrue((boolean)accessor.setExpression((JavaInfo)button, null));
        this.assertEditor("public class Test extends MyContainer {", "  public Test() {", "    addChild('', new JButton());", "  }", "}");
    }

    @Test
    public void test_setExpression_nullValue_noDefault() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyContainer {", "  public Test() {", "    addChild('text', new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        InvocationChildAssociationAccessor accessor = new InvocationChildAssociationAccessor(0, null);
        InvocationChildAssociationAccessorTest.assertFalse((boolean)accessor.setExpression((JavaInfo)button, null));
        this.assertEditor("public class Test extends MyContainer {", "  public Test() {", "    addChild('text', new JButton());", "  }", "}");
    }
}

