/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.accessor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.AccessorUtils;
import org.eclipse.wb.internal.core.model.property.accessor.IAccessibleExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IExposableExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class AccessorUtilsTest
extends SwingModelTest {
    private Class<?> getAccessObjectClass() throws Exception {
        AccessorUtilsTest.setFileContentSrc("test/AccessObject.java", AccessorUtilsTest.getSourceDQ("package test;", "public class AccessObject {", "  public int publicField;", "  protected int protectedField;", "  public void publicMethod() {", "  }", "  protected void protectedMethod() {", "  }", "}"));
        AccessorUtilsTest.waitForAutoBuild();
        return this.m_lastLoader.loadClass("test.AccessObject");
    }

    private Class<?> getTooltipObjectClass() throws Exception {
        AccessorUtilsTest.setFileContentSrc("test/TooltipObject.java", AccessorUtilsTest.getSourceDQ("package test;", "public class TooltipObject {", "  /**", "  * Some javadoc for field.", "  */", "  public int javadocField;", "  public int emptyField;", "  /**", "  * Some javadoc for method.", "  */", "  public void javadocMethod() {", "  }", "  public void emptyMethod() {", "  }", "}"));
        AccessorUtilsTest.waitForAutoBuild();
        return this.m_lastLoader.loadClass("test.TooltipObject");
    }

    @Test
    public void test_IAccessibleExpressionAccessor_forMethod_public() throws Exception {
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Method method = ReflectionUtils.getMethod(this.getAccessObjectClass(), (String)"publicMethod", (Class[])new Class[0]);
        IAccessibleExpressionAccessor accessor = AccessorUtils.IAccessibleExpressionAccessor_forMethod((Method)method);
        AccessorUtilsTest.assertTrue((boolean)accessor.isAccessible(null));
    }

    @Test
    public void test_IAccessibleExpressionAccessor_forMethod_protected() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Method method = ReflectionUtils.getMethod(this.getAccessObjectClass(), (String)"protectedMethod", (Class[])new Class[0]);
        IAccessibleExpressionAccessor accessor = AccessorUtils.IAccessibleExpressionAccessor_forMethod((Method)method);
        AccessorUtilsTest.assertTrue((boolean)accessor.isAccessible((JavaInfo)panel));
        AccessorUtilsTest.assertFalse((boolean)accessor.isAccessible((JavaInfo)button));
    }

    @Test
    public void test_IAccessibleExpressionAccessor_forField_public() throws Exception {
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Field field = ReflectionUtils.getFieldByName(this.getAccessObjectClass(), (String)"publicField");
        IAccessibleExpressionAccessor accessor = AccessorUtils.IAccessibleExpressionAccessor_forField((Field)field);
        AccessorUtilsTest.assertTrue((boolean)accessor.isAccessible(null));
    }

    @Test
    public void test_IAccessibleExpressionAccessor_forField_protected() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Field field = ReflectionUtils.getFieldByName(this.getAccessObjectClass(), (String)"protectedField");
        IAccessibleExpressionAccessor accessor = AccessorUtils.IAccessibleExpressionAccessor_forField((Field)field);
        AccessorUtilsTest.assertTrue((boolean)accessor.isAccessible((JavaInfo)panel));
        AccessorUtilsTest.assertFalse((boolean)accessor.isAccessible((JavaInfo)button));
    }

    @Test
    public void test_getExposableExpressionAccessor() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("Class");
        IExposableExpressionAccessor accessor = AccessorUtils.getExposableExpressionAccessor((Property)property);
        AccessorUtilsTest.assertNull((Object)accessor);
        property = panel.getPropertyByTitle("enabled");
        accessor = AccessorUtils.getExposableExpressionAccessor((Property)property);
        AccessorUtilsTest.assertNotNull((Object)accessor);
        AccessorUtilsTest.assertEquals((Object)"isEnabled()", (Object)accessor.getGetterCode((JavaInfo)panel));
        AccessorUtilsTest.assertEquals((Object)"setEnabled(false)", (Object)accessor.getSetterCode((JavaInfo)panel, "false"));
    }

    @Test
    public void test_PropertyTooltipProvider_forMethod_noJavadoc() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("enabled");
        Method method = ReflectionUtils.getMethod(this.getTooltipObjectClass(), (String)"emptyMethod", (Class[])new Class[0]);
        PropertyTooltipProvider tooltipProvider = AccessorUtils.PropertyTooltipProvider_forMethod((Method)method);
        AccessorUtilsTest.assertEquals((Object)"enabled", (Object)this.getTooltipText(tooltipProvider, property));
    }

    @Test
    public void test_PropertyTooltipProvider_forMethod_withJavadoc() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("enabled");
        Method method = ReflectionUtils.getMethod(this.getTooltipObjectClass(), (String)"javadocMethod", (Class[])new Class[0]);
        PropertyTooltipProvider tooltipProvider = AccessorUtils.PropertyTooltipProvider_forMethod((Method)method);
        AccessorUtilsTest.assertEquals((Object)"Some javadoc for method.", (Object)this.getTooltipText(tooltipProvider, property));
    }

    @Test
    public void test_PropertyTooltipProvider_forField_noJavadoc() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("enabled");
        Field method = ReflectionUtils.getFieldByName(this.getTooltipObjectClass(), (String)"emptyField");
        PropertyTooltipProvider tooltipProvider = AccessorUtils.PropertyTooltipProvider_forField((Field)method);
        AccessorUtilsTest.assertEquals((Object)"enabled", (Object)this.getTooltipText(tooltipProvider, property));
    }

    @Test
    public void test_PropertyTooltipProvider_forField_withJavadoc() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("enabled");
        Field method = ReflectionUtils.getFieldByName(this.getTooltipObjectClass(), (String)"javadocField");
        PropertyTooltipProvider tooltipProvider = AccessorUtils.PropertyTooltipProvider_forField((Field)method);
        AccessorUtilsTest.assertEquals((Object)"Some javadoc for field.", (Object)this.getTooltipText(tooltipProvider, property));
    }

    private String getTooltipText(PropertyTooltipProvider tooltipProvider, Property someProperty) throws Exception {
        return (String)ReflectionUtils.invokeMethod2((Object)tooltipProvider, (String)"getText", Property.class, (Object)someProperty);
    }
}

