/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import java.awt.Component;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.resource.EmptyDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.model.description.resource.FromListDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProviderFactory;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class DescriptionVersionsProvidersTest
extends SwingModelTest {
    private static final String POINT_TOOLKITS = "org.eclipse.wb.core.toolkits";
    private static final String POINT_VER_FACTORIES = "org.eclipse.wb.core.descriptionVersionsProviderFactories";

    @Test
    public void test_providerEmpty() throws Exception {
        IDescriptionVersionsProvider provider = EmptyDescriptionVersionsProvider.INSTANCE;
        Assertions.assertThat((List)provider.getVersions(Object.class)).isEmpty();
        Assertions.assertThat((List)provider.getVersions(Component.class)).isEmpty();
    }

    @Test
    public void test_providerFromList_noCurrentInList() throws Exception {
        try {
            new FromListDescriptionVersionsProvider(List.of("1.0", "2.0", "3.0"), "2.1"){

                protected boolean validate(Class<?> componentClass) throws Exception {
                    return false;
                }
            };
            DescriptionVersionsProvidersTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_providerFromList_getVersions_middleVersion() throws Exception {
        List<String> allVersions = List.of("1.0", "2.0", "3.0");
        String currentVersion = "2.0";
        FromListDescriptionVersionsProvider provider = new FromListDescriptionVersionsProvider(allVersions, currentVersion){

            protected boolean validate(Class<?> componentClass) throws Exception {
                return Component.class.isAssignableFrom(componentClass);
            }
        };
        List versions = provider.getVersions(Object.class);
        Assertions.assertThat((List)versions).isEmpty();
        versions = provider.getVersions(JButton.class);
        DescriptionVersionsProvidersTest.assertEquals((Object)versions, List.of("2.0", "1.0"));
    }

    @Test
    public void test_providerFromList_getVersions_latestVersion() throws Exception {
        List<String> allVersions = List.of("1.0", "2.0", "3.0");
        String currentVersion = "3.0";
        FromListDescriptionVersionsProvider provider = new FromListDescriptionVersionsProvider(allVersions, currentVersion){

            protected boolean validate(Class<?> componentClass) throws Exception {
                return Component.class.isAssignableFrom(componentClass);
            }
        };
        List versions = provider.getVersions(JButton.class);
        DescriptionVersionsProvidersTest.assertEquals((Object)versions, List.of("3.0", "2.0", "1.0"));
    }

    @Test
    public void test_componentResourceVersions_20() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String componentClassName = ComponentWithVersionedDescriptions.class.getName();
            testBundle.addJar("myClasses.jar").addClass(ComponentWithVersionedDescriptions.class).close();
            testBundle.addClass(DescriptionVersionsProvider_2.class);
            testBundle.addClass(DescriptionVersionsProviderFactory_2.class);
            testBundle.addExtension(POINT_TOOLKITS, "<toolkit id='org.eclipse.wb.swing'>", "  <classLoader-library bundle='" + testBundle.getId() + "' jar='myClasses.jar'/>", "</toolkit>");
            testBundle.addExtension(POINT_VER_FACTORIES, "<factory class='" + DescriptionVersionsProviderFactory_2.class.getName() + "'/>");
            String descriptionPath = componentClassName.replace('.', '/') + ".wbp-component.xml";
            testBundle.setFile("wbp-meta/" + descriptionPath, "bad XML");
            testBundle.setFile("wbp-meta/1.0/" + descriptionPath, "bad XML");
            testBundle.setFile("wbp-meta/2.0/" + descriptionPath, DescriptionVersionsProvidersTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='marker'>expectedMarker</parameter>", "  </parameters>", "</component>"));
            testBundle.setFile("wbp-meta/3.0/" + descriptionPath, "bad XML");
            testBundle.install();
            try {
                this.parseContainer("public class Test extends JFrame {", "  public Test() {", "      // filler", "  }", "}");
                ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)componentClassName);
                DescriptionVersionsProvidersTest.assertEquals((Object)"expectedMarker", (Object)description.getParameter("marker"));
            }
            finally {
                testBundle.uninstall();
                DescriptionVersionsProvidersTest.waitEventLoop(10);
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_componentResourceVersions_default() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String componentClassName = ComponentWithVersionedDescriptions.class.getName();
            testBundle.addJar("myClasses.jar").addClass(ComponentWithVersionedDescriptions.class).close();
            testBundle.addClass(DescriptionVersionsProviderFactory_default.class);
            testBundle.addExtension(POINT_TOOLKITS, "<toolkit id='org.eclipse.wb.swing'>", "  <classLoader-library bundle='" + testBundle.getId() + "' jar='myClasses.jar'/>", "</toolkit>");
            testBundle.addExtension(POINT_VER_FACTORIES, "<factory class='" + DescriptionVersionsProviderFactory_default.class.getName() + "'/>");
            String descriptionPath = componentClassName.replace('.', '/') + ".wbp-component.xml";
            testBundle.setFile("wbp-meta/" + descriptionPath, DescriptionVersionsProvidersTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='marker'>expectedMarker</parameter>", "  </parameters>", "</component>"));
            testBundle.setFile("wbp-meta/1.0/" + descriptionPath, "bad XML");
            testBundle.setFile("wbp-meta/2.0/" + descriptionPath, "bad XML");
            testBundle.setFile("wbp-meta/3.0/" + descriptionPath, "bad XML");
            testBundle.install();
            try {
                this.parseContainer("public class Test extends JFrame {", "  public Test() {", "      // filler", "  }", "}");
                ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)componentClassName);
                DescriptionVersionsProvidersTest.assertEquals((Object)"expectedMarker", (Object)description.getParameter("marker"));
            }
            finally {
                testBundle.uninstall();
                DescriptionVersionsProvidersTest.waitEventLoop(10);
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_factoryResourceVersions_20() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            Class<FactoryWithVersionedDescriptions> factoryClass = FactoryWithVersionedDescriptions.class;
            String factoryClassName = factoryClass.getName();
            testBundle.addJar("myClasses.jar").addClass(factoryClass).close();
            testBundle.addClass(DescriptionVersionsProvider_2.class);
            testBundle.addClass(DescriptionVersionsProviderFactory_2.class);
            testBundle.addExtension(POINT_TOOLKITS, "<toolkit id='org.eclipse.wb.swing'/>");
            testBundle.addExtension(POINT_VER_FACTORIES, "<factory class='" + DescriptionVersionsProviderFactory_2.class.getName() + "'/>");
            String descriptionPath = factoryClassName.replace('.', '/') + ".wbp-factory.xml";
            testBundle.setFile("wbp-meta/" + descriptionPath, "bad XML");
            testBundle.setFile("wbp-meta/1.0/" + descriptionPath, "bad XML");
            testBundle.setFile("wbp-meta/2.0/" + descriptionPath, DescriptionVersionsProvidersTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <description>Some description</description>", "  </method>", "</factory>"));
            testBundle.setFile("wbp-meta/3.0/" + descriptionPath, "bad XML");
            testBundle.install();
            try {
                Bundle libBundle = testBundle.getBundle();
                String path = FileLocator.toFileURL((URL)libBundle.getEntry("/myClasses.jar")).getPath();
                m_testProject.addExternalJar(path);
                this.parseContainer("public class Test extends JFrame {", "  public Test() {", "      // filler", "  }", "}");
                Map descriptions = FactoryDescriptionHelper.getDescriptionsMap((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass(factoryClassName), (boolean)true);
                Assertions.assertThat((Map)descriptions).hasSize(1);
            }
            finally {
                testBundle.uninstall();
                DescriptionVersionsProvidersTest.waitEventLoop(10);
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    public static class ComponentWithVersionedDescriptions {
    }

    public static class DescriptionVersionsProviderFactory_2
    implements IDescriptionVersionsProviderFactory {
        public Map<String, Object> getVersions(IJavaProject javaProject, ClassLoader classLoader) throws Exception {
            return Map.of("test.version", "2.0");
        }

        public IDescriptionVersionsProvider getProvider(IJavaProject javaProject, ClassLoader classLoader) throws Exception {
            return new DescriptionVersionsProvider_2();
        }
    }

    public static class DescriptionVersionsProviderFactory_default
    implements IDescriptionVersionsProviderFactory {
        public Map<String, Object> getVersions(IJavaProject javaProject, ClassLoader classLoader) throws Exception {
            return Map.of("test.version", "3.0");
        }

        public IDescriptionVersionsProvider getProvider(IJavaProject javaProject, ClassLoader classLoader) throws Exception {
            return null;
        }
    }

    public static final class DescriptionVersionsProvider_2
    extends FromListDescriptionVersionsProvider {
        public DescriptionVersionsProvider_2() {
            super(List.of("1.0", "2.0", "3.0"), "2.0");
        }

        protected boolean validate(Class<?> componentClass) throws Exception {
            return componentClass.getName().contains("WithVersionedDescriptions");
        }
    }

    public static class FactoryWithVersionedDescriptions {
        public static JButton createButton() {
            return new JButton();
        }
    }
}

