/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectBefore;
import org.eclipse.wb.tests.designer.core.annotations.WaitForAutoBuildAfter;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public abstract class AbstractJavaProjectTest
extends DesignerTestCase {
    private static final List<IFile> m_createdResources = new ArrayList<IFile>();
    @Rule
    public TestRule methodRule = new TestRule(){

        public Statement apply(final Statement base, final Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    ArrayList<Throwable> errors;
                    block12: {
                        errors = new ArrayList<Throwable>();
                        if (description.getAnnotation(DisposeProjectBefore.class) != null) {
                            AbstractJavaProjectTest.waitEventLoop(10);
                            AbstractJavaProjectTest.do_projectDispose();
                            AbstractJavaProjectTest.waitEventLoop(10);
                        }
                        try {
                            try {
                                base.evaluate();
                            }
                            catch (Throwable t) {
                                errors.add(t);
                                if (description.getAnnotation(DisposeProjectAfter.class) != null) {
                                    AbstractJavaProjectTest.waitEventLoop(10);
                                    AbstractJavaProjectTest.do_projectDispose();
                                    AbstractJavaProjectTest.waitEventLoop(10);
                                }
                                if (description.getAnnotation(WaitForAutoBuildAfter.class) != null) {
                                    AbstractJavaProjectTest.waitForAutoBuild();
                                }
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            if (description.getAnnotation(DisposeProjectAfter.class) != null) {
                                AbstractJavaProjectTest.waitEventLoop(10);
                                AbstractJavaProjectTest.do_projectDispose();
                                AbstractJavaProjectTest.waitEventLoop(10);
                            }
                            if (description.getAnnotation(WaitForAutoBuildAfter.class) != null) {
                                AbstractJavaProjectTest.waitForAutoBuild();
                            }
                            throw throwable;
                        }
                        if (description.getAnnotation(DisposeProjectAfter.class) != null) {
                            AbstractJavaProjectTest.waitEventLoop(10);
                            AbstractJavaProjectTest.do_projectDispose();
                            AbstractJavaProjectTest.waitEventLoop(10);
                        }
                        if (description.getAnnotation(WaitForAutoBuildAfter.class) != null) {
                            AbstractJavaProjectTest.waitForAutoBuild();
                        }
                    }
                    MultipleFailureException.assertEmpty(errors);
                }
            };
        }
    };
    public static TestProject m_testProject;
    protected static IProject m_project;
    protected static IJavaProject m_javaProject;

    @Override
    @After
    public void tearDown() throws Exception {
        block2: for (IFile resource : m_createdResources) {
            int maxCount = 5000;
            int i = 0;
            while (i < maxCount) {
                try {
                    if (resource.isReadOnly()) {
                        ResourceAttributes attributes = new ResourceAttributes();
                        attributes.setReadOnly(false);
                        resource.setResourceAttributes(attributes);
                    }
                    AbstractJavaProjectTest.forceDeleteFile(resource);
                    continue block2;
                }
                catch (Exception e) {
                    if (i == maxCount - 1) {
                        throw e;
                    }
                    AbstractJavaProjectTest.waitEventLoop(10);
                    ++i;
                }
            }
        }
        m_createdResources.clear();
        super.tearDown();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        AbstractJavaProjectTest.do_projectDispose();
    }

    public static void do_projectCreate() throws Exception {
        if (m_testProject == null) {
            m_testProject = new TestProject();
            m_project = m_testProject.getProject();
            m_javaProject = m_testProject.getJavaProject();
        }
    }

    public static void do_projectDispose() throws Exception {
        if (m_testProject != null) {
            TestProject testProject = m_testProject;
            m_testProject = null;
            m_project = null;
            m_javaProject = null;
            AbstractJavaProjectTest.disposeProjectWithRetry(testProject);
        }
    }

    private static void disposeProjectWithRetry(TestProject testProject) throws Exception {
        Throwable error = null;
        int i = 0;
        while (i < 100) {
            try {
                testProject.dispose();
                return;
            }
            catch (Throwable e) {
                error = e;
                System.gc();
                AbstractJavaProjectTest.waitForAutoBuild();
                AbstractJavaProjectTest.waitEventLoop(10);
                ++i;
            }
        }
        if (error != null) {
            throw new Error(error);
        }
    }

    public static void forgetCreatedResources() {
        m_createdResources.clear();
    }

    public static void waitForAutoBuild() throws Exception {
        AbstractJavaProjectTest.waitEventLoop(25);
        TestProject.waitForAutoBuild();
        Object problemsText = "";
        for (IFile file : m_createdResources) {
            IMarker[] markers;
            if (!file.exists()) continue;
            IMarker[] iMarkerArray = markers = file.findMarkers("org.eclipse.jdt.core.problem", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker.getAttribute("severity", 2) == 2) {
                    problemsText = (String)problemsText + "\n" + String.valueOf(file.getFullPath()) + "\n\tline " + String.valueOf(marker.getAttribute("lineNumber")) + "\n\t" + String.valueOf(marker.getAttribute("message"));
                }
                ++n2;
            }
        }
        AbstractJavaProjectTest.assertEquals((Object)"", (Object)problemsText);
    }

    public final ICompilationUnit createModelCompilationUnit(String packageName, String unitName, String code) throws Exception {
        IPackageFragment pkg = m_testProject.getPackage(packageName);
        ICompilationUnit compilationUnit = m_testProject.createUnit(pkg, unitName, code);
        IFile resource = (IFile)compilationUnit.getUnderlyingResource();
        m_createdResources.add(resource);
        return compilationUnit;
    }

    public final IType createModelType(String packageName, String unitName, String code) throws Exception {
        ICompilationUnit compilationUnit = this.createModelCompilationUnit(packageName, unitName, code);
        return compilationUnit.getTypes()[0];
    }

    public static IFile getFileSrc(String folderName, String fileName) {
        return AbstractJavaProjectTest.getFile("src/" + folderName, fileName);
    }

    public static IFile getFile(String folderName, String fileName) {
        return AbstractJavaProjectTest.getFile(m_project, folderName, fileName);
    }

    public static IFile getFile(IProject project, String folderName, String fileName) {
        return AbstractJavaProjectTest.getFile(project, folderName + "/" + fileName);
    }

    public static IFile getFileSrc(String path) {
        return AbstractJavaProjectTest.getFile("src/" + path);
    }

    public static IFile getFile(String path) {
        return AbstractJavaProjectTest.getFile(m_project, path);
    }

    public static IFile getFile(IProject project, String path) {
        return project.getFile((IPath)new Path(path));
    }

    public static String getFileContentSrc(IProject project, String path) throws Exception {
        return AbstractJavaProjectTest.getFileContent(project, "src/" + path);
    }

    public static String getFileContentSrc(String path) {
        return AbstractJavaProjectTest.getFileContent("src/" + path);
    }

    public static String getFileContent(IProject project, String path) {
        IFile file = AbstractJavaProjectTest.getFile(project, path);
        return AbstractJavaProjectTest.getFileContent(file);
    }

    public static String getFileContent(String path) {
        IFile file = AbstractJavaProjectTest.getFile(path);
        return AbstractJavaProjectTest.getFileContent(file);
    }

    public static String getFileContent(IFile file) {
        if (!file.exists()) {
            AbstractJavaProjectTest.fail((String)("File " + String.valueOf(file) + " does not exist."));
        }
        try {
            return IOUtils2.readString((InputStream)file.getContents());
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate((Throwable)e);
        }
    }

    public static IFile setFileContentSrc(String folderName, String fileName, String content) throws Exception {
        return AbstractJavaProjectTest.setFileContent("src/" + folderName, fileName, content);
    }

    public static IFile setFileContent(String folderName, String fileName, String content) throws Exception {
        return AbstractJavaProjectTest.setFileContent(folderName + "/" + fileName, content);
    }

    public static IFile setFileContent(IProject project, String folderName, String fileName, String content) throws Exception {
        return AbstractJavaProjectTest.setFileContent(project, folderName + "/" + fileName, content);
    }

    public static IFile setFileContentSrc(String path, String content) throws Exception {
        return AbstractJavaProjectTest.setFileContent("src/" + path, content);
    }

    public static IFile setFileContent(String path, String content) throws Exception {
        IFile file = AbstractJavaProjectTest.getFile(path);
        AbstractJavaProjectTest.setFileContent(file, content);
        return file;
    }

    public static IFile setFileContentSrc(IProject project, String path, String content) throws Exception {
        return AbstractJavaProjectTest.setFileContent(project, "src/" + path, content);
    }

    public static IFile setFileContent(IProject project, String path, String content) throws Exception {
        IFile file = AbstractJavaProjectTest.getFile(project, path);
        AbstractJavaProjectTest.setFileContent0(file, content);
        return file;
    }

    public static void setFileContent(IFile file, String content) throws Exception {
        boolean created = AbstractJavaProjectTest.setFileContent0(file, content);
        if (created) {
            m_createdResources.add(file);
        }
    }

    public static boolean setFileContent0(IFile file, String content) throws Exception {
        return AbstractJavaProjectTest.setFileContent(file, content.getBytes());
    }

    public static boolean setFileContent(IFile file, byte[] bytes) throws CoreException {
        return IOUtils2.setFileContents((IFile)file, (InputStream)new ByteArrayInputStream(bytes));
    }

    public static boolean setFileContent(IFile file, InputStream inputStream) throws CoreException {
        return IOUtils2.setFileContents((IFile)file, (InputStream)inputStream);
    }

    public static void assertFileExists(String pathString) {
        IFile file = AbstractJavaProjectTest.getFile(pathString);
        AbstractJavaProjectTest.assertTrue((boolean)file.exists());
    }

    public static void assertFileNotExists(String pathString) {
        IFile file = AbstractJavaProjectTest.getFile(pathString);
        AbstractJavaProjectTest.assertFalse((boolean)file.exists());
    }

    public static IFolder getFolderSrc(String path) throws CoreException {
        return AbstractJavaProjectTest.getFolder("src/" + path);
    }

    public static IFolder getFolder0(String fullPath) throws CoreException {
        Path path = new Path(fullPath);
        return m_project.getFolder((IPath)path);
    }

    public static IFolder getFolder(String path) throws CoreException {
        IFolder folder = AbstractJavaProjectTest.getFolder0(path);
        IOUtils2.ensureFolderExists((IFolder)folder);
        return folder;
    }

    public final IFolder ensureFolderExists(String path) throws CoreException {
        return IOUtils2.ensureFolderExists((IProject)m_project, (String)path);
    }

    public static void deleteFiles(IFolder folder) throws Exception {
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFolder) {
                AbstractJavaProjectTest.deleteFiles((IFolder)resource);
            }
            resource.delete(true, null);
            ++n2;
        }
    }

    public static void forceDeleteFile(IFile file) {
        while (file.exists()) {
            try {
                file.refreshLocal(2, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                file.delete(true, null);
            }
            catch (Throwable e) {
                AbstractJavaProjectTest.waitEventLoop(100);
            }
        }
    }

    public static void forceDeleteCompilationUnit(ICompilationUnit cu) {
        while (cu.exists()) {
            try {
                cu.getResource().refreshLocal(2, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                cu.delete(true, null);
            }
            catch (Throwable e) {
                AbstractJavaProjectTest.waitEventLoop(100);
            }
        }
    }

    public final IFile createImagePNG(String path, int width, int height) throws Exception {
        byte[] bytes;
        IFile file = AbstractJavaProjectTest.getFile(path);
        boolean created = IOUtils2.setFileContents((IFile)file, (InputStream)new ByteArrayInputStream(bytes = this.createImageBytesPNG(width, height)));
        if (created) {
            m_createdResources.add(file);
        }
        return file;
    }

    private byte[] createImageBytesPNG(int width, int height) {
        Image myImage = new Image(null, width, height);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{myImage.getImageData()};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        imageLoader.save((OutputStream)baos, 5);
        myImage.dispose();
        return baos.toByteArray();
    }
}

