/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.tools.TargetingTool;

public class SelectEditPartTracker
extends TargetingTool {
    private final EditPart m_sourceEditPart;
    private boolean m_isSelected;

    public SelectEditPartTracker(EditPart sourceEditPart) {
        this.m_sourceEditPart = sourceEditPart;
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.m_isSelected = false;
    }

    @Override
    protected Cursor calculateCursor() {
        return this.m_state == 1 || this.m_state == 2 ? this.getDefaultCursor() : super.calculateCursor();
    }

    protected boolean handleButtonDown(int button) {
        if ((button == 1 || button == 3) && this.m_state == 1 && this.m_sourceEditPart.getSelected() == 0) {
            this.performSelection();
        }
        if (button == 1) {
            if (this.m_state == 1) {
                this.m_state = 2;
            }
        } else {
            this.m_state = button == 3 ? 0x40000000 : 8;
            this.handleInvalidInput();
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.m_state == 2) {
            this.performSelection();
            this.m_state = 0x40000000;
        }
        return true;
    }

    protected boolean handleDragStarted() {
        if (this.m_state == 2) {
            this.m_state = 4;
        }
        return true;
    }

    protected boolean handleDoubleClick(int button) {
        if (button == 1) {
            SelectionRequest request = new SelectionRequest();
            request.setType((Object)"open");
            request.setLocation(this.getLocation());
            this.m_sourceEditPart.performRequest((Request)request);
        }
        return true;
    }

    private void performSelection() {
        if (!this.m_isSelected) {
            this.m_isSelected = true;
            IEditPartViewer viewer = this.getCurrentViewer();
            if ((this.m_stateMask & 0x40000) != 0) {
                if (viewer.getSelectedEditParts().contains((Object)this.m_sourceEditPart)) {
                    viewer.deselect((org.eclipse.gef.EditPart)this.m_sourceEditPart);
                } else {
                    viewer.appendSelection((org.eclipse.gef.EditPart)this.m_sourceEditPart);
                }
            } else if ((this.m_stateMask & 0x20000) != 0) {
                viewer.appendSelection((org.eclipse.gef.EditPart)this.m_sourceEditPart);
            } else {
                viewer.select((org.eclipse.gef.EditPart)this.m_sourceEditPart);
            }
        }
    }
}

