/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.support;

import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.ShellInfo;
import org.eclipse.wb.internal.swt.support.CoordinateUtils;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class CoordinateUtilsTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Ignore
    @Test
    public void test_1() throws Exception {
        ShellInfo shell = (ShellInfo)this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Button button = new Button(this, SWT.NONE);", "    button.setBounds(10, 20, 50, 30);", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        shell.refresh();
        if (EnvironmentUtils.IS_LINUX) {
            Shell swtShell = shell.getWidget();
            swtShell.setVisible(true);
            CoordinateUtilsTest.waitEventLoop(10);
        }
        Point shellLocation = CoordinateUtils.getDisplayLocation((Control)shell.getWidget());
        if (EnvironmentUtils.IS_WINDOWS) {
            CoordinateUtilsTest.assertEquals((Object)new Point(-10000, -10000), (Object)shellLocation);
        }
        Insets shellInsets = CoordinateUtils.getClientAreaInsets((Composite)shell.getWidget());
        CoordinateUtilsTest.assertTrue((shellInsets.left == shellInsets.right ? 1 : 0) != 0);
        Assertions.assertThat((int)shellInsets.left).isGreaterThanOrEqualTo(0);
        Assertions.assertThat((int)shellInsets.top).isGreaterThanOrEqualTo(15);
        Point buttonLocation = CoordinateUtils.getDisplayLocation((Control)button.getWidget());
        CoordinateUtilsTest.assertEquals((long)(shellLocation.x + shellInsets.left + 10), (long)buttonLocation.x);
        CoordinateUtilsTest.assertEquals((long)(shellLocation.y + shellInsets.top + 20), (long)buttonLocation.y);
        Rectangle bounds = CoordinateUtils.getBounds((Control)shell.getWidget(), (Control)button.getWidget());
        CoordinateUtilsTest.assertEquals((long)(shellInsets.left + 10), (long)bounds.x);
        CoordinateUtilsTest.assertEquals((long)(shellInsets.top + 20), (long)bounds.y);
        CoordinateUtilsTest.assertEquals((long)50L, (long)bounds.width);
        CoordinateUtilsTest.assertEquals((long)30L, (long)bounds.height);
    }

    @Ignore
    @Test
    public void test_withGroup() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Group group = new Group(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        CompositeInfo group = (CompositeInfo)shell.getChildrenControls().get(0);
        Insets insets = Expectations.get(new Insets(15, 3, 3, 3), new Expectations.InsValue("flanker-windows", new Insets(15, 3, 3, 3)), new Expectations.InsValue("scheglov-win", new Insets(15, 3, 3, 3)));
        CoordinateUtilsTest.assertEquals((Object)insets, (Object)CoordinateUtils.getClientAreaInsets2((Composite)group.getWidget()));
    }
}

