/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts;

import org.apache.commons.lang3.NotImplementedException;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.ConstructorAssociation;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class FillLayoutTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_isHorizontal_1() throws Exception {
        this.test_isHorizontal(new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout(SWT.HORIZONTAL));", "  }", "}"});
    }

    @Test
    public void test_isHorizontal_2() throws Exception {
        this.test_isHorizontal(new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout());", "  }", "}"});
    }

    private void test_isHorizontal(String[] lines) throws Exception {
        CompositeInfo shellInfo = this.parseComposite(lines);
        FillLayoutInfo layoutInfo = (FillLayoutInfo)shellInfo.getLayout();
        FillLayoutTest.assertNotNull((Object)layoutInfo);
        shellInfo.refresh();
        FillLayoutTest.assertTrue((boolean)layoutInfo.isHorizontal());
        Property property = layoutInfo.getPropertyByTitle("type");
        FillLayoutTest.assertNotNull((Object)property);
        property.setValue((Object)512);
        FillLayoutTest.assertFalse((boolean)layoutInfo.isHorizontal());
    }

    @Test
    public void test_NoVirtualLayoutData() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        FillLayoutTest.assertTrue((boolean)shell.getChildrenControls().isEmpty());
        FillLayoutInfo layout = (FillLayoutInfo)shell.getLayout();
        try {
            ReflectionUtils.invokeMethod((Object)layout, (String)"getDefaultVirtualDataObject()", (Object[])new Object[0]);
            FillLayoutTest.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
    }

    @Test
    public void test_AddControls() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout());", "  }", "}");
        FillLayoutTest.assertTrue((boolean)shell.getChildrenControls().isEmpty());
        FillLayoutInfo layout = (FillLayoutInfo)shell.getLayout();
        ControlInfo button = BTestUtils.createButton();
        layout.command_CREATE(button, null);
        ConstructorAssociation association = (ConstructorAssociation)button.getAssociation();
        FillLayoutTest.assertNotNull((Object)association);
        FillLayoutTest.assertSame((Object)((ConstructorCreationSupport)button.getCreationSupport()).getCreation(), (Object)association.getCreation());
        FillLayoutTest.assertEquals((long)1L, (long)shell.getChildrenControls().size());
        FillLayoutTest.assertSame((Object)button, shell.getChildrenControls().get(0));
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout());", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "  }", "}");
        ControlInfo label = BTestUtils.createControl("org.eclipse.swt.widgets.Label");
        layout.command_CREATE(label, button);
        FillLayoutTest.assertNotNull((Object)label.getAssociation());
        FillLayoutTest.assertEquals((long)2L, (long)shell.getChildrenControls().size());
        FillLayoutTest.assertSame((Object)label, shell.getChildrenControls().get(0));
        FillLayoutTest.assertSame((Object)button, shell.getChildrenControls().get(1));
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout());", "    {", "      Label label = new Label(shell, SWT.NONE);", "      label.setText('New Label');", "    }", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_MoveControls() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout());", "    {", "      Label label = new Label(shell, SWT.NONE);", "    }", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "    {", "      Combo combo = new Combo(shell, SWT.READ_ONLY);", "    }", "  }", "}");
        FillLayoutInfo layout = (FillLayoutInfo)shellInfo.getLayout();
        ControlInfo labelInfo = (ControlInfo)shellInfo.getChildrenControls().get(0);
        ControlInfo buttonInfo = (ControlInfo)shellInfo.getChildrenControls().get(1);
        ControlInfo comboInfo = (ControlInfo)shellInfo.getChildrenControls().get(2);
        Association labelAssociation = labelInfo.getAssociation();
        Association buttonAssociation = buttonInfo.getAssociation();
        Association comboAssociation = comboInfo.getAssociation();
        FillLayoutTest.assertNotNull((Object)labelAssociation);
        FillLayoutTest.assertNotNull((Object)buttonAssociation);
        FillLayoutTest.assertNotNull((Object)comboAssociation);
        layout.command_MOVE(comboInfo, buttonInfo);
        FillLayoutTest.assertSame((Object)labelInfo, shellInfo.getChildrenControls().get(0));
        FillLayoutTest.assertSame((Object)comboInfo, shellInfo.getChildrenControls().get(1));
        FillLayoutTest.assertSame((Object)buttonInfo, shellInfo.getChildrenControls().get(2));
        FillLayoutTest.assertSame((Object)labelAssociation, (Object)labelInfo.getAssociation());
        FillLayoutTest.assertSame((Object)buttonAssociation, (Object)buttonInfo.getAssociation());
        FillLayoutTest.assertSame((Object)comboAssociation, (Object)comboInfo.getAssociation());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout());", "    {", "      Label label = new Label(shell, SWT.NONE);", "    }", "    {", "      Combo combo = new Combo(shell, SWT.READ_ONLY);", "    }", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "  }", "}");
        layout.command_MOVE(labelInfo, null);
        FillLayoutTest.assertSame((Object)comboInfo, shellInfo.getChildrenControls().get(0));
        FillLayoutTest.assertSame((Object)buttonInfo, shellInfo.getChildrenControls().get(1));
        FillLayoutTest.assertSame((Object)labelInfo, shellInfo.getChildrenControls().get(2));
        FillLayoutTest.assertSame((Object)labelAssociation, (Object)labelInfo.getAssociation());
        FillLayoutTest.assertSame((Object)buttonAssociation, (Object)buttonInfo.getAssociation());
        FillLayoutTest.assertSame((Object)comboAssociation, (Object)comboInfo.getAssociation());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout());", "    {", "      Combo combo = new Combo(shell, SWT.READ_ONLY);", "    }", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "    {", "      Label label = new Label(shell, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_ReparentControls() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout());", "    {", "      Label label = new Label(shell, SWT.NONE);", "    }", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "    {", "      Composite composite = new Composite(shell, SWT.NONE);", "      composite.setLayout(new FillLayout());", "      {", "        Combo combo = new Combo(composite, SWT.READ_ONLY);", "      }", "    }", "  }", "}");
        FillLayoutTest.assertEquals((long)3L, (long)shellInfo.getChildrenControls().size());
        ControlInfo labelInfo = (ControlInfo)shellInfo.getChildrenControls().get(0);
        ControlInfo buttonInfo = (ControlInfo)shellInfo.getChildrenControls().get(1);
        CompositeInfo compositeInfo = (CompositeInfo)shellInfo.getChildrenControls().get(2);
        FillLayoutTest.assertEquals((long)1L, (long)compositeInfo.getChildrenControls().size());
        ControlInfo comboInfo = (ControlInfo)compositeInfo.getChildrenControls().get(0);
        FillLayoutInfo layoutInfo = (FillLayoutInfo)compositeInfo.getLayout();
        Association labelAssociation = labelInfo.getAssociation();
        Association buttonAssociation = buttonInfo.getAssociation();
        Association comboAssociation = comboInfo.getAssociation();
        FillLayoutTest.assertNotNull((Object)labelAssociation);
        FillLayoutTest.assertNotNull((Object)buttonAssociation);
        FillLayoutTest.assertNotNull((Object)comboAssociation);
        layoutInfo.command_MOVE(buttonInfo, comboInfo);
        FillLayoutTest.assertEquals((long)2L, (long)shellInfo.getChildrenControls().size());
        FillLayoutTest.assertEquals((long)2L, (long)compositeInfo.getChildrenControls().size());
        FillLayoutTest.assertSame((Object)labelInfo, shellInfo.getChildrenControls().get(0));
        FillLayoutTest.assertSame((Object)compositeInfo, shellInfo.getChildrenControls().get(1));
        FillLayoutTest.assertSame((Object)buttonInfo, compositeInfo.getChildrenControls().get(0));
        FillLayoutTest.assertSame((Object)comboInfo, compositeInfo.getChildrenControls().get(1));
        FillLayoutTest.assertSame((Object)labelAssociation, (Object)labelInfo.getAssociation());
        FillLayoutTest.assertSame((Object)buttonAssociation, (Object)buttonInfo.getAssociation());
        FillLayoutTest.assertSame((Object)comboAssociation, (Object)comboInfo.getAssociation());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout());", "    {", "      Label label = new Label(shell, SWT.NONE);", "    }", "    {", "      Composite composite = new Composite(shell, SWT.NONE);", "      composite.setLayout(new FillLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "      {", "        Combo combo = new Combo(composite, SWT.READ_ONLY);", "      }", "    }", "  }", "}");
        layoutInfo.command_MOVE(labelInfo, null);
        FillLayoutTest.assertEquals((long)1L, (long)shellInfo.getChildrenControls().size());
        FillLayoutTest.assertEquals((long)3L, (long)compositeInfo.getChildrenControls().size());
        FillLayoutTest.assertSame((Object)compositeInfo, shellInfo.getChildrenControls().get(0));
        FillLayoutTest.assertSame((Object)buttonInfo, compositeInfo.getChildrenControls().get(0));
        FillLayoutTest.assertSame((Object)comboInfo, compositeInfo.getChildrenControls().get(1));
        FillLayoutTest.assertSame((Object)labelInfo, compositeInfo.getChildrenControls().get(2));
        FillLayoutTest.assertSame((Object)labelAssociation, (Object)labelInfo.getAssociation());
        FillLayoutTest.assertSame((Object)buttonAssociation, (Object)buttonInfo.getAssociation());
        FillLayoutTest.assertSame((Object)comboAssociation, (Object)comboInfo.getAssociation());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(shell, SWT.NONE);", "      composite.setLayout(new FillLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "      {", "        Combo combo = new Combo(composite, SWT.READ_ONLY);", "      }", "      {", "        Label label = new Label(composite, SWT.NONE);", "      }", "    }", "  }", "}");
    }
}

