/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.JDialogInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class JDialogTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_0() throws Exception {
        JDialogInfo dialog = (JDialogInfo)this.parseContainer("public class Test extends JDialog {", "  public Test() {", "  }", "}");
        JDialogTest.assertHierarchy("{this: javax.swing.JDialog} {this} {}", "  {method: public java.awt.Container javax.swing.JDialog.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
        dialog.refresh();
        JDialogTest.assertNoErrors((JavaInfo)dialog);
        ComponentInfo contentPane = (ComponentInfo)dialog.getChildrenComponents().get(0);
        Rectangle bounds = dialog.getBounds();
        JDialogTest.assertEquals((long)bounds.width, (long)450L);
        JDialogTest.assertEquals((long)bounds.height, (long)300L);
        bounds = contentPane.getBounds();
        Assertions.assertThat((int)bounds.x).isGreaterThanOrEqualTo(0);
        Assertions.assertThat((int)bounds.y).isGreaterThanOrEqualTo(0);
        Assertions.assertThat((int)bounds.width).isGreaterThan(420);
        Assertions.assertThat((int)bounds.height).isGreaterThan(250);
    }

    @Test
    public void test_parseWithout_getContentPane_this() throws Exception {
        this.parseJavaInfo("public class Test extends JDialog {", "  public Test() {", "    setModal(true);", "    setLayout(new FlowLayout());", "    {", "      JButton button = new JButton();", "      this.add(button);", "    }", "  }", "}");
        this.assertEditor("public class Test extends JDialog {", "  public Test() {", "    setModal(true);", "    getContentPane().setLayout(new FlowLayout());", "    {", "      JButton button = new JButton();", "      getContentPane().add(button);", "    }", "  }", "}");
        JDialogTest.assertHierarchy("{this: javax.swing.JDialog} {this} {/setModal(true)/}", "  {method: public java.awt.Container javax.swing.JDialog.getContentPane()} {property} {/getContentPane().setLayout(new FlowLayout())/ /getContentPane().add(button)/}", "    {new: java.awt.FlowLayout} {empty} {/getContentPane().setLayout(new FlowLayout())/}", "    {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /getContentPane().add(button)/}");
    }

    @Test
    public void test_parseWithout_getContentPane_instance() throws Exception {
        this.parseJavaInfo("public class Test {", "  public static void main(String[] args) {", "    JDialog dialog = new JDialog();", "    dialog.setLayout(new FlowLayout());", "    {", "      JButton button = new JButton();", "      dialog.add(button);", "    }", "  }", "}");
        this.assertEditor("public class Test {", "  public static void main(String[] args) {", "    JDialog dialog = new JDialog();", "    dialog.getContentPane().setLayout(new FlowLayout());", "    {", "      JButton button = new JButton();", "      dialog.getContentPane().add(button);", "    }", "  }", "}");
        JDialogTest.assertHierarchy("{new: javax.swing.JDialog} {local-unique: dialog} {/new JDialog()/ /dialog.getContentPane()/ /dialog.getContentPane()/}", "  {method: public java.awt.Container javax.swing.JDialog.getContentPane()} {property} {/dialog.getContentPane().setLayout(new FlowLayout())/ /dialog.getContentPane().add(button)/}", "    {new: java.awt.FlowLayout} {empty} {/dialog.getContentPane().setLayout(new FlowLayout())/}", "    {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /dialog.getContentPane().add(button)/}");
    }

    @Test
    public void test_rewrite_setLayout_noCorrectSignature() throws Exception {
        this.parseJavaInfo("public class Test extends JDialog {", "  public Test() {", "    setLayout();", "  }", "  private void setLayout() {", "    getContentPane().setLayout(new FlowLayout());", "  }", "}");
        this.assertEditor("public class Test extends JDialog {", "  public Test() {", "    setLayout();", "  }", "  private void setLayout() {", "    getContentPane().setLayout(new FlowLayout());", "  }", "}");
        JDialogTest.assertHierarchy("{this: javax.swing.JDialog} {this} {}", "  {method: public java.awt.Container javax.swing.JDialog.getContentPane()} {property} {/getContentPane().setLayout(new FlowLayout())/}", "    {new: java.awt.FlowLayout} {empty} {/getContentPane().setLayout(new FlowLayout())/}");
    }

    @Test
    public void test_rewrite_setLayout_ofInnerJPanel() throws Exception {
        this.parseJavaInfo("public class Test extends JDialog {", "  private static class Inner extends JPanel {", "    public Inner() {", "      setLayout(new FlowLayout());", "    }", "  }", "  public Test() {", "  }", "}");
        this.assertEditor("public class Test extends JDialog {", "  private static class Inner extends JPanel {", "    public Inner() {", "      setLayout(new FlowLayout());", "    }", "  }", "  public Test() {", "  }", "}");
        JDialogTest.assertHierarchy("{this: javax.swing.JDialog} {this} {}", "  {method: public java.awt.Container javax.swing.JDialog.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
    }

    @Test
    public void test_rewrite_owner() throws Exception {
        JDialogInfo dialog = (JDialogInfo)this.parseContainer("public class Test extends JDialog {\n\tpublic Test() {\n\t\tsuper(new JFrame());\n\t}\n}\n");
        JDialogTest.assertHierarchy("{this: javax.swing.JDialog} {this} {}", "  {method: public java.awt.Container javax.swing.JDialog.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
        dialog.refresh();
        JDialogTest.assertNoErrors((JavaInfo)dialog);
    }
}

