/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing;

import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoTest;
import org.junit.Before;

public abstract class SwingModelTest
extends AbstractJavaInfoTest {
    private boolean m_convertSingleQuotesToDouble = true;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            SwingModelTest.do_projectCreate();
            this.configureNewProject();
        }
    }

    @Override
    protected void configureToolkits() {
        super.configureToolkits();
        SwingModelTest.configureDefaults(ToolkitProvider.DESCRIPTION);
    }

    protected void configureNewProject() throws Exception {
    }

    public void dontConvertSingleQuotesToDouble() {
        this.m_convertSingleQuotesToDouble = false;
    }

    protected final <T extends JavaInfo> T parseJavaInfo(String ... lines) throws Exception {
        return (T)this.parseSource("test", "Test.java", this.getTestSource(lines));
    }

    public final ContainerInfo parseContainer(String ... lines) throws Exception {
        return (ContainerInfo)this.parseJavaInfo(lines);
    }

    public final void assertEditor(String ... lines) {
        SwingModelTest.assertEditor(this.getTestSource(lines), this.m_lastEditor);
    }

    public String getTestSource(String ... lines) {
        if (this.m_convertSingleQuotesToDouble) {
            lines = SwingModelTest.getDoubleQuotes(lines);
        }
        lines = CodeUtils.join((String[])new String[]{"package test;", "import java.awt.*;", "import java.awt.event.*;", "import javax.swing.*;", "import javax.swing.border.*;"}, (String[])lines);
        return SwingModelTest.getSource(lines);
    }

    public final void setJavaContentSrc(String packageName, String className, String[] source, String[] meta) throws Exception {
        SwingModelTest.setFileContentSrc(packageName, className + ".java", this.getTestSource(source));
        if (meta != null) {
            SwingModelTest.setFileContentSrc(packageName, className + ".wbp-component.xml", SwingModelTest.getSource(meta));
        }
        SwingModelTest.waitForAutoBuild();
    }

    protected static ComponentInfo createComponent(Class<?> componentClass) throws Exception {
        return SwingModelTest.createComponent(componentClass.getName());
    }

    public static ComponentInfo createComponent(String componentClassName) throws Exception {
        return (ComponentInfo)SwingModelTest.createJavaInfo(componentClassName);
    }

    public static ComponentInfo createJButton() throws Exception {
        return (ComponentInfo)SwingModelTest.createJavaInfo("javax.swing.JButton", "empty");
    }

    protected final void prepareMyComponent(String ... lines) throws Exception {
        this.prepareMyComponent(lines, ArrayUtils.EMPTY_STRING_ARRAY);
    }

    protected final void prepareMyComponent(String[] javaLines, String[] descriptionLines) throws Exception {
        String[] lines = new String[]{"package test;", "import javax.swing.JPanel;", "// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyComponent extends JPanel {", "  public MyComponent() {", "  }"};
        lines = CodeUtils.join((String[])lines, (String[])javaLines);
        lines = CodeUtils.join((String[])lines, (String[])new String[]{"}"});
        SwingModelTest.setFileContentSrc("test/MyComponent.java", SwingModelTest.getSourceDQ(lines));
        lines = new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>"};
        descriptionLines = SwingModelTest.removeFillerLines(descriptionLines);
        lines = CodeUtils.join((String[])lines, (String[])descriptionLines);
        lines = CodeUtils.join((String[])lines, (String[])new String[]{"</component>"});
        SwingModelTest.setFileContentSrc("test/MyComponent.wbp-component.xml", SwingModelTest.getSourceDQ(lines));
        SwingModelTest.waitForAutoBuild();
    }
}

