/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.nebula;

import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.association.InvocationVoidAssociation;
import org.eclipse.wb.internal.core.model.creation.factory.ImplicitFactoryCreationSupport;
import org.eclipse.wb.internal.rcp.nebula.collapsiblebuttons.CollapsibleButtonsInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.nebula.AbstractNebulaTest;
import org.junit.Test;

public class CollapsibleButtonsTest
extends AbstractNebulaTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_General() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.nebula.widgets.collapsiblebuttons.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CollapsibleButtons collapsibleButtons = new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT);", "    {", "    \tCustomButton customButton = collapsibleButtons.addButton('Copy', 'New CollapsibleButton', null, null);", "    }", "  }", "}");
        CollapsibleButtonsTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: org.eclipse.nebula.widgets.collapsiblebuttons.CollapsibleButtons} {local-unique: collapsibleButtons} {/new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT)/ /collapsibleButtons.addButton('Copy', 'New CollapsibleButton', null, null)/}", "    {implicit-factory} {local-unique: customButton} {/collapsibleButtons.addButton('Copy', 'New CollapsibleButton', null, null)/}");
        shell.refresh();
        CollapsibleButtonsInfo collapsibleButtons = (CollapsibleButtonsInfo)shell.getChildren(CollapsibleButtonsInfo.class).get(0);
        ControlInfo button = (ControlInfo)collapsibleButtons.getChildrenControls().get(0);
        CollapsibleButtonsTest.assertEquals((Object)"org.eclipse.nebula.widgets.collapsiblebuttons.CustomButton", (Object)button.getDescription().getComponentClass().getName());
        CollapsibleButtonsTest.assertInstanceOf(ImplicitFactoryCreationSupport.class, (Object)button.getCreationSupport());
        CollapsibleButtonsTest.assertInstanceOf(InvocationVoidAssociation.class, (Object)button.getAssociation());
        Rectangle bounds = button.getBounds();
        Assertions.assertThat((int)bounds.width).isGreaterThan(100);
        Assertions.assertThat((int)bounds.height).isGreaterThan(20);
    }

    @Test
    public void test_createButton() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.nebula.widgets.collapsiblebuttons.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CollapsibleButtons collapsibleButtons = new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT);", "    {", "    \tCustomButton customButton = collapsibleButtons.addButton('Copy', 'New CollapsibleButton', null, null);", "    }", "  }", "}");
        CollapsibleButtonsInfo collapsibleButtons = (CollapsibleButtonsInfo)shell.getChildren(CollapsibleButtonsInfo.class).get(0);
        CollapsibleButtonsTest.assertEquals((long)1L, (long)collapsibleButtons.getChildrenControls().size());
        ControlInfo button_new = CollapsibleButtonsInfo.createButton((CollapsibleButtonsInfo)collapsibleButtons, null);
        this.assertEditor("import org.eclipse.nebula.widgets.collapsiblebuttons.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CollapsibleButtons collapsibleButtons = new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT);", "    {", "    \tCustomButton customButton = collapsibleButtons.addButton('Copy', 'New CollapsibleButton', null, null);", "    }", "    {", "    \tCustomButton customButton = collapsibleButtons.addButton('New Button', 'New CollapsibleButton', null, null);", "    }", "  }", "}");
        CollapsibleButtonsTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: org.eclipse.nebula.widgets.collapsiblebuttons.CollapsibleButtons} {local-unique: collapsibleButtons} {/new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT)/ /collapsibleButtons.addButton('Copy', 'New CollapsibleButton', null, null)/ /collapsibleButtons.addButton('New Button', 'New CollapsibleButton', null, null)/}", "    {implicit-factory} {local-unique: customButton} {/collapsibleButtons.addButton('Copy', 'New CollapsibleButton', null, null)/}", "    {implicit-factory} {local-unique: customButton} {/collapsibleButtons.addButton('New Button', 'New CollapsibleButton', null, null)/}");
        CollapsibleButtonsTest.assertInstanceOf(ImplicitFactoryCreationSupport.class, (Object)button_new.getCreationSupport());
        CollapsibleButtonsTest.assertInstanceOf(InvocationVoidAssociation.class, (Object)button_new.getAssociation());
    }

    @Test
    public void test_moveButton() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.nebula.widgets.collapsiblebuttons.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CollapsibleButtons collapsibleButtons = new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT);", "    {", "    \tCustomButton customButton = collapsibleButtons.addButton('B1', 'New CollapsibleButton', null, null);", "    }", "    {", "    \tCustomButton customButton = collapsibleButtons.addButton('B2', 'New CollapsibleButton', null, null);", "    }", "  }", "}");
        CollapsibleButtonsTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: org.eclipse.nebula.widgets.collapsiblebuttons.CollapsibleButtons} {local-unique: collapsibleButtons} {/new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT)/ /collapsibleButtons.addButton('B1', 'New CollapsibleButton', null, null)/ /collapsibleButtons.addButton('B2', 'New CollapsibleButton', null, null)/}", "    {implicit-factory} {local-unique: customButton} {/collapsibleButtons.addButton('B1', 'New CollapsibleButton', null, null)/}", "    {implicit-factory} {local-unique: customButton} {/collapsibleButtons.addButton('B2', 'New CollapsibleButton', null, null)/}");
        CollapsibleButtonsInfo collapsibleButtons = (CollapsibleButtonsInfo)shell.getChildren(CollapsibleButtonsInfo.class).get(0);
        CollapsibleButtonsTest.assertEquals((long)2L, (long)collapsibleButtons.getChildrenControls().size());
        ControlInfo button_1 = (ControlInfo)collapsibleButtons.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)collapsibleButtons.getChildrenControls().get(1);
        CollapsibleButtonsInfo.moveButton((ControlInfo)button_2, (ControlInfo)button_1);
        CollapsibleButtonsTest.assertEquals((long)0L, (long)collapsibleButtons.getChildrenControls().indexOf(button_2));
        CollapsibleButtonsTest.assertEquals((long)1L, (long)collapsibleButtons.getChildrenControls().indexOf(button_1));
        this.assertEditor("import org.eclipse.nebula.widgets.collapsiblebuttons.*;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    CollapsibleButtons collapsibleButtons = new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT);", "    {", "    \tCustomButton customButton = collapsibleButtons.addButton('B2', 'New CollapsibleButton', null, null);", "    }", "    {", "    \tCustomButton customButton = collapsibleButtons.addButton('B1', 'New CollapsibleButton', null, null);", "    }", "  }", "}");
        CollapsibleButtonsTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: org.eclipse.nebula.widgets.collapsiblebuttons.CollapsibleButtons} {local-unique: collapsibleButtons} {/new CollapsibleButtons(this, SWT.NONE, IColorManager.SKIN_AUTO_DETECT)/ /collapsibleButtons.addButton('B1', 'New CollapsibleButton', null, null)/ /collapsibleButtons.addButton('B2', 'New CollapsibleButton', null, null)/}", "    {implicit-factory} {local-unique: customButton} {/collapsibleButtons.addButton('B2', 'New CollapsibleButton', null, null)/}", "    {implicit-factory} {local-unique: customButton} {/collapsibleButtons.addButton('B1', 'New CollapsibleButton', null, null)/}");
    }
}

