/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.variable.ThisVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ThisForcedMethodTest
extends SwingModelTest {
    private static final IPreferenceStore PREFERENCES = ToolkitProvider.DESCRIPTION.getPreferences();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        PREFERENCES.setValue("codeGeneration.forcedMethod", "init");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        PREFERENCES.setToDefault("codeGeneration.forcedMethod");
        super.tearDown();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getTarget_bad_rootIsNotThis() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        this.assertEditor("public class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "  }", "}");
        Statement expectedStatement = ThisForcedMethodTest.getStatement((JavaInfo)panel, "main(java.lang.String[])", 0);
        ThisForcedMethodTest.assertTarget(target, null, expectedStatement, false);
    }

    @Test
    public void test_getTarget_bad_notInitMethod() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    otherMethod();", "  }", "  private void otherMethod() {", "    setBackground(Color.ORANGE);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    otherMethod();", "  }", "  private void otherMethod() {", "    setBackground(Color.ORANGE);", "  }", "}");
        Statement expectedStatement = ThisForcedMethodTest.getStatement((JavaInfo)panel, "otherMethod()", 0);
        ThisForcedMethodTest.assertTarget(target, null, expectedStatement, false);
    }

    @Test
    public void test_getTarget_emptyConstructor() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    init();", "  }", "  private void init() {", "  }", "}");
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, false);
    }

    @Test
    public void test_getTarget_withSuper() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    super();", "    setBackground(Color.ORANGE);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    super();", "    init();", "  }", "  private void init() {", "    setBackground(Color.ORANGE);", "  }", "}");
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, false);
    }

    @Test
    public void test_getTarget_withChild() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    super();", "    int hgap = 5;", "    int vgap = 10;", "    setLayout(new BorderLayout(hgap, vgap));", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    super();", "    init();", "  }", "  private void init() {", "    int hgap = 5;", "    int vgap = 10;", "    setLayout(new BorderLayout(hgap, vgap));", "  }", "}");
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, false);
    }

    @Test
    public void test_getTarget_askForContentPane() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    super();", "    getContentPane().setBackground(Color.ORANGE);", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)contentPane, null);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    super();", "    init();", "  }", "  private void init() {", "    getContentPane().setBackground(Color.ORANGE);", "  }", "}");
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, false);
    }

    @Test
    public void test_getTarget_askForContentPane_setContentPane() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  JPanel contentPane = new JPanel();", "  public Test() {", "    setContentPane(contentPane);", "    contentPane.setBackground(Color.ORANGE);", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)contentPane, null);
        this.assertEditor("public class Test extends JFrame {", "  JPanel contentPane = new JPanel();", "  public Test() {", "    init();", "  }", "  private void init() {", "    setContentPane(contentPane);", "    contentPane.setBackground(Color.ORANGE);", "  }", "}");
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, false);
    }

    @Test
    public void test_getTarget_existingFilled() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    init();", "  }", "  private void init() {", "    setEnabled(true);", "    int foo;", "  }", "}");
        String expectedSource = this.m_lastEditor.getSource();
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        ThisForcedMethodTest.assertEditor(expectedSource, this.m_lastEditor);
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, false);
    }

    @Test
    public void test_getTarget_existingEmpty() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    init();", "  }", "  private void init() {", "  }", "}");
        String expectedSource = this.m_lastEditor.getSource();
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        ThisForcedMethodTest.assertEditor(expectedSource, this.m_lastEditor);
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, false);
    }

    @Test
    public void test_getTarget_existingEmpty_tryStatement() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    try {", "      init();", "    } catch (Throwable e) {", "    }", "  }", "  private void init() {", "  }", "}");
        String expectedSource = this.m_lastEditor.getSource();
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        ThisForcedMethodTest.assertEditor(expectedSource, this.m_lastEditor);
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, false);
    }

    @Test
    public void test_getTarget_existingEmpty_withDifferentName() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    init2();", "  }", "  private void init2() {", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    init();", "  }", "  private void init() {", "    init2();", "  }", "  private void init2() {", "  }", "}");
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, false);
    }

    @Test
    public void test_getTarget_lazy() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JPanel inner;", "  public Test() {", "    init();", "  }", "  private void init() {", "    add(getInner());", "  }", "  private JPanel getInner() {", "    if (inner == null) {", "      inner = new JPanel();", "    }", "    return inner;", "  }", "}");
        panel.refresh();
        ContainerInfo inner = (ContainerInfo)ThisForcedMethodTest.getJavaInfoByName("inner");
        String expectedSource = this.m_lastEditor.getSource();
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)inner, null);
        ThisForcedMethodTest.assertEditor(expectedSource, this.m_lastEditor);
        ThisForcedMethodTest.assertTarget(target, null, ThisForcedMethodTest.getStatement((JavaInfo)inner, 0), false);
    }

    @Test
    public void test_getTarget_forInnerContainer() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    init();", "  }", "  private void init() {", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "    }", "  }", "}");
        panel.refresh();
        ContainerInfo inner = (ContainerInfo)ThisForcedMethodTest.getJavaInfoByName("inner");
        String expectedSource = this.m_lastEditor.getSource();
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)inner, null);
        ThisForcedMethodTest.assertEditor(expectedSource, this.m_lastEditor);
        ThisForcedMethodTest.assertTarget(target, null, ThisForcedMethodTest.getStatement((JavaInfo)inner, 1), false);
    }

    @Test
    public void test_getStatementTarget_emptyConstructor() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ThisVariableSupport variableSupport = (ThisVariableSupport)panel.getVariableSupport();
        StatementTarget target = variableSupport.getStatementTarget();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    init();", "  }", "  private void init() {", "  }", "}");
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, true);
    }

    @Test
    public void test_getStatementTarget_filledConstructor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "  }", "}");
        ThisVariableSupport variableSupport = (ThisVariableSupport)panel.getVariableSupport();
        StatementTarget target = variableSupport.getStatementTarget();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    init();", "  }", "  private void init() {", "    setEnabled(true);", "  }", "}");
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, true);
    }

    @Test
    public void test_getStatementTarget_existingForced() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    init();", "  }", "  private void init() {", "    setEnabled(false);", "  }", "}");
        String expectedSource = this.m_lastEditor.getSource();
        ThisVariableSupport variableSupport = (ThisVariableSupport)panel.getVariableSupport();
        StatementTarget target = variableSupport.getStatementTarget();
        ThisForcedMethodTest.assertEditor(expectedSource, this.m_lastEditor);
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, true);
    }

    @Test
    public void test_getStatementTarget_existingForced_withSuper() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    super();", "    init();", "  }", "  private void init() {", "    setEnabled(false);", "  }", "}");
        String expectedSource = this.m_lastEditor.getSource();
        ThisVariableSupport variableSupport = (ThisVariableSupport)panel.getVariableSupport();
        StatementTarget target = variableSupport.getStatementTarget();
        ThisForcedMethodTest.assertEditor(expectedSource, this.m_lastEditor);
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, true);
    }

    @Test
    public void test_getStatementTarget_existingForced_otherStatements() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int foo;", "    int bar;", "    init();", "  }", "  private void init() {", "    setEnabled(false);", "  }", "}");
        String expectedSource = this.m_lastEditor.getSource();
        ThisVariableSupport variableSupport = (ThisVariableSupport)panel.getVariableSupport();
        StatementTarget target = variableSupport.getStatementTarget();
        ThisForcedMethodTest.assertEditor(expectedSource, this.m_lastEditor);
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, true);
    }

    @Test
    public void test_getStatementTarget_fieldInitializer() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JButton button = new JButton();", "  public Test() {", "    add(button);", "  }", "}");
        ThisVariableSupport variableSupport = (ThisVariableSupport)panel.getVariableSupport();
        StatementTarget target = variableSupport.getStatementTarget();
        this.assertEditor("public class Test extends JPanel {", "  private final JButton button = new JButton();", "  public Test() {", "    init();", "  }", "  private void init() {", "    add(button);", "  }", "}");
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, true);
    }

    @Test
    public void test_getStatementTarget_constructorParameters() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test(int a) {", "    System.out.println(a);", "    int foo;", "  }", "}");
        ThisVariableSupport variableSupport = (ThisVariableSupport)panel.getVariableSupport();
        StatementTarget target = variableSupport.getStatementTarget();
        this.assertEditor("public class Test extends JPanel {", "  public Test(int a) {", "    System.out.println(a);", "    init();", "  }", "  private void init() {", "    int foo;", "  }", "}");
        ThisForcedMethodTest.assertTarget(target, this.getMethod("init()").getBody(), null, true);
    }
}

