/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.mockito.Mockito;

public abstract class AbstractTextPropertyEditorTest
extends SwingModelTest {
    protected static void assert_getText(String expectedText, TextDisplayPropertyEditor editor, Object value) throws Exception {
        String actualText = (String)AbstractTextPropertyEditorTest.callMethodWithPropertyValue("getText(org.eclipse.wb.internal.core.model.property.Property)", editor, value);
        AbstractTextPropertyEditorTest.assertEquals((Object)expectedText, (Object)actualText);
    }

    protected static void assert_getEditorText(String expectedText, TextDisplayPropertyEditor editor, Object value) throws Exception {
        String actualText = (String)AbstractTextPropertyEditorTest.callMethodWithPropertyValue("getEditorText(org.eclipse.wb.internal.core.model.property.Property)", editor, value);
        AbstractTextPropertyEditorTest.assertEquals((Object)expectedText, (Object)actualText);
    }

    protected static void assert_getClipboardSource(String expectedSource, TextDisplayPropertyEditor editor, Object value) throws Exception {
        String actualSource = (String)AbstractTextPropertyEditorTest.callMethodWithPropertyValue("getClipboardSource(org.eclipse.wb.internal.core.model.property.GenericProperty)", editor, value);
        AbstractTextPropertyEditorTest.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    private static Object callMethodWithPropertyValue(String signature, TextDisplayPropertyEditor editor, Object value) throws Exception {
        GenericProperty property = (GenericProperty)Mockito.mock(GenericProperty.class);
        Mockito.when((Object)property.getValue()).thenReturn(value);
        Object result = ReflectionUtils.invokeMethod((Object)editor, (String)signature, (Object[])new Object[]{property});
        ((GenericProperty)Mockito.verify((Object)property)).getValue();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{property});
        return result;
    }

    protected static void assertContainsOnly(Object editor, String fieldName, List<?> expected) throws Exception {
        Assertions.assertThat((Object[])((Object[])AbstractTextPropertyEditorTest.getFieldValue(editor, fieldName))).containsOnly(expected.toArray());
    }

    protected void initTestSourceState() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    protected <T extends TextDisplayPropertyEditor> T createEditor(Class<T> clazz, Map<String, Object> parameters) throws Exception {
        this.initTestSourceState();
        TextDisplayPropertyEditor editor = (TextDisplayPropertyEditor)clazz.newInstance();
        IConfigurablePropertyObject configurableEditor = (IConfigurablePropertyObject)editor;
        configurableEditor.configure(this.m_lastState, parameters);
        return (T)editor;
    }
}

