/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescriptionJava;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.swing.Activator;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;

public class ToolkitDescriptionTest
extends DesignerTestCase {
    @Test
    public void test_ToolkitDescription() throws Exception {
        ToolkitDescriptionJava toolkit = ToolkitProvider.DESCRIPTION;
        ToolkitDescriptionTest.assertEquals((Object)"org.eclipse.wb.swing", (Object)toolkit.getId());
        ToolkitDescriptionTest.assertEquals((Object)"Swing toolkit", (Object)toolkit.getName());
        ToolkitDescriptionTest.assertEquals((Object)Platform.getBundle((String)"org.eclipse.wb.swing"), (Object)toolkit.getBundle());
        ToolkitDescriptionTest.assertSame((Object)Activator.getDefault().getPreferenceStore(), (Object)toolkit.getPreferences());
        GenerationSettings generationSettings = toolkit.getGenerationSettings();
        ToolkitDescriptionTest.assertNotNull((Object)generationSettings);
        Assertions.assertThat((Object[])generationSettings.getVariables()).isNotEmpty();
    }

    @Test
    public void test_getToolkitElements() throws Exception {
        HashSet<String> toolkitIds = new HashSet<String>();
        List toolkitElements = DescriptionHelper.getToolkitElements();
        for (IConfigurationElement toolkitElement : toolkitElements) {
            toolkitIds.add(toolkitElement.getAttribute("id"));
        }
        ToolkitDescriptionTest.assertTrue((boolean)toolkitIds.contains("org.eclipse.wb.core"));
        ToolkitDescriptionTest.assertTrue((boolean)toolkitIds.contains("org.eclipse.wb.swing"));
        ToolkitDescriptionTest.assertFalse((boolean)toolkitIds.contains("no-such-toolkit-id"));
    }

    @Test
    public void test_getToolkitElements_forSingleToolkit() throws Exception {
        String toolkitId = "org.eclipse.wb.swing";
        for (IConfigurationElement toolkitElement : DescriptionHelper.getToolkitElements((String)toolkitId)) {
            ToolkitDescriptionTest.assertEquals((Object)toolkitId, (Object)ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)toolkitElement, (String)"id"));
        }
    }

    @Test
    public void test_getToolkit() throws Exception {
        ToolkitDescriptionTest.assertSame((Object)ToolkitProvider.DESCRIPTION, (Object)DescriptionHelper.getToolkit((String)"org.eclipse.wb.swing"));
        try {
            DescriptionHelper.getToolkit((String)"no-such-toolkit-id");
            ToolkitDescriptionTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_getToolkits() throws Exception {
        Object[] toolkits = DescriptionHelper.getToolkits();
        Assertions.assertThat((Object[])toolkits).contains((Object[])new ToolkitDescription[]{org.eclipse.wb.internal.core.ToolkitProvider.DESCRIPTION, ToolkitProvider.DESCRIPTION, org.eclipse.wb.internal.rcp.ToolkitProvider.DESCRIPTION});
    }
}

