/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.AbstractJavaProjectTest;
import org.junit.After;

public abstract class AbstractJavaTest
extends AbstractJavaProjectTest {
    protected boolean m_ignoreModelCompileProblems = false;
    protected ICompilationUnit m_lastModelUnit;
    protected AstEditor m_lastEditor;

    @Override
    @After
    public void tearDown() throws Exception {
        this.m_ignoreModelCompileProblems = false;
        this.m_lastEditor = null;
        this.m_lastModelUnit = null;
        super.tearDown();
    }

    protected static final Statement getStatement(Block block, int ... indexes) {
        Block statement = block;
        int i = 0;
        while (i < indexes.length) {
            int index = indexes[i];
            if (index != -1) {
                Block nextBlock = statement instanceof IfStatement ? (Block)((IfStatement)statement).getThenStatement() : statement;
                statement = (Statement)nextBlock.statements().get(index);
            }
            ++i;
        }
        return statement;
    }

    protected final <T extends ASTNode> T getNode(String src, Class<T> clazz) {
        ASTNode enclosingNode = this.m_lastEditor.getEnclosingNode(src);
        return (T)((ASTNode)AstNodeUtils.getEnclosingNode((ASTNode)enclosingNode, clazz));
    }

    protected final <T extends ASTNode> T getNode(String src) {
        return (T)this.m_lastEditor.getEnclosingNode(src);
    }

    protected final MethodDeclaration getMethod(String methodSignature) {
        TypeDeclaration typeDeclaration = (TypeDeclaration)DomGenerics.types((CompilationUnit)this.m_lastEditor.getAstUnit()).get(0);
        return AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)methodSignature);
    }

    protected static Object getFieldValue(Object o, String fieldName) throws Exception {
        return ReflectionUtils.getFieldObject((Object)o, (String)fieldName);
    }

    protected final TypeDeclaration createTypeDeclaration_TestC(String code) throws Exception {
        String source = "package test;public class Test{" + code + "}";
        CompilationUnit astUnit = this.createASTCompilationUnit("test", "Test.java", source);
        AbstractJavaTest.assertEquals((long)1L, (long)astUnit.types().size());
        return (TypeDeclaration)astUnit.types().get(0);
    }

    protected final TypeDeclaration createTypeDeclaration_TestD(String ... lines) throws Exception {
        String source = AbstractJavaTest.getSource(lines);
        CompilationUnit astUnit = this.createASTCompilationUnit("test", "Test.java", source);
        AbstractJavaTest.assertEquals((long)1L, (long)astUnit.types().size());
        return (TypeDeclaration)astUnit.types().get(0);
    }

    protected final TypeDeclaration createTypeDeclaration_Test(String code) throws Exception {
        String source = "package test;\n" + code;
        CompilationUnit astUnit = this.createASTCompilationUnit("test", "Test.java", source);
        AbstractJavaTest.assertEquals((long)1L, (long)astUnit.types().size());
        return (TypeDeclaration)astUnit.types().get(0);
    }

    protected final TypeDeclaration createTypeDeclaration(String packageName, String unitName, String source) throws Exception {
        CompilationUnit compilationUnit = this.createASTCompilationUnit(packageName, unitName, source);
        return (TypeDeclaration)compilationUnit.types().get(0);
    }

    protected final CompilationUnit createASTCompilationUnit(String packageName, String unitName, String code) throws Exception {
        ICompilationUnit modelUnit = this.createModelCompilationUnit(packageName, unitName, code);
        return this.createASTCompilationUnit(modelUnit);
    }

    protected final CompilationUnit createASTCompilationUnit(ICompilationUnit modelUnit) throws Exception {
        AstEditor editor = new AstEditor(modelUnit);
        AbstractJavaTest.assertSame((Object)modelUnit, (Object)editor.getModelUnit());
        CompilationUnit astUnit = editor.getAstUnit();
        AbstractJavaTest.assertNotNull((Object)astUnit);
        if (!this.m_ignoreModelCompileProblems) {
            IProblem[] problems = astUnit.getProblems();
            int i = 0;
            while (i < problems.length) {
                IProblem problem = problems[i];
                if (problem.isError()) {
                    AbstractJavaTest.fail((String)("Error found: " + String.valueOf(problem)));
                }
                ++i;
            }
        }
        this.m_lastModelUnit = modelUnit;
        this.m_lastEditor = editor;
        return astUnit;
    }

    protected static final VariableDeclaration getFieldFragment(TypeDeclaration typeDeclaration, int fieldIndex) {
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[fieldIndex];
        return (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
    }

    protected static void assertRelatedNodes(JavaInfo javaInfo, String[] sourceTightlyNodes) throws Exception {
        List nodes = javaInfo.getRelatedNodes();
        AbstractJavaTest.assertEquals((String)(StringUtils.join((Object[])sourceTightlyNodes, (String)", ") + " != " + StringUtils.join(nodes.iterator(), (String)", ")), (long)sourceTightlyNodes.length, (long)nodes.size());
        int i = 0;
        while (i < nodes.size()) {
            ASTNode node = (ASTNode)nodes.get(i);
            ASTNode sourceNode = JavaInfo.getRelatedNodeForSource((ASTNode)node);
            AbstractJavaTest.assertEquals((Object)sourceTightlyNodes[i], (Object)javaInfo.getEditor().getSource(sourceNode));
            ++i;
        }
    }

    protected static void assertEditor(String expectedSource, AstEditor editor) {
        AbstractJavaTest.assertEquals((Object)expectedSource, (Object)editor.getSource());
        AbstractJavaTest.assertAST(editor);
    }

    protected static void assertAST(final AstEditor editor) {
        final AST editorAST = editor.getAstUnit().getAST();
        editor.getAstUnit().accept(new ASTVisitor(true){

            public void endVisit(SimpleName node) {
                MethodInvocation invocation;
                IMethodBinding binding;
                AbstractJavaTest.assertEquals((Object)node.getIdentifier(), (Object)this.getSource((ASTNode)node));
                boolean isVariable = false;
                if (node.getParent() instanceof MethodInvocation && !Modifier.isStatic((int)(binding = AstNodeUtils.getMethodBinding((MethodInvocation)(invocation = (MethodInvocation)node.getParent()))).getModifiers())) {
                    isVariable |= invocation.getExpression() == node;
                    isVariable |= invocation.arguments().contains(node);
                }
                if (isVariable |= node.getParent() instanceof InfixExpression) {
                    IVariableBinding variableBinding = AstNodeUtils.getVariableBinding((ASTNode)node);
                    AbstractJavaTest.assertNotNull((Object)variableBinding);
                    AbstractJavaTest.assertNotNull((Object)variableBinding.getType());
                }
            }

            public void endVisit(TextElement node) {
                AbstractJavaTest.assertEquals((Object)node.getText(), (Object)this.getSource((ASTNode)node));
            }

            public void endVisit(NumberLiteral node) {
                AbstractJavaTest.assertEquals((Object)node.getToken(), (Object)this.getSource((ASTNode)node));
            }

            public void endVisit(VariableDeclarationFragment node) {
                SimpleName name = node.getName();
                AbstractJavaTest.assertEquals((long)name.getStartPosition(), (long)node.getStartPosition());
            }

            public void preVisit(ASTNode node) {
                ImportDeclaration declaration;
                AbstractJavaTest.assertSame((Object)editorAST, (Object)node.getAST());
                ASTNode parent = node.getParent();
                if (parent != null && !(node instanceof Dimension)) {
                    int begin = AstNodeUtils.getSourceBegin((ASTNode)node);
                    int end = AstNodeUtils.getSourceEnd((ASTNode)node);
                    int parent_begin = AstNodeUtils.getSourceBegin((ASTNode)parent);
                    int parent_end = AstNodeUtils.getSourceEnd((ASTNode)parent);
                    AbstractJavaTest.assertTrue((begin >= parent_begin ? 1 : 0) != 0);
                    AbstractJavaTest.assertTrue((end <= parent_end ? 1 : 0) != 0);
                }
                if (node instanceof ImportDeclaration && !(declaration = (ImportDeclaration)node).isOnDemand()) {
                    AbstractJavaTest.assertNotNull((Object)AstNodeUtils.getTypeBinding((Expression)declaration.getName()));
                }
                if (node instanceof Type) {
                    Type type = (Type)node;
                    AbstractJavaTest.assertNotNull((Object)AstNodeUtils.getTypeBinding((Type)type));
                }
                if (node instanceof VariableDeclaration) {
                    VariableDeclaration declaration2 = (VariableDeclaration)node;
                    AbstractJavaTest.assertNotNull((Object)AstNodeUtils.getTypeBinding((Expression)declaration2.getName()));
                    if (declaration2.getInitializer() != null) {
                        AbstractJavaTest.assertNotNull((Object)AstNodeUtils.getTypeBinding((Expression)declaration2.getInitializer()));
                    }
                }
                if (node instanceof MethodInvocation) {
                    MethodInvocation invocation = (MethodInvocation)node;
                    IMethodBinding methodBinding = AstNodeUtils.getMethodBinding((MethodInvocation)invocation);
                    AbstractJavaTest.assertNotNull((Object)methodBinding);
                    AbstractJavaTest.assertEquals((Object)invocation.getName().getIdentifier(), (Object)methodBinding.getName());
                    ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
                    List arguments = invocation.arguments();
                    int i = 0;
                    while (i < parameterTypes.length) {
                        Expression argument;
                        String argumentClassName;
                        ITypeBinding parameterType = parameterTypes[i];
                        if (i == parameterTypes.length - 1 && parameterType.isArray()) {
                            if (i == arguments.size() || AstNodeUtils.isSuccessorOf((ITypeBinding)parameterType, (String)(argumentClassName = AstNodeUtils.getFullyQualifiedName((Expression)(argument = (Expression)arguments.get(i)), (boolean)false)))) break;
                            ITypeBinding parameterElementType = parameterType.getElementType();
                            int j = i;
                            while (j < arguments.size()) {
                                Expression argument2 = (Expression)arguments.get(j);
                                String argumentClassName2 = AstNodeUtils.getFullyQualifiedName((Expression)argument2, (boolean)false);
                                AbstractJavaTest.assertTrue((boolean)AstNodeUtils.isSuccessorOf((ITypeBinding)parameterElementType, (String)argumentClassName2));
                                ++j;
                            }
                            break;
                        }
                        argument = (Expression)arguments.get(i);
                        argumentClassName = AstNodeUtils.getFullyQualifiedName((Expression)argument, (boolean)false);
                        AstNodeUtils.isSuccessorOf((ITypeBinding)parameterType, (String)argumentClassName);
                        ++i;
                    }
                }
                if (node instanceof MethodDeclaration) {
                    MethodDeclaration declaration3 = (MethodDeclaration)node;
                    IMethodBinding methodBinding = AstNodeUtils.getMethodBinding((MethodDeclaration)declaration3);
                    AbstractJavaTest.assertNotNull((Object)methodBinding);
                    AbstractJavaTest.assertEquals((Object)declaration3.getName().getIdentifier(), (Object)methodBinding.getName());
                    Type returnType = declaration3.getReturnType2();
                    if (returnType != null) {
                        ITypeBinding bindingType = methodBinding.getReturnType();
                        ITypeBinding declarationType = AstNodeUtils.getTypeBinding((Type)returnType);
                        this.assertEqualTypes(bindingType, declarationType);
                    }
                    ITypeBinding[] bindingTypes = methodBinding.getParameterTypes();
                    List parameters = DomGenerics.parameters((MethodDeclaration)declaration3);
                    AbstractJavaTest.assertEquals((long)parameters.size(), (long)bindingTypes.length);
                    int i = 0;
                    while (i < bindingTypes.length) {
                        ITypeBinding bindingType = bindingTypes[i];
                        SingleVariableDeclaration parameter = (SingleVariableDeclaration)parameters.get(i);
                        ITypeBinding parameterType = AstNodeUtils.getTypeBinding((SingleVariableDeclaration)parameter);
                        this.assertEqualTypes(bindingType, parameterType);
                        ++i;
                    }
                }
                if (node instanceof ExpressionStatement || node instanceof VariableDeclarationStatement || node instanceof FieldDeclaration || node instanceof ImportDeclaration || node instanceof PackageDeclaration) {
                    this.checkNodeSuffix(node, ";");
                }
                if (node instanceof MethodInvocation) {
                    this.checkNodeSuffix(node, ")");
                }
                if (node instanceof ParenthesizedExpression) {
                    this.checkNodePrefix(node, "(");
                    this.checkNodeSuffix(node, ")");
                }
                if (node instanceof Block) {
                    this.checkNodePrefix(node, "{");
                    this.checkNodeSuffix(node, "}");
                }
                if (node instanceof TypeDeclaration || node instanceof AnonymousClassDeclaration) {
                    this.checkNodeSuffix(node, "}");
                }
                if (node instanceof StringLiteral) {
                    this.checkNodePrefix(node, "\"");
                    this.checkNodeSuffix(node, "\"");
                }
                if (node instanceof Block) {
                    Block block = (Block)node;
                    int lastStatementEnd = -1;
                    for (Statement statement : DomGenerics.statements((Block)block)) {
                        AbstractJavaTest.assertTrue((lastStatementEnd <= statement.getStartPosition() ? 1 : 0) != 0);
                        lastStatementEnd = AstNodeUtils.getSourceEnd((ASTNode)statement);
                    }
                }
                if (node instanceof TypeDeclaration) {
                    TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                    int lastDeclarationEnd = -1;
                    for (BodyDeclaration declaration4 : DomGenerics.bodyDeclarations((TypeDeclaration)typeDeclaration)) {
                        AbstractJavaTest.assertTrue((lastDeclarationEnd <= declaration4.getStartPosition() ? 1 : 0) != 0);
                        lastDeclarationEnd = AstNodeUtils.getSourceEnd((ASTNode)declaration4);
                    }
                }
            }

            private void assertEqualTypes(ITypeBinding bindingType, ITypeBinding parameterType) {
                String bindingTypeName = AstNodeUtils.getFullyQualifiedName((ITypeBinding)bindingType, (boolean)false);
                String parameterTypeName = AstNodeUtils.getFullyQualifiedName((ITypeBinding)parameterType, (boolean)false);
                AbstractJavaTest.assertEquals((Object)bindingTypeName, (Object)parameterTypeName);
            }

            private void checkNodePrefix(ASTNode node, String prefix) {
                AbstractJavaTest.assertEquals((Object)prefix, (Object)this.getSource(node.getStartPosition(), prefix.length()));
            }

            private void checkNodeSuffix(ASTNode node, String suffix) {
                int end = node.getStartPosition() + node.getLength();
                AbstractJavaTest.assertEquals((Object)suffix, (Object)this.getSource(end - suffix.length(), suffix.length()));
            }

            private String getSource(int start, int length) {
                try {
                    return editor.getSource(start, length);
                }
                catch (Throwable e) {
                    throw ReflectionUtils.propagate((Throwable)e);
                }
            }

            private String getSource(ASTNode node) {
                return this.getSource(node.getStartPosition(), node.getLength());
            }
        });
    }
}

