/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.junit.Assert;
import org.junit.Test;

public class RequestsTest
extends Assert {
    @Test
    public void test_Request() throws Exception {
        Request request = new Request();
        RequestsTest.assertNull((Object)request.getType());
        Integer type = 3;
        request = new Request((Object)type);
        RequestsTest.assertSame((Object)type, (Object)request.getType());
    }

    @Test
    public void test_GroupRequest() throws Exception {
        GroupRequest request = new GroupRequest();
        RequestsTest.assertNull((Object)request.getType());
        RequestsTest.assertNull((Object)request.getEditParts());
        request = new GroupRequest((Object)"zzz");
        GraphicalEditPart editPart1 = new GraphicalEditPart(){

            protected Figure createFigure() {
                return null;
            }
        };
        GraphicalEditPart editPart2 = new GraphicalEditPart(){

            protected Figure createFigure() {
                return null;
            }
        };
        request.setEditParts(List.of(editPart1, editPart2));
        RequestsTest.assertEquals((Object)"zzz", (Object)request.getType());
        RequestsTest.assertNotNull((Object)request.getEditParts());
        RequestsTest.assertEquals((long)2L, (long)request.getEditParts().size());
        RequestsTest.assertSame((Object)editPart1, request.getEditParts().get(0));
        RequestsTest.assertSame((Object)editPart2, request.getEditParts().get(1));
        ArrayList editParts = new ArrayList();
        request.setEditParts(editParts);
        RequestsTest.assertSame(editParts, (Object)request.getEditParts());
    }

    @Test
    public void test_ChangeBoundsRequest() throws Exception {
        ChangeBoundsRequest request = new ChangeBoundsRequest();
        RequestsTest.assertNull((Object)request.getType());
        RequestsTest.assertNull((Object)request.getEditParts());
        RequestsTest.assertNull((Object)request.getLocation());
        RequestsTest.assertEquals((Object)new Point(), (Object)request.getMoveDelta());
        RequestsTest.assertEquals((Object)new Dimension(), (Object)request.getSizeDelta());
        RequestsTest.assertEquals((long)0L, (long)request.getResizeDirection());
        GraphicalEditPart editPart = new GraphicalEditPart(){

            protected Figure createFigure() {
                return null;
            }
        };
        Point location = new Point(30, 40);
        Point moveDelta = new Point(15, 11);
        Dimension sizeDelta = new Dimension(20, 10);
        request = new ChangeBoundsRequest((Object)"sss");
        request.setEditParts((EditPart)editPart);
        request.setLocation(location);
        request.setMoveDelta(moveDelta);
        request.setSizeDelta(sizeDelta);
        request.setResizeDirection(16);
        RequestsTest.assertEquals((Object)"sss", (Object)request.getType());
        RequestsTest.assertNotNull((Object)request.getEditParts());
        RequestsTest.assertEquals((long)1L, (long)request.getEditParts().size());
        RequestsTest.assertSame((Object)editPart, request.getEditParts().get(0));
        RequestsTest.assertSame((Object)location, (Object)request.getLocation());
        RequestsTest.assertSame((Object)moveDelta, (Object)request.getMoveDelta());
        RequestsTest.assertSame((Object)sizeDelta, (Object)request.getSizeDelta());
        RequestsTest.assertEquals((long)16L, (long)request.getResizeDirection());
        Rectangle rectangle = new Rectangle(1, 2, 3, 4);
        Rectangle result = request.getTransformedRectangle(rectangle);
        RequestsTest.assertNotSame((Object)rectangle, (Object)result);
        RequestsTest.assertEquals((Object)new Rectangle(1, 2, 3, 4), (Object)rectangle);
        RequestsTest.assertEquals((Object)new Rectangle(16, 13, 23, 14), (Object)result);
        RequestsTest.assertSame((Object)moveDelta, (Object)request.getMoveDelta());
        RequestsTest.assertSame((Object)sizeDelta, (Object)request.getSizeDelta());
    }

    @Test
    public void test_LocationRequest() throws Exception {
        LocationRequest request = new LocationRequest();
        RequestsTest.assertNull((Object)request.getType());
        RequestsTest.assertNull((Object)request.getLocation());
        request = new LocationRequest((Object)"zzz");
        request.setLocation(new Point(1, 2));
        RequestsTest.assertEquals((Object)"zzz", (Object)request.getType());
        RequestsTest.assertEquals((Object)new Point(1, 2), (Object)request.getLocation());
    }

    @Test
    public void test_SelectionRequest() throws Exception {
        SelectionRequest request = new SelectionRequest();
        RequestsTest.assertNull((Object)request.getType());
        RequestsTest.assertNull((Object)request.getLocation());
        RequestsTest.assertEquals((long)0L, (long)request.getModifiers());
        RequestsTest.assertEquals((long)0L, (long)request.getLastButtonPressed());
        RequestsTest.assertFalse((boolean)request.isAltKeyPressed());
        RequestsTest.assertFalse((boolean)request.isControlKeyPressed());
        RequestsTest.assertFalse((boolean)request.isShiftKeyPressed());
        RequestsTest.assertFalse((boolean)request.isLeftMouseButtonPressed());
        RequestsTest.assertFalse((boolean)request.isRightMouseButtonPressed());
        RequestsTest.assertFalse((boolean)request.isAnyMouseButtonPressed());
        request = new SelectionRequest();
        request.setType((Object)"selection");
        RequestsTest.assertSame((Object)"selection", (Object)request.getType());
        request.setLocation(new Point(11, 22));
        RequestsTest.assertEquals((Object)new Point(11, 22), (Object)request.getLocation());
        request.setLastButtonPressed(1);
        RequestsTest.assertEquals((long)1L, (long)request.getLastButtonPressed());
        request.setLastButtonPressed(3);
        RequestsTest.assertEquals((long)3L, (long)request.getLastButtonPressed());
        request.setModifiers(393216);
        RequestsTest.assertFalse((boolean)request.isAltKeyPressed());
        RequestsTest.assertTrue((boolean)request.isControlKeyPressed());
        RequestsTest.assertTrue((boolean)request.isShiftKeyPressed());
        RequestsTest.assertFalse((boolean)request.isLeftMouseButtonPressed());
        RequestsTest.assertFalse((boolean)request.isRightMouseButtonPressed());
        RequestsTest.assertFalse((boolean)request.isAnyMouseButtonPressed());
    }

    @Test
    public void test_CreateRequest() throws Exception {
        ICreationFactory factory = new ICreationFactory(){

            public void activate() {
            }

            public Object getNewObject() {
                return 273;
            }
        };
        CreateRequest request = new CreateRequest(factory);
        RequestsTest.assertSame((Object)"create child", (Object)request.getType());
        RequestsTest.assertNull((Object)request.getLocation());
        RequestsTest.assertNull((Object)request.getSize());
        request.setLocation(new Point(12, 14));
        RequestsTest.assertEquals((Object)new Point(12, 14), (Object)request.getLocation());
        request.setSize(new Dimension(15, 12));
        RequestsTest.assertEquals((Object)new Dimension(15, 12), (Object)request.getSize());
        Object newObject = request.getNewObject();
        RequestsTest.assertEquals((Object)273, (Object)newObject);
        RequestsTest.assertSame((Object)newObject, (Object)request.getNewObject());
        RequestsTest.assertNotSame((Object)newObject, (Object)factory.getNewObject());
        Object otherObject = new Object();
        RequestsTest.assertSame((Object)newObject, (Object)request.getSelectObject());
        request.setSelectObject(otherObject);
        RequestsTest.assertSame((Object)newObject, (Object)request.getNewObject());
        RequestsTest.assertSame((Object)otherObject, (Object)request.getSelectObject());
    }

    @Test
    public void test_PasteRequest() throws Exception {
        String memnto = "_Test_Memento_";
        PasteRequest request = new PasteRequest((Object)memnto);
        RequestsTest.assertSame((Object)"paste", (Object)request.getType());
        RequestsTest.assertSame((Object)memnto, (Object)request.getMemento());
        RequestsTest.assertNull((Object)request.getLocation());
        RequestsTest.assertNull((Object)request.getSize());
        request.setLocation(new Point(12, 14));
        RequestsTest.assertEquals((Object)new Point(12, 14), (Object)request.getLocation());
        request.setSize(new Dimension(15, 12));
        RequestsTest.assertEquals((Object)new Dimension(15, 12), (Object)request.getSize());
    }
}

