/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.absolute.IAbsoluteLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.absolute.SelectionActionsSupport;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.core.model.TestObjectInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class AbsoluteLayoutSelectionActionsTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_selectionActions() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, 27, 83, 22);", "      button.setText('New Button1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(41, 129, 134, 84);", "      button.setText('New Button');", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(286, 135, 134, 120);", "        {", "          Label label = new Label(composite, SWT.NONE);", "          label.setBounds(41, 53, 51, 13);", "          label.setText('New Label');", "        }", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(2);
        ControlInfo label = (ControlInfo)composite.getChildrenControls().get(0);
        this.setupSelectionActions(shell);
        this.setupSelectionActions(composite);
        shell.refresh();
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        selectedObjects.add(button);
        ArrayList actions = new ArrayList();
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.assertEquals((long)17L, (long)actions.size());
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align horizontal centers"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align right edges"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align top edges"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align vertical centers"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align bottom edges"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate width"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate height"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window"));
        AbsoluteLayoutSelectionActionsTest.assertNotNull((Object)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window"));
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align horizontal centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align right edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align top edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align vertical centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align bottom edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate width").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate height").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window").isEnabled());
        selectedObjects.clear();
        selectedObjects.add(button);
        selectedObjects.add(composite);
        actions.clear();
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align horizontal centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align right edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align top edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align vertical centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align bottom edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate width").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate height").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window").isEnabled());
        selectedObjects.clear();
        selectedObjects.add(button);
        selectedObjects.add(label);
        actions.clear();
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align horizontal centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align right edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align top edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align vertical centers").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align bottom edges").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate width").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Replicate height").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertFalse((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window").isEnabled());
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window").isEnabled());
        selectedObjects.clear();
        selectedObjects.add(button);
        selectedObjects.add(label);
        selectedObjects.add((Object)new TestObjectInfo());
        actions.clear();
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.assertTrue((boolean)actions.isEmpty());
    }

    @Test
    public void test_align_left_edges_1a() throws Exception {
        this.check_align_horizontal(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(20, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(20, 50, 150, 30);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Align left edges", true);
    }

    @Test
    public void test_align_left_edges_1b() throws Exception {
        this.check_align_horizontal(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 50, 150, 30);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Align left edges", false);
    }

    @Test
    public void test_align_left_edges_2a() throws Exception {
        this.check_align_horizontal2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(30, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(5, 40, 300, 100);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(25, 55, 150, 30);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, "Align left edges", true);
    }

    @Test
    public void test_align_left_edges_2b() throws Exception {
        this.check_align_horizontal2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(5, 40, 300, 100);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(5, 55, 150, 30);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, "Align left edges", false);
    }

    @Test
    public void test_align_right_edges_1a() throws Exception {
        this.check_align_horizontal(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(20, 50, 150, 30);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Align right edges", true);
    }

    @Test
    public void test_align_right_edges_1b() throws Exception {
        this.check_align_horizontal(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(-40, 50, 150, 30);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Align right edges", false);
    }

    @Test
    public void test_align_right_edges_2a() throws Exception {
        this.check_align_horizontal2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(80, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(5, 40, 300, 100);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(25, 55, 150, 30);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, "Align right edges", true);
    }

    @Test
    public void test_align_right_edges_2b() throws Exception {
        this.check_align_horizontal2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(5, 40, 300, 100);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(-45, 55, 150, 30);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, "Align right edges", false);
    }

    @Test
    public void test_align_horizontal_centers_1a() throws Exception {
        this.check_align_horizontal(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(45, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(20, 50, 150, 30);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Align horizontal centers", true);
    }

    @Test
    public void test_align_horizontal_centers_1b() throws Exception {
        this.check_align_horizontal(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(-15, 50, 150, 30);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Align horizontal centers", false);
    }

    @Test
    public void test_align_horizontal_centers_2a() throws Exception {
        this.check_align_horizontal2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(55, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(5, 40, 300, 100);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(25, 55, 150, 30);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, "Align horizontal centers", true);
    }

    @Test
    public void test_align_horizontal_centers_2b() throws Exception {
        this.check_align_horizontal2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(5, 40, 300, 100);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(-20, 55, 150, 30);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, "Align horizontal centers", false);
    }

    private void check_align_horizontal(String[] expectedSource, String action, boolean toUp) throws Exception {
        this.check_align(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(20, 50, 150, 30);", "      button.setText(\"111\");", "    }", "  }", "}"}, expectedSource, action, toUp);
    }

    private void check_align_horizontal2(String[] expectedSource, String action, boolean toUp) throws Exception {
        this.check_align2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 100, 20);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(5, 40, 300, 100);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(25, 55, 150, 30);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, expectedSource, action, toUp);
    }

    @Test
    public void test_align_top_edges_1a() throws Exception {
        this.check_align_vertical(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 100, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, 100, 100, 80);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Align top edges", true);
    }

    @Test
    public void test_align_top_edges_1b() throws Exception {
        this.check_align_vertical(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, 10, 100, 80);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Align top edges", false);
    }

    @Test
    public void test_align_top_edges_2a() throws Exception {
        this.check_align_vertical2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 100, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(65, 5, 300, 300);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(5, 95, 100, 80);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, "Align top edges", true);
    }

    @Test
    public void test_align_top_edges_2b() throws Exception {
        this.check_align_vertical2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(65, 5, 300, 300);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(5, 5, 100, 80);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, "Align top edges", false);
    }

    @Test
    public void test_align_bottom_edges_1a() throws Exception {
        this.check_align_vertical(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 140, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, 100, 100, 80);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Align bottom edges", true);
    }

    @Test
    public void test_align_bottom_edges_1b() throws Exception {
        this.check_align_vertical(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, -30, 100, 80);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Align bottom edges", false);
    }

    @Test
    public void test_align_bottom_edges_2a() throws Exception {
        this.check_align_vertical2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 140, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(65, 5, 300, 300);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(5, 95, 100, 80);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, "Align bottom edges", true);
    }

    @Test
    public void test_align_bottom_edges_2b() throws Exception {
        this.check_align_vertical2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(65, 5, 300, 300);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(5, -35, 100, 80);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, "Align bottom edges", false);
    }

    @Test
    public void test_align_vertical_centers_1a() throws Exception {
        this.check_align_vertical(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 120, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, 100, 100, 80);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Align vertical centers", true);
    }

    @Test
    public void test_align_vertical_centers_1b() throws Exception {
        this.check_align_vertical(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, -10, 100, 80);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Align vertical centers", false);
    }

    @Test
    public void test_align_vertical_centers_2a() throws Exception {
        this.check_align_vertical2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 120, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(65, 5, 300, 300);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(5, 95, 100, 80);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, "Align vertical centers", true);
    }

    @Test
    public void test_align_vertical_centers_2b() throws Exception {
        this.check_align_vertical2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(65, 5, 300, 300);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(5, -15, 100, 80);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, "Align vertical centers", false);
    }

    private void check_align_vertical(String[] newSource, String action, boolean toUp) throws Exception {
        this.check_align(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, 100, 100, 80);", "      button.setText(\"111\");", "    }", "  }", "}"}, newSource, action, toUp);
    }

    private void check_align_vertical2(String[] newSource, String action, boolean toUp) throws Exception {
        this.check_align2(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(65, 5, 300, 300);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(5, 95, 100, 80);", "        button.setText(\"111\");", "      }", "    }", "  }", "}"}, newSource, action, toUp);
    }

    @Test
    public void test_align_replicate_width() throws Exception {
        this.check_align(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, 100, 100, 80);", "      button.setText(\"111\");", "    }", "  }", "}"}, new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 100, 40);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, 100, 100, 80);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Replicate width", true);
    }

    @Test
    public void test_align_replicate_height() throws Exception {
        this.check_align(new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 40);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, 100, 100, 80);", "      button.setText(\"111\");", "    }", "  }", "}"}, new String[]{"class Test extends Shell {", "  Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 80);", "      button.setText(\"000\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(70, 100, 100, 80);", "      button.setText(\"111\");", "    }", "  }", "}"}, "Replicate height", true);
    }

    @Test
    public void test_align_space_equally_1() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setSize(600, 400);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(30, 90, 100, 70);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(40, 200, 50, 30);", "      button.setText('111');", "    }", "  }", "}");
        this.setupSelectionActions(shell);
        shell.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        selectedObjects.add((ObjectInfo)shell.getChildrenControls().get(0));
        selectedObjects.add((ObjectInfo)shell.getChildrenControls().get(1));
        ArrayList actions = new ArrayList();
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").run();
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").run();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setSize(600, 400);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(150, 100, 100, 70);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(400, 270, 50, 30);", "      button.setText('111');", "    }", "  }", "}");
    }

    @Test
    public void test_align_space_equally_2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setSize(400, 400);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 50);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(90, 90, 60, 60);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(220, 220, 70, 70);", "      button.setText('222');", "    }", "  }", "}");
        this.setupSelectionActions(shell);
        shell.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        selectedObjects.add((ObjectInfo)shell.getChildrenControls().get(0));
        selectedObjects.add((ObjectInfo)shell.getChildrenControls().get(1));
        selectedObjects.add((ObjectInfo)shell.getChildrenControls().get(2));
        ArrayList actions = new ArrayList();
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        try {
            ReflectionUtils.setField(DesignerPlugin.class, (String)"m_ctrlPressed", (Object)true);
            AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, horizontally").run();
            AbsoluteLayoutSelectionActionsTest.findAction(actions, "Space equally, vertically").run();
        }
        finally {
            ReflectionUtils.setField(DesignerPlugin.class, (String)"m_ctrlPressed", (Object)false);
        }
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setSize(400, 400);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 50, 50);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(110, 110, 60, 60);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(220, 220, 70, 70);", "      button.setText('222');", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_align_center_in_window() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setSize(600, 400);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 10, 60, 40);", "      button.setText('000');", "    }", "  }", "}");
        this.setupSelectionActions(shell);
        shell.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        selectedObjects.add((ObjectInfo)shell.getChildrenControls().get(0));
        ArrayList actions = new ArrayList();
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center horizontally in window").run();
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Center vertically in window").run();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    setSize(600, 400);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(262, 180, 60, 40);", "      button.setText('000');", "    }", "  }", "}");
    }

    @Test
    public void test_ScrolledComposite_onWayToRoot() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    ScrolledComposite scrolledComposite = new ScrolledComposite(this, SWT.NONE);", "    {", "      Composite composite = new Composite(scrolledComposite, SWT.NONE);", "      composite.setLayout(null);", "      {", "        Button button_1 = new Button(composite, SWT.NONE);", "        button_1.setBounds(10, 10, 100, 20);", "      }", "      {", "        Button button_2 = new Button(composite, SWT.NONE);", "        button_2.setBounds(20, 100, 100, 20);", "      }", "      scrolledComposite.setContent(composite);", "      scrolledComposite.setMinSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));", "    }", "  }", "}");
        shell.refresh();
        ArrayList selectedObjects = new ArrayList();
        selectedObjects.add(AbsoluteLayoutSelectionActionsTest.getJavaInfoByName("button_1"));
        selectedObjects.add(AbsoluteLayoutSelectionActionsTest.getJavaInfoByName("button_2"));
        CompositeInfo composite = (CompositeInfo)AbsoluteLayoutSelectionActionsTest.getJavaInfoByName("composite");
        this.setupSelectionActions(composite);
        ArrayList actions = new ArrayList();
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, "Align left edges").run();
    }

    private void check_align(String[] initialSource, String[] expectedSource, String action, boolean toUp) throws Exception {
        CompositeInfo shell = this.parseComposite(initialSource);
        this.setupSelectionActions(shell);
        shell.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        if (toUp) {
            selectedObjects.add((ObjectInfo)shell.getChildrenControls().get(1));
            selectedObjects.add((ObjectInfo)shell.getChildrenControls().get(0));
        } else {
            selectedObjects.add((ObjectInfo)shell.getChildrenControls().get(0));
            selectedObjects.add((ObjectInfo)shell.getChildrenControls().get(1));
        }
        ArrayList actions = new ArrayList();
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, action).run();
        this.assertEditor(expectedSource);
    }

    private void check_align2(String[] initialSource, String[] expectedSource, String action, boolean toUp) throws Exception {
        CompositeInfo shell = this.parseComposite(initialSource);
        this.setupSelectionActions(shell);
        shell.refresh();
        ArrayList<ObjectInfo> selectedObjects = new ArrayList<ObjectInfo>();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(1);
        this.setupSelectionActions(composite);
        if (toUp) {
            selectedObjects.add((ObjectInfo)composite.getChildrenControls().get(0));
            selectedObjects.add((ObjectInfo)shell.getChildrenControls().get(0));
        } else {
            selectedObjects.add((ObjectInfo)shell.getChildrenControls().get(0));
            selectedObjects.add((ObjectInfo)composite.getChildrenControls().get(0));
        }
        ArrayList actions = new ArrayList();
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        AbsoluteLayoutSelectionActionsTest.findAction(actions, action).run();
        this.assertEditor(expectedSource);
    }

    private void setupSelectionActions(final CompositeInfo composite) {
        composite.addBroadcastListener((Object)new ObjectEventListener(){

            public void addSelectionActions(List<ObjectInfo> objects, List<Object> actions) throws Exception {
                AbsoluteLayoutInfo layout = (AbsoluteLayoutInfo)composite.getLayout();
                new SelectionActionsSupport((IAbsoluteLayoutInfo)layout).addAlignmentActions(objects, actions);
            }
        });
    }
}

