/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout;

import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.eclipse.wb.tests.designer.swing.model.component.ContainerTest;
import org.junit.Test;

public class LayoutGefTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_dropLayout_canvas() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "  }", "}");
        LayoutInfo newLayout = (LayoutInfo)this.loadCreationTool("java.awt.BorderLayout");
        this.canvas.create();
        this.canvas.target(panel).in(100, 100).move();
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(panel));
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "  }", "}");
        LayoutGefTest.assertSame((Object)newLayout, (Object)panel.getLayout());
    }

    @Test
    public void test_dropLayout_tree() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "  }", "}");
        LayoutInfo newLayout = (LayoutInfo)this.loadCreationTool("java.awt.BorderLayout");
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "  }", "}");
        LayoutGefTest.assertSame((Object)newLayout, (Object)panel.getLayout());
    }

    @Test
    public void test_dropLayout_disabledSetLayout_canvas() throws Exception {
        ContainerTest.prepareMyPanel_disabledSetLayout();
        ContainerInfo panel = this.openContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        this.loadCreationTool("java.awt.BorderLayout");
        this.canvas.create();
        this.canvas.target(panel).in(100, 100).move();
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_dropLayout_disabledSetLayout_tree() throws Exception {
        ContainerTest.prepareMyPanel_disabledSetLayout();
        ContainerInfo panel = this.openContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        this.loadCreationTool("java.awt.BorderLayout");
        this.tree.moveOn(panel);
        this.tree.assertCommandNull();
    }

    @Test
    public void test_dropUnknownLayout_noTreeLayout() throws Exception {
        LayoutGefTest.setFileContentSrc("test/MyLayout.java", this.getTestSource("public class MyLayout implements LayoutManager {", "  public void addLayoutComponent(String name, Component comp) {", "  }", "  public  void removeLayoutComponent(Component comp) {", "  }", "  public Dimension preferredLayoutSize(Container parent) {", "    return new Dimension(200, 100);", "  }", "  public Dimension minimumLayoutSize(Container parent) {", "    return new Dimension(200, 100);", "  }", "  public void layoutContainer(Container parent) {", "  }", "}"));
        LayoutGefTest.waitForAutoBuild();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "  }", "}");
        this.loadCreationTool("javax.swing.JButton");
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNotNull();
        this.tree.cancel();
        this.loadCreationTool("test.MyLayout");
        this.tree.moveOn(panel);
        this.tree.click();
        this.loadCreationTool("javax.swing.JButton");
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNull();
    }
}

