/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout;

import org.eclipse.jface.action.IAction;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Ignore;
import org.junit.Test;

public class AbsoluteLayoutGefTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Ignore
    @Test
    public void test_canvas_CREATE() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "  }", "}");
        this.loadCreationBox();
        this.canvas.sideMode().create(100, 50);
        this.canvas.target(panel).in(30, 40).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      Box box = new Box();", "      box.setBounds(30, 40, 100, 50);", "      add(box);", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_canvas_PASTE() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      Box boxA = new Box();", "      boxA.setBounds(10, 20, 100, 50);", "      add(boxA);", "    }", "  }", "}");
        ComponentInfo boxA = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.select(boxA);
        IAction copyAction = this.getCopyAction();
        AbsoluteLayoutGefTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        AbsoluteLayoutGefTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        this.canvas.sideMode().create(100, 50);
        this.canvas.target(panel).inX(50).inY(100).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      Box boxA = new Box();", "      boxA.setBounds(10, 20, 100, 50);", "      add(boxA);", "    }", "    {", "      Box box = new Box();", "      box.setBounds(50, 100, 100, 50);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_MOVE() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      Box box = new Box();", "      box.setBounds(30, 40, 100, 50);", "      add(box);", "    }", "  }", "}");
        ComponentInfo box = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.sideMode().beginMove(box);
        this.canvas.target(panel).inX(50).inY(80).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      Box box = new Box();", "      box.setBounds(50, 80, 100, 50);", "      add(box);", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_canvas_ADD() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel inner = new JPanel();", "      inner.setLayout(null);", "      add(inner);", "      inner.setBounds(20, 100, 200, 150);", "      {", "        Box box = new Box();", "        box.setBounds(10, 20, 100, 50);", "        inner.add(box);", "      }", "    }", "  }", "}");
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo box = (ComponentInfo)inner.getChildrenComponents().get(0);
        this.canvas.sideMode().beginMove(box);
        this.canvas.target(panel).in(50, 25).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel inner = new JPanel();", "      inner.setLayout(null);", "      add(inner);", "      inner.setBounds(20, 100, 200, 150);", "    }", "    {", "      Box box = new Box();", "      box.setBounds(50, 25, 100, 50);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_tree_CREATE() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "  }", "}");
        ComponentInfo newBox = this.loadCreationBox();
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      Box box = new Box();", "      box.setBounds(0, 0, 100, 50);", "      add(box);", "    }", "  }", "}");
        this.tree.assertPrimarySelected(newBox);
    }

    @Ignore
    @Test
    public void test_tree_PASTE() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      Box boxA = new Box();", "      boxA.setBounds(10, 20, 100, 50);", "      add(boxA);", "    }", "  }", "}");
        ComponentInfo boxA = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.select(boxA);
        IAction copyAction = this.getCopyAction();
        AbsoluteLayoutGefTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        AbsoluteLayoutGefTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      Box boxA = new Box();", "      boxA.setBounds(10, 20, 100, 50);", "      add(boxA);", "    }", "    {", "      Box box = new Box();", "      box.setBounds(0, 0, 100, 50);", "      add(box);", "    }", "  }", "}");
    }

    @Test
    public void test_tree_MOVE() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      Box boxA = new Box();", "      boxA.setBounds(10, 20, 100, 50);", "      add(boxA);", "    }", "    {", "      Box boxB = new Box();", "      boxB.setBounds(20, 100, 100, 50);", "      add(boxB);", "    }", "  }", "}");
        ComponentInfo boxA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo boxB = (ComponentInfo)panel.getChildrenComponents().get(1);
        this.tree.startDrag(boxB);
        this.tree.dragBefore(boxA);
        this.tree.assertFeedback_before(boxA);
        this.tree.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      Box boxB = new Box();", "      boxB.setBounds(20, 100, 100, 50);", "      add(boxB);", "    }", "    {", "      Box boxA = new Box();", "      boxA.setBounds(10, 20, 100, 50);", "      add(boxA);", "    }", "  }", "}");
        this.tree.assertPrimarySelected(boxB);
    }

    @Test
    public void test_tree_ADD() throws Exception {
        this.prepareBox();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel inner = new JPanel();", "      inner.setLayout(null);", "      add(inner);", "      inner.setBounds(20, 100, 200, 150);", "      {", "        Box box = new Box();", "        box.setBounds(10, 20, 100, 50);", "        inner.add(box);", "      }", "    }", "  }", "}");
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo box = (ComponentInfo)inner.getChildrenComponents().get(0);
        this.tree.startDrag(box);
        this.tree.dragOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel inner = new JPanel();", "      inner.setLayout(null);", "      add(inner);", "      inner.setBounds(20, 100, 200, 150);", "    }", "    {", "      Box box = new Box();", "      box.setBounds(0, 0, 100, 50);", "      add(box);", "    }", "  }", "}");
    }
}

