/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.bean;

import org.eclipse.gef.Tool;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo;
import org.eclipse.wb.internal.swing.model.bean.ActionInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JToolBarInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuBarInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuItemInfo;
import org.eclipse.wb.internal.swing.palette.ActionExternalEntryInfo;
import org.eclipse.wb.internal.swing.palette.ActionNewEntryInfo;
import org.eclipse.wb.internal.swing.palette.ActionUseEntryInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.eclipse.wb.tests.gef.UIPredicate;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Ignore;
import org.junit.Test;

public class ActionGefTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_JToolBar_ActionNewEntryInfo() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JToolBar toolBar = new JToolBar();", "      add(toolBar, BorderLayout.NORTH);", "    }", "  }", "}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(toolBar, BorderLayout.NORTH)/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: javax.swing.JToolBar} {local-unique: toolBar} {/new JToolBar()/ /add(toolBar, BorderLayout.NORTH)/}");
        panel.refresh();
        JToolBarInfo toolBar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ActionNewEntryInfo entry = new ActionNewEntryInfo();
        entry.initialize((IEditPartViewer)this.m_viewerCanvas, (JavaInfo)panel);
        org.eclipse.wb.gef.core.tools.Tool tool = entry.createTool();
        this.m_viewerCanvas.getEditDomain().setActiveTool((Tool)tool);
        this.canvas.target(panel).in(100, 100).move();
        this.canvas.target(toolBar).in(20, 5).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  private final Action action = new SwingAction();", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JToolBar toolBar = new JToolBar();", "      add(toolBar, BorderLayout.NORTH);", "      {", "        JButton button = toolBar.add(action);", "      }", "    }", "  }", "  private class SwingAction extends AbstractAction {", "    public SwingAction() {", "      putValue(NAME, 'SwingAction');", "      putValue(SHORT_DESCRIPTION, 'Some short description');", "    }", "    public void actionPerformed(ActionEvent e) {", "    }", "  }", "}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(toolBar, BorderLayout.NORTH)/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: javax.swing.JToolBar} {local-unique: toolBar} {/new JToolBar()/ /add(toolBar, BorderLayout.NORTH)/ /toolBar.add(action)/}", "    {implicit-factory} {local-unique: button} {/toolBar.add(action)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {innerAction} {field-initializer: action} {/new SwingAction()/ /toolBar.add(action)/}");
        ComponentInfo button = (ComponentInfo)toolBar.getChildrenComponents().get(0);
        this.canvas.assertPrimarySelected(button);
    }

    @Test
    public void test_JToolBar_ActionUseEntryInfo_canvas() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JToolBar toolBar = new JToolBar();", "      add(toolBar, BorderLayout.NORTH);", "    }", "  }", "}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(toolBar, BorderLayout.NORTH)/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: javax.swing.JToolBar} {local-unique: toolBar} {/new JToolBar()/ /add(toolBar, BorderLayout.NORTH)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {field-initializer: action} {/new ExternalAction()/}");
        panel.refresh();
        JToolBarInfo toolBar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        this.loadUseAction(action);
        this.canvas.target(toolBar).in(10, 5).move();
        this.canvas.click();
        ActionGefTest.assertNoErrors((JavaInfo)panel);
        this.assertEditor("public class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JToolBar toolBar = new JToolBar();", "      add(toolBar, BorderLayout.NORTH);", "      {", "        JButton button = toolBar.add(action);", "      }", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)toolBar.getChildrenComponents().get(0);
        this.tree.assertPrimarySelected(button);
        this.canvas.assertPrimarySelected(button);
    }

    @Test
    public void test_JToolBar_ActionUseEntryInfo_tree() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JToolBar toolBar = new JToolBar();", "      add(toolBar, BorderLayout.NORTH);", "    }", "  }", "}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(toolBar, BorderLayout.NORTH)/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: javax.swing.JToolBar} {local-unique: toolBar} {/new JToolBar()/ /add(toolBar, BorderLayout.NORTH)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {field-initializer: action} {/new ExternalAction()/}");
        panel.refresh();
        JToolBarInfo toolBar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        this.loadUseAction(action);
        this.tree.moveOn(toolBar);
        this.tree.click();
        ActionGefTest.assertNoErrors((JavaInfo)panel);
        this.assertEditor("public class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JToolBar toolBar = new JToolBar();", "      add(toolBar, BorderLayout.NORTH);", "      {", "        JButton button = toolBar.add(action);", "      }", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)toolBar.getChildrenComponents().get(0);
        this.tree.assertPrimarySelected(button);
        this.canvas.assertPrimarySelected(button);
    }

    @Ignore
    @Test
    public void test_JToolBar_ActionExternalEntryInfo() throws Exception {
        this.createExternalAction();
        final ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JToolBar toolBar = new JToolBar();", "      add(toolBar, BorderLayout.NORTH);", "    }", "  }", "}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(toolBar, BorderLayout.NORTH)/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: javax.swing.JToolBar} {local-unique: toolBar} {/new JToolBar()/ /add(toolBar, BorderLayout.NORTH)/}");
        panel.refresh();
        JToolBarInfo toolBar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                ActionExternalEntryInfo entry = new ActionExternalEntryInfo();
                entry.initialize((IEditPartViewer)ActionGefTest.this.m_viewerCanvas, (JavaInfo)panel);
                org.eclipse.wb.gef.core.tools.Tool tool = entry.createTool();
                ActionGefTest.this.m_viewerCanvas.getEditDomain().setActiveTool((Tool)tool);
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("Open type");
                Text text = context.findFirstWidget(Text.class);
                text.setText("ExternalAction");
                final Table typesTable = context.findFirstWidget(Table.class);
                context.waitFor(new UIPredicate(){

                    @Override
                    public boolean check() {
                        return typesTable.getItems().length != 0;
                    }
                });
                context.clickButton("OK");
            }
        });
        this.canvas.target(toolBar).in(10, 5).move();
        this.canvas.click();
        ActionGefTest.assertNoErrors((JavaInfo)panel);
        this.assertEditor("public class Test extends JPanel {", "  private final ExternalAction externalAction = new ExternalAction();", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JToolBar toolBar = new JToolBar();", "      add(toolBar, BorderLayout.NORTH);", "      {", "        JButton button = toolBar.add(externalAction);", "      }", "    }", "  }", "}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(toolBar, BorderLayout.NORTH)/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: javax.swing.JToolBar} {local-unique: toolBar} {/new JToolBar()/ /add(toolBar, BorderLayout.NORTH)/ /toolBar.add(externalAction)/}", "    {implicit-factory} {local-unique: button} {/toolBar.add(externalAction)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {field-initializer: externalAction} {/new ExternalAction()/ /toolBar.add(externalAction)/}");
        ComponentInfo button = (ComponentInfo)toolBar.getChildrenComponents().get(0);
        this.canvas.assertPrimarySelected(button);
    }

    @Test
    public void test_JButton_setAction() throws Exception {
        this.createExternalAction();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {field-initializer: action} {/new ExternalAction()/}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)panel).get(0);
        this.loadUseAction(action);
        this.canvas.target(button).in(10, 5).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    {", "      JButton button = new JButton();", "      button.setAction(action);", "      add(button);", "    }", "  }", "}");
        this.canvas.assertPrimarySelected(button);
    }

    @Test
    public void test_JMenu_dropBetween_JMenuItem() throws Exception {
        this.createExternalAction();
        ContainerInfo frame = this.openContainer("public class Test extends JFrame {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    {", "      JMenuBar menuBar = new JMenuBar();", "      setJMenuBar(menuBar);", "      {", "        JMenu menu = new JMenu('Menu');", "        menuBar.add(menu);", "        {", "          JMenuItem item_1 = new JMenuItem('AAA AAA AAA');", "          menu.add(item_1);", "        }", "        {", "          JMenuItem item_2 = new JMenuItem('BBB BBB BBB');", "          menu.add(item_2);", "        }", "      }", "    }", "  }", "}");
        ActionGefTest.assertHierarchy("{this: javax.swing.JFrame} {this} {/setJMenuBar(menuBar)/}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {new: javax.swing.JMenuBar} {local-unique: menuBar} {/new JMenuBar()/ /setJMenuBar(menuBar)/ /menuBar.add(menu)/}", "    {new: javax.swing.JMenu} {local-unique: menu} {/new JMenu('Menu')/ /menuBar.add(menu)/ /menu.add(item_1)/ /menu.add(item_2)/}", "      {new: javax.swing.JMenuItem} {local-unique: item_1} {/new JMenuItem('AAA AAA AAA')/ /menu.add(item_1)/}", "      {new: javax.swing.JMenuItem} {local-unique: item_2} {/new JMenuItem('BBB BBB BBB')/ /menu.add(item_2)/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {field-initializer: action} {/new ExternalAction()/}");
        frame.refresh();
        JMenuBarInfo bar = (JMenuBarInfo)frame.getChildren(JMenuBarInfo.class).get(0);
        JMenuInfo menu = (JMenuInfo)bar.getChildrenMenus().get(0);
        JMenuItemInfo item_2 = (JMenuItemInfo)menu.getChildrenItems().get(1);
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)frame).get(0);
        this.tree.select(menu);
        this.canvas.assertNotNullEditPart(item_2);
        this.loadUseAction(action);
        this.canvas.target(item_2).in(10, 1).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JFrame {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    {", "      JMenuBar menuBar = new JMenuBar();", "      setJMenuBar(menuBar);", "      {", "        JMenu menu = new JMenu('Menu');", "        menuBar.add(menu);", "        {", "          JMenuItem item_1 = new JMenuItem('AAA AAA AAA');", "          menu.add(item_1);", "        }", "        {", "          JMenuItem menuItem = menu.add(action);", "        }", "        {", "          JMenuItem item_2 = new JMenuItem('BBB BBB BBB');", "          menu.add(item_2);", "        }", "      }", "    }", "  }", "}");
        JMenuItemInfo newItem = (JMenuItemInfo)menu.getChildrenItems().get(1);
        ActionGefTest.assertEquals((Object)"menuItem", (Object)newItem.getVariableSupport().getName());
        this.canvas.assertPrimarySelected(newItem);
    }

    private void createExternalAction() throws Exception {
        ActionGefTest.setFileContentSrc("test/ExternalAction.java", this.getTestSource("public class ExternalAction extends AbstractAction {", "  public ExternalAction() {", "    putValue(NAME, 'My name');", "    putValue(SHORT_DESCRIPTION, 'My short description');", "  }", "  public void actionPerformed(ActionEvent e) {", "  }", "}"));
        ActionGefTest.waitForAutoBuild();
    }

    private void loadUseAction(ActionInfo action) throws Exception {
        ActionUseEntryInfo entry = new ActionUseEntryInfo(action);
        entry.initialize((IEditPartViewer)this.m_viewerCanvas, action.getRootJava());
        org.eclipse.wb.gef.core.tools.Tool tool = entry.createTool();
        this.m_viewerCanvas.getEditDomain().setActiveTool((Tool)tool);
    }
}

