/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;
import org.eclipse.wb.internal.core.model.generic.FlowContainerFactory;
import org.eclipse.wb.internal.rcp.model.widgets.ToolBarInfo;
import org.eclipse.wb.internal.rcp.model.widgets.ToolItemInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class ToolBarTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_isHorizontal() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ToolBar toolBar_1 = new ToolBar(this, SWT.NONE);", "    ToolBar toolBar_2 = new ToolBar(this, SWT.VERTICAL);", "  }", "}");
        shell.refresh();
        ToolBarInfo toolBar_1 = (ToolBarInfo)shell.getChildren(ToolBarInfo.class).get(0);
        ToolBarTest.assertTrue((boolean)toolBar_1.isHorizontal());
        ToolBarTest.assertTrue((boolean)ToolBarTest.getFlowContainer(toolBar_1).isHorizontal());
        ToolBarInfo toolBar_2 = (ToolBarInfo)shell.getChildren(ToolBarInfo.class).get(1);
        ToolBarTest.assertFalse((boolean)toolBar_2.isHorizontal());
        ToolBarTest.assertFalse((boolean)ToolBarTest.getFlowContainer(toolBar_2).isHorizontal());
    }

    @Test
    public void test_parseItems() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "      {", "        ToolItem item = new ToolItem(toolBar, SWT.NONE);", "        item.setText('000');", "      }", "      {", "        ToolItem item = new ToolItem(toolBar, SWT.NONE);", "        item.setText('111');", "      }", "    }", "  }", "}");
        shell.refresh();
        ToolBarInfo toolBar = (ToolBarInfo)shell.getChildrenControls().get(0);
        List items = toolBar.getItems();
        ToolBarTest.assertEquals((long)2L, (long)items.size());
        ToolItemInfo item_0 = (ToolItemInfo)items.get(0);
        ToolItemInfo item_1 = (ToolItemInfo)items.get(1);
        ToolBarTest.assertEquals((Object)"000", (Object)item_0.getWidget().getText());
        ToolBarTest.assertEquals((Object)"111", (Object)item_1.getWidget().getText());
        Rectangle modelBounds = item_0.getModelBounds();
        ToolBarTest.assertTrue((modelBounds.width > 20 ? 1 : 0) != 0);
        ToolBarTest.assertTrue((modelBounds.height > 20 ? 1 : 0) != 0);
        ToolBarTest.assertFalse((boolean)item_0.isSeparator());
        ToolBarTest.assertNull((Object)item_0.getControl());
        Assertions.assertThat((List)item_0.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[0]);
    }

    @Test
    public void test_ToolItem_presentation() throws Exception {
        ToolBarInfo toolBar = (ToolBarInfo)this.parseJavaInfo("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    new ToolItem(this, SWT.NONE);", "    new ToolItem(this, SWT.PUSH);", "    new ToolItem(this, SWT.CHECK);", "    new ToolItem(this, SWT.RADIO);", "    new ToolItem(this, SWT.DROP_DOWN);", "    new ToolItem(this, SWT.SEPARATOR);", "  }", "}");
        toolBar.refresh();
        ToolItemInfo itemDefault = (ToolItemInfo)toolBar.getItems().get(0);
        ToolItemInfo itemPush = (ToolItemInfo)toolBar.getItems().get(1);
        ToolItemInfo itemCheck = (ToolItemInfo)toolBar.getItems().get(2);
        ToolItemInfo itemRadio = (ToolItemInfo)toolBar.getItems().get(3);
        ToolItemInfo itemDropDown = (ToolItemInfo)toolBar.getItems().get(4);
        ToolItemInfo itemSeparator = (ToolItemInfo)toolBar.getItems().get(5);
        ToolBarTest.assertSame((Object)itemDefault.getPresentation().getIcon(), (Object)itemPush.getPresentation().getIcon());
        ToolBarTest.assertNotSame((Object)itemPush.getPresentation().getIcon(), (Object)itemRadio.getPresentation().getIcon());
        ToolBarTest.assertNotSame((Object)itemPush.getPresentation().getIcon(), (Object)itemCheck.getPresentation().getIcon());
        ToolBarTest.assertNotSame((Object)itemRadio.getPresentation().getIcon(), (Object)itemCheck.getPresentation().getIcon());
        ToolBarTest.assertNotSame((Object)itemRadio.getPresentation().getIcon(), (Object)itemDropDown.getPresentation().getIcon());
        ToolBarTest.assertNotSame((Object)itemRadio.getPresentation().getIcon(), (Object)itemSeparator.getPresentation().getIcon());
    }

    @Test
    public void test_setControl_get() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "    {", "      ToolItem item = new ToolItem(toolBar, SWT.SEPARATOR);", "      item.setWidth(200);", "      {", "        Button button = new Button(toolBar, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        ToolBarInfo toolBar = (ToolBarInfo)shell.getChildrenControls().get(0);
        ToolItemInfo item = (ToolItemInfo)toolBar.getItems().get(0);
        ControlInfo button = (ControlInfo)toolBar.getChildrenControls().get(0);
        ToolBarTest.assertTrue((boolean)item.isSeparator());
        ToolBarTest.assertSame((Object)button, (Object)item.getControl());
        Assertions.assertThat((List)item.getSimpleContainerChildren()).containsExactly((Object[])new ObjectInfo[]{button});
        ToolBarTest.assertTrue((item.getBounds().width == 200 ? 1 : 0) != 0);
        ToolBarTest.assertTrue((button.getBounds().width > 190 ? 1 : 0) != 0);
        Assertions.assertThat((List)item.getPresentation().getChildrenTree()).containsExactly((Object[])new ObjectInfo[]{button});
        Assertions.assertThat((List)item.getPresentation().getChildrenGraphical()).containsExactly((Object[])new ObjectInfo[]{button});
        Assertions.assertThat((List)toolBar.getPresentation().getChildrenTree()).containsExactly((Object[])new ObjectInfo[]{item});
        Assertions.assertThat((List)toolBar.getPresentation().getChildrenGraphical()).containsExactly((Object[])new ObjectInfo[]{item});
    }

    @Test
    public void test_setControl_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "    {", "      ToolItem item = new ToolItem(toolBar, SWT.SEPARATOR);", "      item.setWidth(200);", "    }", "  }", "}");
        shell.refresh();
        ToolBarInfo toolBar = (ToolBarInfo)shell.getChildrenControls().get(0);
        ToolItemInfo item = (ToolItemInfo)toolBar.getItems().get(0);
        ToolBarTest.assertNull((Object)item.getControl());
        Assertions.assertThat((List)item.getSimpleContainerChildren()).isEmpty();
        ControlInfo button = BTestUtils.createButton();
        ToolBarTest.simpleContainer_CREATE((JavaInfo)item, button);
        ToolBarTest.assertSame((Object)button, (Object)item.getControl());
        Assertions.assertThat((List)item.getSimpleContainerChildren()).containsExactly((Object[])new ObjectInfo[]{button});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "    {", "      ToolItem item = new ToolItem(toolBar, SWT.SEPARATOR);", "      item.setWidth(200);", "      {", "        Button button = new Button(toolBar, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_setControl_ADD() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "    {", "      ToolItem item = new ToolItem(toolBar, SWT.SEPARATOR);", "      item.setWidth(200);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ToolBarInfo toolBar = (ToolBarInfo)shell.getChildrenControls().get(0);
        ToolItemInfo item = (ToolItemInfo)toolBar.getItems().get(0);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        ToolBarTest.assertNull((Object)item.getControl());
        ToolBarTest.simpleContainer_ADD((JavaInfo)item, button);
        ToolBarTest.assertSame((Object)button, (Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "    {", "      ToolItem item = new ToolItem(toolBar, SWT.SEPARATOR);", "      item.setWidth(200);", "      {", "        Button button = new Button(toolBar, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_setControl_MOVE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "    {", "      ToolItem item_1 = new ToolItem(toolBar, SWT.SEPARATOR);", "      item_1.setWidth(200);", "    }", "    {", "      ToolItem item_2 = new ToolItem(toolBar, SWT.SEPARATOR);", "      item_2.setWidth(200);", "      {", "        Button button = new Button(toolBar, SWT.NONE);", "        item_2.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        ToolBarInfo toolBar = (ToolBarInfo)shell.getChildrenControls().get(0);
        ToolItemInfo item_1 = (ToolItemInfo)toolBar.getItems().get(0);
        ToolItemInfo item_2 = (ToolItemInfo)toolBar.getItems().get(1);
        ControlInfo button = item_2.getControl();
        ToolBarTest.assertEquals((long)(toolBar.getChildrenJava().indexOf(item_2) + 1), (long)toolBar.getChildrenJava().indexOf(button));
        ToolBarTest.simpleContainer_ADD((JavaInfo)item_1, button);
        ToolBarTest.assertNull((Object)item_2.getControl());
        ToolBarTest.assertSame((Object)button, (Object)item_1.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "    {", "      ToolItem item_1 = new ToolItem(toolBar, SWT.SEPARATOR);", "      item_1.setWidth(200);", "      {", "        Button button = new Button(toolBar, SWT.NONE);", "        item_1.setControl(button);", "      }", "    }", "    {", "      ToolItem item_2 = new ToolItem(toolBar, SWT.SEPARATOR);", "      item_2.setWidth(200);", "    }", "  }", "}");
        ToolBarTest.assertEquals((long)(toolBar.getChildrenJava().indexOf(item_1) + 1), (long)toolBar.getChildrenJava().indexOf(button));
    }

    @Test
    public void test_setControl_MOVEItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "    {", "      ToolItem item_1 = new ToolItem(toolBar, SWT.NONE);", "      item_1.setWidth(200);", "    }", "    {", "      ToolItem item_2 = new ToolItem(toolBar, SWT.SEPARATOR);", "      item_2.setWidth(200);", "      {", "        Button button = new Button(toolBar, SWT.NONE);", "        item_2.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        ToolBarInfo toolBar = (ToolBarInfo)shell.getChildrenControls().get(0);
        ToolItemInfo item_1 = (ToolItemInfo)toolBar.getItems().get(0);
        ToolItemInfo item_2 = (ToolItemInfo)toolBar.getItems().get(1);
        ControlInfo button = item_2.getControl();
        ToolBarTest.assertEquals((long)(toolBar.getChildrenJava().indexOf(item_2) + 1), (long)toolBar.getChildrenJava().indexOf(button));
        ToolBarTest.flowContainer_MOVE((JavaInfo)toolBar, item_2, item_1);
        ToolBarTest.assertSame((Object)button, (Object)item_2.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "    {", "      ToolItem item_2 = new ToolItem(toolBar, SWT.SEPARATOR);", "      item_2.setWidth(200);", "      {", "        Button button = new Button(toolBar, SWT.NONE);", "        item_2.setControl(button);", "      }", "    }", "    {", "      ToolItem item_1 = new ToolItem(toolBar, SWT.NONE);", "      item_1.setWidth(200);", "    }", "  }", "}");
        ToolBarTest.assertEquals((long)(toolBar.getChildrenJava().indexOf(item_2) + 1), (long)toolBar.getChildrenJava().indexOf(button));
    }

    @Test
    public void test_setControl_moveOut() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "    {", "      ToolItem item = new ToolItem(toolBar, SWT.SEPARATOR);", "      item.setWidth(200);", "      {", "        Button button = new Button(toolBar, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
        shell.refresh();
        RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        ToolBarInfo toolBar = (ToolBarInfo)shell.getChildrenControls().get(0);
        ToolItemInfo item = (ToolItemInfo)toolBar.getItems().get(0);
        ControlInfo button = item.getControl();
        ToolBarTest.flowContainer_MOVE((JavaInfo)rowLayout, button, null);
        ToolBarTest.assertNull((Object)item.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "    {", "      ToolItem item = new ToolItem(toolBar, SWT.SEPARATOR);", "      item.setWidth(200);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "    }", "  }", "}");
        shell.refresh();
        ToolBarInfo toolBar = (ToolBarInfo)shell.getChildrenControls().get(0);
        ToolItemInfo toolItem = (ToolItemInfo)ToolBarTest.createJavaInfo("org.eclipse.swt.widgets.ToolItem", null);
        ToolBarTest.flowContainer_CREATE((JavaInfo)toolBar, toolItem, null);
        toolItem = (ToolItemInfo)ToolBarTest.createJavaInfo("org.eclipse.swt.widgets.ToolItem", "check");
        ToolBarTest.flowContainer_CREATE((JavaInfo)toolBar, toolItem, null);
        toolItem = (ToolItemInfo)ToolBarTest.createJavaInfo("org.eclipse.swt.widgets.ToolItem", "radio");
        ToolBarTest.flowContainer_CREATE((JavaInfo)toolBar, toolItem, null);
        toolItem = (ToolItemInfo)ToolBarTest.createJavaInfo("org.eclipse.swt.widgets.ToolItem", "dropDown");
        ToolBarTest.flowContainer_CREATE((JavaInfo)toolBar, toolItem, null);
        toolItem = (ToolItemInfo)ToolBarTest.createJavaInfo("org.eclipse.swt.widgets.ToolItem", "separator");
        ToolBarTest.flowContainer_CREATE((JavaInfo)toolBar, toolItem, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "      {", "        ToolItem toolItem = new ToolItem(toolBar, SWT.NONE);", "        toolItem.setText('New Item');", "      }", "      {", "        ToolItem toolItem = new ToolItem(toolBar, SWT.CHECK);", "        toolItem.setText('Check Item');", "      }", "      {", "        ToolItem toolItem = new ToolItem(toolBar, SWT.RADIO);", "        toolItem.setText('Radio Item');", "      }", "      {", "        ToolItem toolItem = new ToolItem(toolBar, SWT.DROP_DOWN);", "        toolItem.setText('DropDown Item');", "      }", "      {", "        ToolItem toolItem = new ToolItem(toolBar, SWT.SEPARATOR);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "      {", "        ToolItem item = new ToolItem(toolBar, SWT.NONE);", "        item.setText('000');", "      }", "      {", "        ToolItem item = new ToolItem(toolBar, SWT.NONE);", "        item.setText('111');", "      }", "    }", "  }", "}");
        shell.refresh();
        ToolBarInfo toolBar = (ToolBarInfo)shell.getChildrenControls().get(0);
        List items = toolBar.getItems();
        ToolBarTest.flowContainer_MOVE((JavaInfo)toolBar, items.get(1), items.get(0));
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      ToolBar toolBar = new ToolBar(this, SWT.FLAT);", "      {", "        ToolItem item = new ToolItem(toolBar, SWT.NONE);", "        item.setText('111');", "      }", "      {", "        ToolItem item = new ToolItem(toolBar, SWT.NONE);", "        item.setText('000');", "      }", "    }", "  }", "}");
    }

    private static FlowContainer getFlowContainer(ToolBarInfo toolBar) {
        return (FlowContainer)new FlowContainerFactory((JavaInfo)toolBar, true).get().get(0);
    }
}

