/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.editor.palette.PaletteEventListener;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.EmptyAssociation;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildGraphical;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.rcp.Activator;
import org.eclipse.wb.internal.rcp.model.jface.FieldEditorInfo;
import org.eclipse.wb.internal.rcp.model.jface.FieldLayoutPreferencePageInfo;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class FieldLayoutPreferencePageTest
extends RcpModelTest {
    @Override
    protected void configureNewProject() throws Exception {
        super.configureNewProject();
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.FieldLayoutPreferencePage");
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        FieldLayoutPreferencePageInfo page = (FieldLayoutPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "import org.eclipse.wb.swt.*;", "public class Test extends FieldLayoutPreferencePage {", "  public Test() {", "  }", "  public Control createPageContents(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    {", "      Composite composite = new Composite(container, SWT.NONE);", "      composite.setBounds(0, 0, 200, 25);", "      addField(new BooleanFieldEditor('', 'Boolean editor', composite));", "    }", "    {", "      Composite composite = new Composite(container, SWT.NONE);", "      composite.setBounds(50, 100, 200, 25);", "      addField(new StringFieldEditor('', 'String editor', composite));", "    }", "    return container;", "  }", "}");
        FieldLayoutPreferencePageTest.assertHierarchy("{this: org.eclipse.wb.swt.FieldLayoutPreferencePage} {this} {/addField(new BooleanFieldEditor('', 'Boolean editor', composite))/ /addField(new StringFieldEditor('', 'String editor', composite))/}", "  {parameter} {parent} {/new Composite(parent, SWT.NULL)/}", "    {new: org.eclipse.swt.widgets.Composite} {local-unique: container} {/new Composite(parent, SWT.NULL)/ /new Composite(container, SWT.NONE)/ /new Composite(container, SWT.NONE)/ /container/}", "      {implicit-layout: absolute} {implicit-layout} {}", "      {new: org.eclipse.swt.widgets.Composite} {local-unique: composite} {/new Composite(container, SWT.NONE)/ /composite.setBounds(0, 0, 200, 25)/ /new BooleanFieldEditor('', 'Boolean editor', composite)/}", "        {new: org.eclipse.jface.preference.BooleanFieldEditor} {empty} {/addField(new BooleanFieldEditor('', 'Boolean editor', composite))/}", "      {new: org.eclipse.swt.widgets.Composite} {local-unique: composite} {/new Composite(container, SWT.NONE)/ /composite.setBounds(50, 100, 200, 25)/ /new StringFieldEditor('', 'String editor', composite)/}", "        {new: org.eclipse.jface.preference.StringFieldEditor} {empty} {/addField(new StringFieldEditor('', 'String editor', composite))/}", "          {method: getLabelControl} {subComponent} {}", "          {method: getTextControl} {subComponent} {}");
        CompositeInfo parentComposite = (CompositeInfo)page.getChildrenJava().get(0);
        CompositeInfo containerComposite = (CompositeInfo)parentComposite.getChildrenControls().get(0);
        CompositeInfo composite_1 = (CompositeInfo)containerComposite.getChildrenControls().get(0);
        CompositeInfo composite_2 = (CompositeInfo)containerComposite.getChildrenControls().get(1);
        FieldEditorInfo editor_1 = (FieldEditorInfo)composite_1.getChildrenJava().get(0);
        FieldEditorInfo editor_2 = (FieldEditorInfo)composite_2.getChildrenJava().get(0);
        FieldLayoutPreferencePageTest.assertInstanceOf(EmptyAssociation.class, (Object)editor_1.getAssociation());
        FieldLayoutPreferencePageTest.assertInstanceOf(EmptyAssociation.class, (Object)editor_2.getAssociation());
        page.refresh();
        FieldLayoutPreferencePageTest.assertNoErrors((JavaInfo)page);
        FieldLayoutPreferencePageTest.assertEquals((long)composite_1.getBounds().width, (long)200L);
        FieldLayoutPreferencePageTest.assertEquals((long)composite_2.getBounds().width, (long)200L);
        Assertions.assertThat((int)editor_1.getBounds().width).isGreaterThanOrEqualTo(90);
        FieldLayoutPreferencePageTest.assertEquals((long)editor_2.getBounds().width, (long)200L);
        boolean[] visible = new boolean[]{true};
        ((ObjectInfoChildGraphical)page.getBroadcast(ObjectInfoChildGraphical.class)).invoke((ObjectInfo)editor_1, visible);
        FieldLayoutPreferencePageTest.assertFalse((boolean)visible[0]);
    }

    @Test
    public void test_CREATE() throws Exception {
        FieldLayoutPreferencePageInfo page = (FieldLayoutPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "import org.eclipse.wb.swt.*;", "public class Test extends FieldLayoutPreferencePage {", "  public Test() {", "  }", "  public Control createPageContents(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    return container;", "  }", "}");
        CompositeInfo parentComposite = (CompositeInfo)page.getChildrenJava().get(0);
        CompositeInfo containerComposite = (CompositeInfo)parentComposite.getChildrenControls().get(0);
        AbsoluteLayoutInfo layout = (AbsoluteLayoutInfo)containerComposite.getLayout();
        FieldEditorInfo newEditor = (FieldEditorInfo)FieldLayoutPreferencePageTest.createJavaInfo("org.eclipse.jface.preference.IntegerFieldEditor");
        CompositeInfo newComposite = page.schedule_CREATE(newEditor);
        layout.commandCreate((ControlInfo)newComposite, null);
        layout.commandChangeBounds((ControlInfo)newComposite, new Point(0, 0), new Dimension(200, 25));
        this.assertEditor("import org.eclipse.jface.preference.*;", "import org.eclipse.wb.swt.*;", "public class Test extends FieldLayoutPreferencePage {", "  public Test() {", "  }", "  public Control createPageContents(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    {", "      Composite composite = new Composite(container, SWT.NONE);", "      composite.setBounds(0, 0, 200, 25);", "      addField(new IntegerFieldEditor('id', 'New IntegerFieldEditor', composite));", "    }", "    return container;", "  }", "}");
        FieldLayoutPreferencePageTest.assertHierarchy("{this: org.eclipse.wb.swt.FieldLayoutPreferencePage} {this} {/addField(new IntegerFieldEditor('id', 'New IntegerFieldEditor', composite))/}", "  {parameter} {parent} {/new Composite(parent, SWT.NULL)/}", "    {new: org.eclipse.swt.widgets.Composite} {local-unique: container} {/new Composite(parent, SWT.NULL)/ /container/ /new Composite(container, SWT.NONE)/}", "      {implicit-layout: absolute} {implicit-layout} {}", "      {new: org.eclipse.swt.widgets.Composite} {local-unique: composite} {/new Composite(container, SWT.NONE)/ /new IntegerFieldEditor('id', 'New IntegerFieldEditor', composite)/ /composite.setBounds(0, 0, 200, 25)/}", "        {new: org.eclipse.jface.preference.IntegerFieldEditor} {empty} {/addField(new IntegerFieldEditor('id', 'New IntegerFieldEditor', composite))/}", "          {method: getLabelControl} {subComponent} {}", "          {method: getTextControl} {subComponent} {}");
        FieldLayoutPreferencePageTest.assertInstanceOf(EmptyAssociation.class, (Object)newEditor.getAssociation());
        newEditor.getPropertyByTitle("textLimit").setValue((Object)5);
        this.assertEditor("import org.eclipse.jface.preference.*;", "import org.eclipse.wb.swt.*;", "public class Test extends FieldLayoutPreferencePage {", "  public Test() {", "  }", "  public Control createPageContents(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    {", "      Composite composite = new Composite(container, SWT.NONE);", "      composite.setBounds(0, 0, 200, 25);", "      {", "        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor('id', 'New IntegerFieldEditor', composite);", "        integerFieldEditor.setTextLimit(5);", "        addField(integerFieldEditor);", "      }", "    }", "    return container;", "  }", "}");
    }

    @Test
    public void test_copyPaste() throws Exception {
        FieldLayoutPreferencePageInfo page = (FieldLayoutPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "import org.eclipse.wb.swt.*;", "public class Test extends FieldLayoutPreferencePage {", "  public Test() {", "  }", "  public Control createPageContents(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    {", "      Composite composite = new Composite(container, SWT.NONE);", "      composite.setBounds(0, 0, 200, 25);", "      addField(new BooleanFieldEditor('', 'Boolean editor', composite));", "    }", "    {", "      Composite composite = new Composite(container, SWT.NONE);", "      composite.setBounds(50, 100, 200, 25);", "      addField(new StringFieldEditor('', 'String editor', composite));", "    }", "    return container;", "  }", "}");
        page.refresh();
        CompositeInfo parentComposite = (CompositeInfo)page.getChildrenJava().get(0);
        CompositeInfo containerComposite = (CompositeInfo)parentComposite.getChildrenControls().get(0);
        CompositeInfo composite = (CompositeInfo)containerComposite.getChildrenControls().get(0);
        FieldEditorInfo fieldEditor = (FieldEditorInfo)composite.getChildrenJava().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)fieldEditor);
        FieldEditorInfo newFieldEditor = (FieldEditorInfo)memento.create((JavaInfo)page);
        AbsoluteLayoutInfo layout = (AbsoluteLayoutInfo)containerComposite.getLayout();
        CompositeInfo newComposite = page.schedule_CREATE(newFieldEditor);
        layout.commandCreate((ControlInfo)newComposite, null);
        layout.commandChangeBounds((ControlInfo)newComposite, new Point(50, 150), new Dimension(200, 25));
        memento.apply();
        this.assertEditor("import org.eclipse.jface.preference.*;", "import org.eclipse.wb.swt.*;", "public class Test extends FieldLayoutPreferencePage {", "  public Test() {", "  }", "  public Control createPageContents(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    {", "      Composite composite = new Composite(container, SWT.NONE);", "      composite.setBounds(0, 0, 200, 25);", "      addField(new BooleanFieldEditor('', 'Boolean editor', composite));", "    }", "    {", "      Composite composite = new Composite(container, SWT.NONE);", "      composite.setBounds(50, 100, 200, 25);", "      addField(new StringFieldEditor('', 'String editor', composite));", "    }", "    {", "      Composite composite = new Composite(container, SWT.NONE);", "      composite.setBounds(50, 150, 200, 25);", "      addField(new BooleanFieldEditor('', 'Boolean editor', composite));", "    }", "    return container;", "  }", "}");
    }

    @Test
    public void test_paletteTweaks_1() throws Exception {
        FieldLayoutPreferencePageInfo page = (FieldLayoutPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "import org.eclipse.wb.swt.*;", "public class Test extends FieldLayoutPreferencePage {", "  public Test() {", "  }", "  public Control createPageContents(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    return container;", "  }", "}");
        CategoryInfo systemCategory = new CategoryInfo("org.eclipse.wb.rcp.system");
        CategoryInfo editorsCategory = new CategoryInfo("org.eclipse.wb.rcp.fieldEditors");
        CategoryInfo otherCategory = new CategoryInfo("some.other.category");
        ArrayList categories = Lists.newArrayList((Object[])new CategoryInfo[]{systemCategory, editorsCategory, otherCategory});
        Assertions.assertThat((List)categories).hasSize(3);
        FieldLayoutPreferencePageTest.assertTrue((boolean)systemCategory.isVisible());
        FieldLayoutPreferencePageTest.assertTrue((boolean)editorsCategory.isVisible());
        FieldLayoutPreferencePageTest.assertTrue((boolean)otherCategory.isVisible());
        ((PaletteEventListener)page.getBroadcast(PaletteEventListener.class)).categories((List)categories);
        Assertions.assertThat((List)categories).hasSize(3);
        FieldLayoutPreferencePageTest.assertTrue((boolean)systemCategory.isVisible());
        FieldLayoutPreferencePageTest.assertTrue((boolean)editorsCategory.isVisible());
        FieldLayoutPreferencePageTest.assertTrue((boolean)otherCategory.isVisible());
    }
}

