/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms.table;

import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.ExposedPropertyCreationSupport;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapDataInfo;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutDataCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutDataVariableSupport;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.junit.Test;

public class TableWrapLayoutExposedTest
extends AbstractFormsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_deleteExposedComponent_noExplicitData() throws Exception {
        this.configureForDelete();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        CompositeInfo myComposite = (CompositeInfo)shell.getChildrenControls().get(0);
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)myComposite.getLayout();
        ControlInfo button = (ControlInfo)myComposite.getChildrenControls().get(0);
        TableWrapDataInfo layoutData = layout.getTableWrapData(button);
        TableWrapLayoutExposedTest.assertInstanceOf(ImplicitLayoutDataCreationSupport.class, (Object)layoutData.getCreationSupport());
        TableWrapLayoutExposedTest.assertInstanceOf(ImplicitLayoutDataVariableSupport.class, (Object)layoutData.getVariableSupport());
        TableWrapLayoutExposedTest.assertInstanceOf(ExposedPropertyCreationSupport.class, (Object)button.getCreationSupport());
        TableWrapLayoutExposedTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        TableWrapLayoutExposedTest.assertFalse((boolean)button.isDeleted());
        layoutData = layout.getTableWrapData(button);
        TableWrapLayoutExposedTest.assertInstanceOf(ImplicitLayoutDataCreationSupport.class, (Object)layoutData.getCreationSupport());
        TableWrapLayoutExposedTest.assertInstanceOf(ImplicitLayoutDataVariableSupport.class, (Object)layoutData.getVariableSupport());
    }

    @Test
    public void test_deleteExposedComponent_withExplicitData() throws Exception {
        this.configureForDelete();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "    myComposite.getButton().setLayoutData(new TableWrapData());", "  }", "}");
        shell.refresh();
        CompositeInfo myComposite = (CompositeInfo)shell.getChildrenControls().get(0);
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)myComposite.getLayout();
        ControlInfo button = (ControlInfo)myComposite.getChildrenControls().get(0);
        TableWrapDataInfo layoutData = layout.getTableWrapData(button);
        TableWrapLayoutExposedTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)layoutData.getCreationSupport());
        TableWrapLayoutExposedTest.assertInstanceOf(EmptyVariableSupport.class, (Object)layoutData.getVariableSupport());
        TableWrapLayoutExposedTest.assertInstanceOf(ExposedPropertyCreationSupport.class, (Object)button.getCreationSupport());
        TableWrapLayoutExposedTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        TableWrapLayoutExposedTest.assertTrue((boolean)myComposite.getChildren().contains(button));
        layoutData = layout.getTableWrapData(button);
        TableWrapLayoutExposedTest.assertInstanceOf(ImplicitLayoutDataCreationSupport.class, (Object)layoutData.getCreationSupport());
        TableWrapLayoutExposedTest.assertInstanceOf(ImplicitLayoutDataVariableSupport.class, (Object)layoutData.getVariableSupport());
    }

    @Test
    public void test_deleteWhenTwoExposed() throws Exception {
        this.createASTCompilationUnit("test", "MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private Button m_button;", "  private Text m_text;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    m_button = new Button(this, SWT.NONE);", "    m_text = new Text(this, SWT.NONE);", "  }", "  public Button getButton() {", "    return m_button;", "  }", "  public Text getText() {", "    return m_text;", "  }", "}"));
        TableWrapLayoutExposedTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        CompositeInfo myComposite = (CompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)myComposite.getChildrenControls().get(0);
        button.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
    }

    private void configureForDelete() throws Exception {
        this.createASTCompilationUnit("test", "MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private Button m_button;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    m_button = new Button(this, SWT.NONE);", "    m_button.setLayoutData(new TableWrapData(TableWrapData.FILL, TableWrapData.MIDDLE));", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        TableWrapLayoutExposedTest.waitForAutoBuild();
    }
}

