/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util;

import org.eclipse.wb.internal.core.editor.errors.CoreExceptionRewriter;
import org.eclipse.wb.internal.core.editor.errors.CoreExceptionRewriter2;
import org.eclipse.wb.internal.core.eval.evaluators.AnonymousEvaluationError;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.os.OSSupportError;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;

public class CoreExceptionRewriterTest
extends DesignerTestCase {
    @Test
    public void test_OSSupportError() throws Exception {
        OSSupportError e = new OSSupportError("foo");
        DesignerException rewritten = (DesignerException)CoreExceptionRewriter.INSTANCE.rewrite((Throwable)e);
        CoreExceptionRewriterTest.assertEquals((long)900L, (long)rewritten.getCode());
    }

    @Test
    public void test_AnonymousEvaluationError() throws Exception {
        AnonymousEvaluationError anError = new AnonymousEvaluationError();
        DesignerException rewritten = (DesignerException)CoreExceptionRewriter2.INSTANCE.rewrite((Throwable)anError);
        CoreExceptionRewriterTest.assertEquals((long)315L, (long)rewritten.getCode());
        Error wrapper = new Error("msg", (Throwable)anError);
        DesignerException rewritten2 = (DesignerException)CoreExceptionRewriter2.INSTANCE.rewrite((Throwable)wrapper);
        CoreExceptionRewriterTest.assertEquals((long)315L, (long)rewritten2.getCode());
        CoreExceptionRewriterTest.assertArrayEquals((Object[])rewritten2.getParameters(), (Object[])new String[]{"msg"});
    }

    private static boolean isIncompleteProductException(Throwable e) {
        Throwable rewritten = CoreExceptionRewriter.INSTANCE.rewrite(e);
        if (rewritten instanceof DesignerException) {
            DesignerException designerException = (DesignerException)rewritten;
            return designerException.getCode() == 2;
        }
        return false;
    }

    @Test
    public void test_isIncompleteProductException_differentException() throws Exception {
        Exception e = new Exception();
        CoreExceptionRewriterTest.assertFalse((boolean)CoreExceptionRewriterTest.isIncompleteProductException(e));
    }

    @Test
    public void test_isIncompleteProductException_NoClassDefFoundError() throws Exception {
        Error e = new NoClassDefFoundError("not/designer/Class");
        CoreExceptionRewriterTest.assertFalse((boolean)CoreExceptionRewriterTest.isIncompleteProductException(e));
        e = new NoClassDefFoundError("org/eclipse/wb/Foo");
        CoreExceptionRewriterTest.assertTrue((boolean)CoreExceptionRewriterTest.isIncompleteProductException(e));
        e = new Error(e);
        CoreExceptionRewriterTest.assertTrue((boolean)CoreExceptionRewriterTest.isIncompleteProductException(e));
        e = new NoClassDefFoundError("org/eclipse/jdt/core/dom/AnonymousTypeDeclaration2");
        CoreExceptionRewriterTest.assertTrue((boolean)CoreExceptionRewriterTest.isIncompleteProductException(e));
        e = new Error(e);
        CoreExceptionRewriterTest.assertTrue((boolean)CoreExceptionRewriterTest.isIncompleteProductException(e));
    }

    @Test
    public void test_isIncompleteProductException_NoSuchMethodError() throws Exception {
        Error e = new NoSuchMethodError("not.designer.Class.method()V");
        CoreExceptionRewriterTest.assertFalse((boolean)CoreExceptionRewriterTest.isIncompleteProductException(e));
        e = new NoSuchMethodError("org.eclipse.wb.Foo.bar()V");
        CoreExceptionRewriterTest.assertTrue((boolean)CoreExceptionRewriterTest.isIncompleteProductException(e));
        e = new Error(e);
        CoreExceptionRewriterTest.assertTrue((boolean)CoreExceptionRewriterTest.isIncompleteProductException(e));
    }
}

