/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls.ui;

import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wb.internal.core.nls.ui.NlsDialog;
import org.eclipse.wb.tests.designer.core.nls.ui.AbstractDialogTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class NlsDialogTest
extends AbstractDialogTest {
    @Test
    public void test_noSources() throws Exception {
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                NlsDialogTest.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
                NlsDialogTest.assertItems(tabFolder, new String[]{"Properties"});
            }
        });
    }

    @Test
    public void test_possibleSources() throws Exception {
        NlsDialogTest.setFileContentSrc("test/messages.properties", NlsDialogTest.getSourceDQ("#Direct ResourceBundle", "frame.title=My JFrame"));
        NlsDialogTest.setFileContentSrc("test/messages2.properties", NlsDialogTest.getSourceDQ("#Direct ResourceBundle", "frame.name=My name"));
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                NlsDialogTest.assertEquals((long)2L, (long)tabFolder.getSelectionIndex());
                TabItem[] tabItems = NlsDialogTest.assertItems(tabFolder, new String[]{"test.messages", "test.messages2", "Properties"});
                Table table = NlsDialogTest.getSourceTable(context, tabItems[0]);
                NlsDialogTest.assertColumns(table, new String[]{"Key", "(default)"});
                NlsDialogTest.assertItems(table, new String[][]{{"frame.title", "My JFrame"}});
                table = NlsDialogTest.getSourceTable(context, tabItems[1]);
                NlsDialogTest.assertColumns(table, new String[]{"Key", "(default)"});
                NlsDialogTest.assertItems(table, new String[][]{{"frame.name", "My name"}});
            }
        });
    }

    @Test
    public void test_existingSources() throws Exception {
        NlsDialogTest.setFileContentSrc("test/messages.properties", NlsDialogTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        NlsDialogTest.setFileContentSrc("test/messages_it.properties", NlsDialogTest.getSourceDQ("frame.title=My JFrame IT"));
        NlsDialogTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                NlsDialogTest.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
                TabItem[] tabItems = NlsDialogTest.assertItems(tabFolder, new String[]{"test.messages", "Properties"});
                Table table = NlsDialogTest.getSourceTable(context, tabItems[0]);
                NlsDialogTest.assertColumns(table, new String[]{"Key", "(default)", "it"});
                NlsDialogTest.assertItems(table, new String[][]{{"frame.name", "My name", ""}, {"frame.title", "My JFrame", "My JFrame IT"}});
            }
        });
    }
}

