/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.controls.palette.DesignerPaletteViewerPreferences;

public final class PluginPalettePreferences
extends DesignerPaletteViewerPreferences {
    private FontDescriptor m_categoryFont;
    private FontDescriptor m_entryFont;
    private String m_categoryFontKey;
    private String m_entryFontKey;
    private String m_minColumnsKey;

    public void setPrefix(String prefix) {
        this.m_categoryFontKey = prefix + ".category.font";
        this.m_entryFontKey = prefix + ".entry.font";
        this.m_minColumnsKey = prefix + ".columns.min";
        FontData[] defaultFontData = Display.getDefault().getSystemFont().getFontData()[0];
        FontData boldFontData = new FontData(defaultFontData.getName(), defaultFontData.getHeight(), 1);
        PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)this.m_categoryFontKey, (FontData)boldFontData);
        defaultFontData = Display.getDefault().getSystemFont().getFontData();
        PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)this.m_entryFontKey, (FontData[])defaultFontData);
        this.getPreferenceStore().setDefault(this.m_minColumnsKey, 2);
    }

    protected void handlePreferenceStorePropertyChanged(String property) {
        if (property.equals(this.m_categoryFontKey)) {
            this.firePropertyChanged(property, this.getCategoryFontDescriptor());
        } else if (property.equals(this.m_entryFontKey)) {
            this.firePropertyChanged(property, this.getEntryFontDescriptor());
        } else if (property.equals(this.m_minColumnsKey)) {
            this.firePropertyChanged(property, this.getMinColumns());
        } else {
            super.handlePreferenceStorePropertyChanged(property);
        }
    }

    public FontDescriptor getCategoryFontDescriptor() {
        if (this.m_categoryFont == null) {
            FontData[] fontDataArray = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)this.m_categoryFontKey);
            this.m_categoryFont = FontDescriptor.createFrom((FontData[])fontDataArray);
        }
        return this.m_categoryFont;
    }

    public FontDescriptor getEntryFontDescriptor() {
        if (this.m_entryFont == null) {
            FontData[] fontDataArray = PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)this.m_entryFontKey);
            this.m_entryFont = FontDescriptor.createFrom((FontData[])fontDataArray);
        }
        return this.m_entryFont;
    }

    public int getMinColumns() {
        return this.getPreferenceStore().getInt(this.m_minColumnsKey);
    }

    public void setCategoryFont(FontData[] fontDataArray) {
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.m_categoryFontKey, (FontData[])fontDataArray);
        this.m_categoryFont = null;
    }

    public void setEntryFont(FontData[] fontDataArray) {
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.m_entryFontKey, (FontData[])fontDataArray);
        this.m_entryFont = null;
    }

    public void setMinColumns(int minColumns) {
        this.getPreferenceStore().setValue(this.m_minColumnsKey, minColumns);
    }
}

