/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.editor.color;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wb.core.editor.constants.IColorChooserPreferenceConstants;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.osgi.service.prefs.Preferences;

public class ColorChooserPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Preferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.wb.colorchooser.preferences");
    protected Preferences prefs = this.preferences.node("org.eclipse.wb.colorchooser.preferences.swing");
    Button cbxIncludeCustomColor;
    Button cbxIncludeSystemColor;
    Button cbxIncludeNamedColors;
    Button cbxIncludeWebSafeColors;
    protected String prefPrefix = "";
    protected final Map<String, Boolean> defaultPreferences = new HashMap<String, Boolean>();
    private Group grpInclude;

    public ColorChooserPreferences() {
    }

    public ColorChooserPreferences(String title) {
        super(title);
    }

    public ColorChooserPreferences(String title, ImageDescriptor image) {
        super(title, image);
        this.setPersistedPreferencesToUI();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(container, 0);
        RowLayout rl_composite = new RowLayout(256);
        composite.setLayout((Layout)rl_composite);
        this.grpInclude = new Group(composite, 0);
        this.grpInclude.setText(ModelMessages.ColorPreferenceChooser_Include);
        this.grpInclude.setLayout((Layout)new RowLayout(512));
        this.createPreferenceCheckboxes(this.grpInclude);
        this.setPersistedPreferencesToUI();
        return container;
    }

    protected void createPreferenceCheckboxes(Group groupLayout) {
        this.cbxIncludeCustomColor = new Button((Composite)this.grpInclude, 32);
        this.cbxIncludeCustomColor.setText(IColorChooserPreferenceConstants.CUSTOM_COLORS);
        this.cbxIncludeSystemColor = new Button((Composite)this.grpInclude, 32);
        this.cbxIncludeSystemColor.setText(IColorChooserPreferenceConstants.SYSTEM_COLORS);
        this.cbxIncludeNamedColors = new Button((Composite)this.grpInclude, 32);
        this.cbxIncludeNamedColors.setText(IColorChooserPreferenceConstants.NAMED_COLORS);
        this.cbxIncludeWebSafeColors = new Button((Composite)this.grpInclude, 32);
        this.cbxIncludeWebSafeColors.setText(IColorChooserPreferenceConstants.WEBSAFE_COLORS);
    }

    protected void setPersistedPreferencesToUI() {
        this.cbxIncludeCustomColor.setSelection(this.prefs.getBoolean(this.prefPrefix + "customColor", this.defaultPreferences.get(this.prefPrefix + "customColor").booleanValue()));
        this.cbxIncludeSystemColor.setSelection(this.prefs.getBoolean(this.prefPrefix + "sysColor", this.defaultPreferences.get(this.prefPrefix + "sysColor").booleanValue()));
        this.cbxIncludeNamedColors.setSelection(this.prefs.getBoolean(this.prefPrefix + "namedColor", this.defaultPreferences.get(this.prefPrefix + "namedColor").booleanValue()));
        this.cbxIncludeWebSafeColors.setSelection(this.prefs.getBoolean(this.prefPrefix + "webSafeColor", this.defaultPreferences.get(this.prefPrefix + "webSafeColor").booleanValue()));
    }

    protected void performApply() {
        this.prefs.putBoolean(this.prefPrefix + "customColor", this.cbxIncludeCustomColor.getSelection());
        this.prefs.putBoolean(this.prefPrefix + "sysColor", this.cbxIncludeSystemColor.getSelection());
        this.prefs.putBoolean(this.prefPrefix + "namedColor", this.cbxIncludeNamedColors.getSelection());
        this.prefs.putBoolean(this.prefPrefix + "webSafeColor", this.cbxIncludeWebSafeColors.getSelection());
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    protected void setPreferenceDefaults() {
        this.prefs.putBoolean(this.prefPrefix + "customColor", this.defaultPreferences.get(this.prefPrefix + "customColor").booleanValue());
        this.prefs.putBoolean(this.prefPrefix + "sysColor", this.defaultPreferences.get(this.prefPrefix + "sysColor").booleanValue());
        this.prefs.putBoolean(this.prefPrefix + "namedColor", this.defaultPreferences.get(this.prefPrefix + "namedColor").booleanValue());
        this.prefs.putBoolean(this.prefPrefix + "webSafeColor", this.defaultPreferences.get(this.prefPrefix + "webSafeColor").booleanValue());
    }

    protected void performDefaults() {
        this.cbxIncludeCustomColor.setSelection(this.defaultPreferences.get(this.prefPrefix + "customColor").booleanValue());
        this.cbxIncludeSystemColor.setSelection(this.defaultPreferences.get(this.prefPrefix + "sysColor").booleanValue());
        this.cbxIncludeNamedColors.setSelection(this.defaultPreferences.get(this.prefPrefix + "namedColor").booleanValue());
        this.cbxIncludeWebSafeColors.setSelection(this.defaultPreferences.get(this.prefPrefix + "webSafeColor").booleanValue());
    }

    protected void setPrefPrefix(String prefPrefix) {
        this.prefPrefix = prefPrefix;
    }
}

