/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.jvm;

import io.github.toolfactory.jvm.util.Classes;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.burningwave.jvm.util.Libraries;

public class NativeExecutor {
    private static final NativeExecutor INSTANCE;

    private NativeExecutor() {
    }

    public static final NativeExecutor getInstance() {
        return INSTANCE;
    }

    public Object getFieldValue(Object target, Field field) {
        NativeExecutor.check(field, "Field is null");
        Class<?> fieldType = field.getType();
        if (Modifier.isStatic(field.getModifiers())) {
            target = field.getDeclaringClass();
            if (!fieldType.isPrimitive()) {
                return this.getStaticObjectFieldValue0(target, field);
            }
            if (fieldType == Short.TYPE) {
                return this.getStaticShortFieldValue0(target, field);
            }
            if (fieldType == Integer.TYPE) {
                return this.getStaticIntegerFieldValue0(target, field);
            }
            if (fieldType == Long.TYPE) {
                return this.getStaticLongFieldValue0(target, field);
            }
            if (fieldType == Float.TYPE) {
                return Float.valueOf(this.getStaticFloatFieldValue0(target, field));
            }
            if (fieldType == Double.TYPE) {
                return this.getStaticDoubleFieldValue0(target, field);
            }
            if (fieldType == Boolean.TYPE) {
                return this.getStaticBooleanFieldValue0(target, field);
            }
            if (fieldType == Byte.TYPE) {
                return this.getStaticByteFieldValue0(target, field);
            }
            return Character.valueOf(this.getStaticCharacterFieldValue0(target, field));
        }
        NativeExecutor.check(target, "Target object is null");
        Class<?> fieldDeclaringClass = field.getDeclaringClass();
        Class<?> targetObjectClass = target.getClass();
        if (!Classes.isAssignableFrom(fieldDeclaringClass, targetObjectClass)) {
            throw new IllegalArgumentException("Target object class " + targetObjectClass + " is not assignable to " + fieldDeclaringClass);
        }
        if (!fieldType.isPrimitive()) {
            return this.getObjectFieldValue0(target, field);
        }
        if (fieldType == Short.TYPE) {
            return this.getShortFieldValue0(target, field);
        }
        if (fieldType == Integer.TYPE) {
            return this.getIntegerFieldValue0(target, field);
        }
        if (fieldType == Long.TYPE) {
            return this.getLongFieldValue0(target, field);
        }
        if (fieldType == Float.TYPE) {
            return Float.valueOf(this.getFloatFieldValue0(target, field));
        }
        if (fieldType == Double.TYPE) {
            return this.getDoubleFieldValue0(target, field);
        }
        if (fieldType == Boolean.TYPE) {
            return this.getBooleanFieldValue0(target, field);
        }
        if (fieldType == Byte.TYPE) {
            return this.getByteFieldValue0(target, field);
        }
        return Character.valueOf(this.getCharacterFieldValue0(target, field));
    }

    public void setFieldValue(Object origTarget, Field field, Object value) {
        Class<?> target;
        NativeExecutor.check(field, "Field is null");
        if (value != null && !Classes.isAssignableFrom(field.getType(), value.getClass())) {
            throw new IllegalArgumentException("Value " + value + " is not assignable to " + field.getName());
        }
        Class<?> fieldType = field.getType();
        Class<?> clazz = target = Modifier.isStatic(field.getModifiers()) ? field.getDeclaringClass() : origTarget;
        if (Modifier.isStatic(field.getModifiers())) {
            target = field.getDeclaringClass();
            if (!fieldType.isPrimitive()) {
                this.setStaticObjectFieldValue0(target, field, value);
            } else if (fieldType == Short.TYPE) {
                this.setStaticShortFieldValue0(target, field, (Short)value);
            } else if (fieldType == Integer.TYPE) {
                this.setStaticIntegerFieldValue0(target, field, (Integer)value);
            } else if (fieldType == Long.TYPE) {
                this.setStaticLongFieldValue0(target, field, (Long)value);
            } else if (fieldType == Float.TYPE) {
                this.setStaticFloatFieldValue0(target, field, ((Float)value).floatValue());
            } else if (fieldType == Double.TYPE) {
                this.setStaticDoubleFieldValue0(target, field, (Double)value);
            } else if (fieldType == Boolean.TYPE) {
                this.setStaticBooleanFieldValue0(target, field, (Boolean)value);
            } else if (fieldType == Byte.TYPE) {
                this.setStaticByteFieldValue0(target, field, (Byte)value);
            } else {
                this.setStaticCharacterFieldValue0(target, field, ((Character)value).charValue());
            }
        } else {
            NativeExecutor.check(target, "Target object is null");
            Class<?> fieldDeclaringClass = field.getDeclaringClass();
            Class<?> targetObjectClass = target.getClass();
            if (!Classes.isAssignableFrom(fieldDeclaringClass, targetObjectClass)) {
                throw new IllegalArgumentException("Target object class " + targetObjectClass + " is not assignable to " + fieldDeclaringClass);
            }
            if (!fieldType.isPrimitive()) {
                this.setObjectFieldValue0(target, field, value);
            } else if (fieldType == Short.TYPE) {
                this.setShortFieldValue0(target, field, (Short)value);
            } else if (fieldType == Integer.TYPE) {
                this.setIntegerFieldValue0(target, field, (Integer)value);
            } else if (fieldType == Long.TYPE) {
                this.setLongFieldValue0(target, field, (Long)value);
            } else if (fieldType == Float.TYPE) {
                this.setFloatFieldValue0(target, field, ((Float)value).floatValue());
            } else if (fieldType == Double.TYPE) {
                this.setDoubleFieldValue0(target, field, (Double)value);
            } else if (fieldType == Boolean.TYPE) {
                this.setBooleanFieldValue0(target, field, (Boolean)value);
            } else if (fieldType == Byte.TYPE) {
                this.setByteFieldValue0(target, field, (Byte)value);
            } else {
                this.setCharacterFieldValue0(target, field, ((Character)value).charValue());
            }
        }
    }

    public Field getDeclaredField(Class<?> target, String name, String signature) {
        return this.getDeclaredField(NativeExecutor.check(target, "Target class is null"), NativeExecutor.check(name, "Field name is null"), NativeExecutor.check(signature, "Field signature is null"), false);
    }

    public Field getDeclaredStaticField(Class<?> target, String name, String signature) {
        return this.getDeclaredField(NativeExecutor.check(target, "Target class is null"), NativeExecutor.check(name, "Field name is null"), NativeExecutor.check(signature, "Field signature is null"), true);
    }

    private static <T> T check(T input, String message) {
        if (input == null) {
            throw new IllegalArgumentException(message);
        }
        return input;
    }

    private static void checkGet0(Class<?> returnType, Field field) {
        NativeExecutor.check(field, "Field is null");
        Class<?> fieldType = field.getType();
        if (!returnType.isAssignableFrom(fieldType)) {
            throw new IllegalArgumentException("Return type " + returnType + " is not assignable from " + fieldType);
        }
    }

    private static void checkTargetAndField(Object target, Field field) {
        NativeExecutor.check(target, "Target object is null");
        Class<?> fieldDeclaringClass = field.getDeclaringClass();
        Class<?> targetObjectClass = target.getClass();
        if (!fieldDeclaringClass.isAssignableFrom(targetObjectClass)) {
            throw new IllegalArgumentException("Target " + targetObjectClass + " is not assignable to " + fieldDeclaringClass);
        }
    }

    private static void checkGet(Class<?> returnType, Object target, Field field) {
        NativeExecutor.checkGet0(returnType, field);
        NativeExecutor.checkTargetAndField(target, field);
    }

    public Object getObjectFieldValue(Object target, Field field) {
        NativeExecutor.checkGet(Object.class, target, field);
        return this.getObjectFieldValue0(target, field);
    }

    public short getShortFieldValue(Object target, Field field) {
        NativeExecutor.checkGet(Short.TYPE, target, field);
        return this.getShortFieldValue0(target, field);
    }

    public int getIntFieldValue(Object target, Field field) {
        NativeExecutor.checkGet(Integer.TYPE, target, field);
        return this.getIntegerFieldValue0(target, field);
    }

    public long getLongFieldValue(Object target, Field field) {
        NativeExecutor.checkGet(Long.TYPE, target, field);
        return this.getLongFieldValue0(target, field);
    }

    public float getFloatFieldValue(Object target, Field field) {
        NativeExecutor.checkGet(Float.TYPE, target, field);
        return this.getFloatFieldValue0(target, field);
    }

    public double getDoubleFieldValue(Object target, Field field) {
        NativeExecutor.checkGet(Double.TYPE, target, field);
        return this.getDoubleFieldValue0(target, field);
    }

    public boolean getBooleanFieldValue(Object target, Field field) {
        NativeExecutor.checkGet(Boolean.TYPE, target, field);
        return this.getBooleanFieldValue0(target, field);
    }

    public byte getByteFieldValue(Object target, Field field) {
        NativeExecutor.checkGet(Byte.TYPE, target, field);
        return this.getByteFieldValue0(target, field);
    }

    public char getCharFieldValue(Object target, Field field) {
        NativeExecutor.checkGet(Character.TYPE, target, field);
        return this.getCharacterFieldValue0(target, field);
    }

    private static void checkStaticGet(Class<?> returnType, Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Field " + field + " is not static");
        }
        NativeExecutor.checkGet0(returnType, field);
    }

    public Object getStaticObjectFieldValue(Field field) {
        NativeExecutor.checkStaticGet(Object.class, field);
        return this.getStaticObjectFieldValue0(field.getDeclaringClass(), field);
    }

    public short getStaticShortFieldValue(Field field) {
        NativeExecutor.checkStaticGet(Short.TYPE, field);
        return this.getStaticShortFieldValue0(field.getDeclaringClass(), field);
    }

    public int getStaticIntFieldValue(Field field) {
        NativeExecutor.checkStaticGet(Integer.TYPE, field);
        return this.getStaticIntegerFieldValue0(field.getDeclaringClass(), field);
    }

    public long getStaticLongFieldValue(Field field) {
        NativeExecutor.checkStaticGet(Long.TYPE, field);
        return this.getStaticLongFieldValue0(field.getDeclaringClass(), field);
    }

    public float getStaticFloatFieldValue(Field field) {
        NativeExecutor.checkStaticGet(Float.TYPE, field);
        return this.getStaticFloatFieldValue0(field.getDeclaringClass(), field);
    }

    public double getStaticDoubleFieldValue(Field field) {
        NativeExecutor.checkStaticGet(Double.TYPE, field);
        return this.getStaticDoubleFieldValue0(field.getDeclaringClass(), field);
    }

    public boolean getStaticBooleanFieldValue(Field field) {
        NativeExecutor.checkStaticGet(Boolean.TYPE, field);
        return this.getStaticBooleanFieldValue0(field.getDeclaringClass(), field);
    }

    public byte getStaticByteFieldValue(Field field) {
        NativeExecutor.checkStaticGet(Byte.TYPE, field);
        return this.getStaticByteFieldValue0(field.getDeclaringClass(), field);
    }

    public char getStaticCharFieldValue(Field field) {
        NativeExecutor.checkStaticGet(Character.TYPE, field);
        return this.getStaticCharacterFieldValue0(field.getDeclaringClass(), field);
    }

    private static void checkSet0(Class<?> valueType, Field field) {
        NativeExecutor.check(field, "Field is null");
        Class<?> fieldType = field.getType();
        if (!fieldType.isAssignableFrom(valueType)) {
            throw new IllegalArgumentException("Field type " + fieldType + " is not assignable from " + valueType);
        }
    }

    private static void checkSet(Class<?> valueType, Object target, Field field) {
        NativeExecutor.checkGet0(valueType, field);
        NativeExecutor.checkTargetAndField(target, field);
    }

    public void setObjectFieldValue(Object target, Field field, Object value) {
        if (null == value) {
            if (field.getType().isPrimitive()) {
                throw new IllegalArgumentException("Field type " + field.getType() + " is not assignable from " + Object.class);
            }
            NativeExecutor.checkTargetAndField(target, field);
        } else {
            NativeExecutor.checkSet(value.getClass(), target, field);
        }
        this.setObjectFieldValue0(target, field, value);
    }

    public void setShortFieldValue(Object target, Field field, short value) {
        NativeExecutor.checkSet(Short.TYPE, target, field);
        this.setShortFieldValue0(target, field, value);
    }

    public void setIntFieldValue(Object target, Field field, int value) {
        NativeExecutor.checkSet(Integer.TYPE, target, field);
        this.setIntegerFieldValue0(target, field, value);
    }

    public void setLongFieldValue(Object target, Field field, long value) {
        NativeExecutor.checkSet(Long.TYPE, target, field);
        this.setLongFieldValue0(target, field, value);
    }

    public void setFloatFieldValue(Object target, Field field, float value) {
        NativeExecutor.checkSet(Float.TYPE, target, field);
        this.setFloatFieldValue0(target, field, value);
    }

    public void setDoubleFieldValue(Object target, Field field, double value) {
        NativeExecutor.checkSet(Double.TYPE, target, field);
        this.setDoubleFieldValue0(target, field, value);
    }

    public void setBooleanFieldValue(Object target, Field field, boolean value) {
        NativeExecutor.checkSet(Boolean.TYPE, target, field);
        this.setBooleanFieldValue0(target, field, value);
    }

    public void setByteFieldValue(Object target, Field field, byte value) {
        NativeExecutor.checkSet(Byte.TYPE, target, field);
        this.setByteFieldValue0(target, field, value);
    }

    public void setCharFieldValue(Object target, Field field, char value) {
        NativeExecutor.checkSet(Character.TYPE, target, field);
        this.setCharacterFieldValue0(target, field, value);
    }

    private static void checkStaticSet(Class<?> valueType, Field field) {
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Field " + field + " is not static");
        }
        NativeExecutor.checkGet0(valueType, field);
    }

    public void setStaticObjectFieldValue(Field field, Object value) {
        if (null == value) {
            if (field.getType().isPrimitive()) {
                throw new IllegalArgumentException("Field type " + field.getType() + " is not assignable from " + Object.class);
            }
        } else {
            NativeExecutor.checkStaticSet(value.getClass(), field);
        }
        this.setStaticObjectFieldValue0(field.getDeclaringClass(), field, value);
    }

    public void setStaticShortFieldValue(Field field, short value) {
        NativeExecutor.checkStaticSet(Short.TYPE, field);
        this.setStaticShortFieldValue0(field.getDeclaringClass(), field, value);
    }

    public void setStaticIntFieldValue(Field field, int value) {
        NativeExecutor.checkStaticSet(Integer.TYPE, field);
        this.setStaticIntegerFieldValue0(field.getDeclaringClass(), field, value);
    }

    public void setStaticLongFieldValue(Field field, long value) {
        NativeExecutor.checkStaticSet(Long.TYPE, field);
        this.setStaticLongFieldValue0(field.getDeclaringClass(), field, value);
    }

    public void setStaticFloatFieldValue(Field field, float value) {
        NativeExecutor.checkStaticSet(Float.TYPE, field);
        this.setStaticFloatFieldValue0(field.getDeclaringClass(), field, value);
    }

    public void setStaticDoubleFieldValue(Field field, double value) {
        NativeExecutor.checkStaticSet(Double.TYPE, field);
        this.setStaticDoubleFieldValue0(field.getDeclaringClass(), field, value);
    }

    public void setStaticBooleanFieldValue(Field field, boolean value) {
        NativeExecutor.checkStaticSet(Boolean.TYPE, field);
        this.setStaticBooleanFieldValue0(field.getDeclaringClass(), field, value);
    }

    public void setStaticByteFieldValue(Field field, byte value) {
        NativeExecutor.checkStaticSet(Byte.TYPE, field);
        this.setStaticByteFieldValue0(field.getDeclaringClass(), field, value);
    }

    public void setStaticCharFieldValue(Field field, char value) {
        NativeExecutor.checkStaticSet(Character.TYPE, field);
        this.setStaticCharacterFieldValue0(field.getDeclaringClass(), field, value);
    }

    public native Object allocateInstance(Class<?> var1);

    public native void throwException(Throwable var1);

    private native Object getObjectFieldValue0(Object var1, Field var2);

    private native short getShortFieldValue0(Object var1, Field var2);

    private native int getIntegerFieldValue0(Object var1, Field var2);

    private native long getLongFieldValue0(Object var1, Field var2);

    private native float getFloatFieldValue0(Object var1, Field var2);

    private native double getDoubleFieldValue0(Object var1, Field var2);

    private native boolean getBooleanFieldValue0(Object var1, Field var2);

    private native byte getByteFieldValue0(Object var1, Field var2);

    private native char getCharacterFieldValue0(Object var1, Field var2);

    private native Object getStaticObjectFieldValue0(Class<?> var1, Field var2);

    private native short getStaticShortFieldValue0(Class<?> var1, Field var2);

    private native int getStaticIntegerFieldValue0(Class<?> var1, Field var2);

    private native long getStaticLongFieldValue0(Class<?> var1, Field var2);

    private native float getStaticFloatFieldValue0(Class<?> var1, Field var2);

    private native double getStaticDoubleFieldValue0(Class<?> var1, Field var2);

    private native boolean getStaticBooleanFieldValue0(Class<?> var1, Field var2);

    private native byte getStaticByteFieldValue0(Class<?> var1, Field var2);

    private native char getStaticCharacterFieldValue0(Class<?> var1, Field var2);

    private native void setObjectFieldValue0(Object var1, Field var2, Object var3);

    private native void setShortFieldValue0(Object var1, Field var2, short var3);

    private native void setIntegerFieldValue0(Object var1, Field var2, int var3);

    private native void setLongFieldValue0(Object var1, Field var2, long var3);

    private native void setFloatFieldValue0(Object var1, Field var2, float var3);

    private native void setDoubleFieldValue0(Object var1, Field var2, double var3);

    private native void setBooleanFieldValue0(Object var1, Field var2, boolean var3);

    private native void setByteFieldValue0(Object var1, Field var2, byte var3);

    private native void setCharacterFieldValue0(Object var1, Field var2, char var3);

    private native void setStaticObjectFieldValue0(Class<?> var1, Field var2, Object var3);

    private native void setStaticShortFieldValue0(Class<?> var1, Field var2, short var3);

    private native void setStaticIntegerFieldValue0(Class<?> var1, Field var2, int var3);

    private native void setStaticLongFieldValue0(Class<?> var1, Field var2, long var3);

    private native void setStaticFloatFieldValue0(Class<?> var1, Field var2, float var3);

    private native void setStaticDoubleFieldValue0(Class<?> var1, Field var2, double var3);

    private native void setStaticBooleanFieldValue0(Class<?> var1, Field var2, boolean var3);

    private native void setStaticByteFieldValue0(Class<?> var1, Field var2, byte var3);

    private native void setStaticCharacterFieldValue0(Class<?> var1, Field var2, char var3);

    private native Field getDeclaredField(Class<?> var1, String var2, String var3, boolean var4);

    static {
        try {
            if (Initializer.nativeLibraryName == null) {
                Initializer.setNativeLibraryName(Libraries.getInstance().loadFor(NativeExecutor.class));
            } else {
                System.loadLibrary(Initializer.nativeLibraryName);
            }
        }
        catch (Throwable exc) {
            throw new ExceptionInInitializerError(exc);
        }
        INSTANCE = new NativeExecutor();
    }

    public static class Initializer {
        private static String nativeLibraryName;

        private static void setNativeLibraryName(String name) {
            if (nativeLibraryName != null) {
                throw new IllegalStateException("NativeExecutor is already initialized");
            }
            nativeLibraryName = name;
        }

        public static NativeExecutor setNativeLibraryNameAndInit(String name) {
            Initializer.setNativeLibraryName(name);
            return NativeExecutor.getInstance();
        }
    }
}

