/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormSpecs;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.layout.GeneralLayoutData;
import org.eclipse.wb.internal.core.model.util.grid.GridConvertionHelper;
import org.eclipse.wb.internal.swing.FormLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.FormLayout.model.FormColumnInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormRowInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeConstantInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;

public class FormLayoutConverter {
    private FormLayoutConverter() {
    }

    public static void convert(ContainerInfo parent, FormLayoutInfo layout) throws Exception {
        FormDimensionInfo dimension;
        List columns = GridConvertionHelper.buildGroups((List)parent.getChildrenComponents(), (boolean)true);
        List rows = GridConvertionHelper.buildGroups((List)parent.getChildrenComponents(), (boolean)false);
        GridConvertionHelper.sortGroupsByTranspose((List)columns, (List)rows);
        GridConvertionHelper.sortGroupsByTranspose((List)rows, (List)columns);
        GridConvertionHelper.sortGroups((List)columns);
        GridConvertionHelper.sortGroups((List)rows);
        GridConvertionHelper.updateBoundsGaps((List)columns, (boolean)true);
        GridConvertionHelper.updateBoundsGaps((List)rows, (boolean)true);
        FormLayoutConverter.createDimensions(layout, columns, true);
        FormLayoutConverter.createDimensions(layout, rows, false);
        HashSet<GridConvertionHelper.ComponentInGroup> componentsInGroups = new HashSet<GridConvertionHelper.ComponentInGroup>();
        for (GridConvertionHelper.ComponentGroup column : columns) {
            for (GridConvertionHelper.ComponentInGroup componentInGroup : column.getComponents()) {
                componentsInGroups.add(componentInGroup);
            }
        }
        for (GridConvertionHelper.ComponentInGroup componentInGroup : componentsInGroups) {
            ComponentInfo component = (ComponentInfo)componentInGroup.getComponent();
            GeneralLayoutData generalLayoutData = GeneralLayoutData.getFromInfoEx((ObjectInfo)component);
            CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(component);
            GridConvertionHelper.ComponentGroup beginColumn = GridConvertionHelper.getBeginForComponent((List)columns, (GridConvertionHelper.ComponentInGroup)componentInGroup);
            GridConvertionHelper.ComponentGroup endColumn = GridConvertionHelper.getEndForComponent((List)columns, (GridConvertionHelper.ComponentInGroup)componentInGroup);
            GridConvertionHelper.ComponentGroup beginRow = GridConvertionHelper.getBeginForComponent((List)rows, (GridConvertionHelper.ComponentInGroup)componentInGroup);
            GridConvertionHelper.ComponentGroup endRow = GridConvertionHelper.getEndForComponent((List)rows, (GridConvertionHelper.ComponentInGroup)componentInGroup);
            int x = columns.indexOf(beginColumn);
            int y = rows.indexOf(beginRow);
            int sx = 1 + columns.indexOf(endColumn) - x;
            int sy = 1 + rows.indexOf(endRow) - y;
            constraints.x = 1 + x;
            constraints.y = 1 + y;
            constraints.width = sx;
            constraints.height = sy;
            constraints.alignH = FormLayoutConverter.getHorizontalAlignment(columns, componentInGroup, generalLayoutData);
            constraints.alignV = FormLayoutConverter.getVerticalAlignment(rows, componentInGroup, generalLayoutData);
            constraints.write();
        }
        List<FormDimensionInfo> dimensions = layout.getColumns();
        int[] counts = layout.getColumnComponentsCounts();
        int i = 0;
        while (i < dimensions.size()) {
            if (counts[i] == 0) {
                dimension = dimensions.get(i);
                dimension.convertToNearestGap(5);
            }
            ++i;
        }
        dimensions = layout.getRows();
        counts = layout.getRowComponentsCounts();
        i = 0;
        while (i < dimensions.size()) {
            if (counts[i] == 0) {
                dimension = dimensions.get(i);
                dimension.convertToNearestGap(5);
            }
            ++i;
        }
        layout.writeDimensions();
    }

    private static void createDimensions(FormLayoutInfo layout, List<GridConvertionHelper.ComponentGroup> groups, boolean horizontal) throws Exception {
        for (GridConvertionHelper.ComponentGroup group : groups) {
            FormDimensionInfo dimension;
            if (horizontal) {
                FormColumnInfo column = new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC);
                layout.getColumns().add(column);
                dimension = column;
            } else {
                FormRowInfo row = new FormRowInfo(FormSpecs.DEFAULT_ROWSPEC);
                layout.getRows().add(row);
                dimension = row;
            }
            FormSizeInfo size = dimension.getSize();
            size.setConstantSize(new FormSizeConstantInfo(group.getSize(), ConstantSize.PIXEL));
        }
    }

    private static CellConstraints.Alignment getHorizontalAlignment(List<GridConvertionHelper.ComponentGroup> columns, GridConvertionHelper.ComponentInGroup componentInGroup, GeneralLayoutData generalLayoutData) {
        CellConstraints.Alignment alignment;
        if (generalLayoutData.horizontalAlignment != null && (alignment = (CellConstraints.Alignment)GeneralLayoutData.getRealValue(FormLayoutInfo.m_horizontalAlignmentMap, (Object)generalLayoutData.horizontalAlignment)) != null && alignment != CellConstraints.DEFAULT) {
            return alignment;
        }
        IAbstractComponentInfo component = componentInGroup.getComponent();
        GridConvertionHelper.ComponentGroup beginColumn = GridConvertionHelper.getBeginForComponent(columns, (GridConvertionHelper.ComponentInGroup)componentInGroup);
        GridConvertionHelper.ComponentGroup endColumn = GridConvertionHelper.getEndForComponent(columns, (GridConvertionHelper.ComponentInGroup)componentInGroup);
        int columnLeft = beginColumn.getMin();
        int columnRight = endColumn.getMax();
        int columnCenter = columnLeft + (columnRight - columnLeft) / 2;
        Rectangle bounds = component.getBounds();
        Dimension prefSize = component.getPreferredSize();
        int bl = bounds.x;
        int br = bounds.right();
        int leftOffset = Math.abs(bl - columnLeft);
        int rightOffset = Math.abs(columnRight - br);
        int leftDelta = leftOffset + Math.abs(columnLeft + prefSize.width - br);
        int rightDelta = rightOffset + Math.abs(columnRight - prefSize.width - bl);
        int fillDelta = leftOffset + rightOffset;
        int centerDelta = Math.abs(bl - (columnCenter - prefSize.width / 2)) + Math.abs(br - (columnCenter + prefSize.width / 2));
        return FormLayoutConverter.getAlignment(new int[]{leftDelta, centerDelta, rightDelta, fillDelta}, new CellConstraints.Alignment[]{CellConstraints.LEFT, CellConstraints.CENTER, CellConstraints.RIGHT, CellConstraints.FILL});
    }

    private static CellConstraints.Alignment getVerticalAlignment(List<GridConvertionHelper.ComponentGroup> rows, GridConvertionHelper.ComponentInGroup componentInGroup, GeneralLayoutData generalLayoutData) {
        CellConstraints.Alignment alignment;
        if (generalLayoutData.verticalAlignment != null && (alignment = (CellConstraints.Alignment)GeneralLayoutData.getRealValue(FormLayoutInfo.m_verticalAlignmentMap, (Object)generalLayoutData.verticalAlignment)) != null && alignment != CellConstraints.DEFAULT) {
            return alignment;
        }
        IAbstractComponentInfo component = componentInGroup.getComponent();
        GridConvertionHelper.ComponentGroup beginRow = GridConvertionHelper.getBeginForComponent(rows, (GridConvertionHelper.ComponentInGroup)componentInGroup);
        GridConvertionHelper.ComponentGroup endRow = GridConvertionHelper.getEndForComponent(rows, (GridConvertionHelper.ComponentInGroup)componentInGroup);
        Rectangle bounds = component.getBounds();
        Dimension prefSize = component.getPreferredSize();
        int bt = bounds.y;
        int bb = bounds.bottom();
        int rowTop = beginRow.getMin();
        int rowBottom = endRow.getMax();
        int rowCenter = rowTop + (rowBottom - rowTop) / 2;
        int topOffset = bt - rowTop;
        int bottomOffset = rowBottom - bb;
        int topDelta = topOffset + Math.abs(rowTop + prefSize.height - bb);
        int bottomDelta = bottomOffset + Math.abs(rowBottom - prefSize.height - bt);
        int fillDelta = topOffset + bottomOffset;
        int centerDelta = Math.abs(bt - (rowCenter - prefSize.height / 2)) + Math.abs(bb - (rowCenter + prefSize.height / 2));
        return FormLayoutConverter.getAlignment(new int[]{topDelta, centerDelta, bottomDelta, fillDelta}, new CellConstraints.Alignment[]{CellConstraints.TOP, CellConstraints.CENTER, CellConstraints.BOTTOM, CellConstraints.FILL});
    }

    private static CellConstraints.Alignment getAlignment(int[] deltas, CellConstraints.Alignment[] alignments) {
        int minimum = Integer.MAX_VALUE;
        int i = 0;
        while (i < deltas.length) {
            int delta = deltas[i];
            minimum = Math.min(minimum, delta);
            ++i;
        }
        return alignments[ArrayUtils.indexOf((int[])deltas, (int)minimum)];
    }
}

